# AUTOGENERATED! DO NOT EDIT! File to edit: ../20_HolesFilling.ipynb.

# %% auto 0
__all__ = ['HolesFilling']

# %% ../20_HolesFilling.ipynb 2
from .holemakertechnique import *
from .regionmodifier import RegionModifier
from .holemakerrandom import *
import numpy as np
from fastai.vision.all import Callback
from typing import Union, Callable

# %% ../20_HolesFilling.ipynb 5
class HolesFilling(Callback):
    "Defines the strategy used to make the holes."
    def __init__(self,
                 modifier: "RegionModifier" = None, # The modifier that defines the traditional augments to apply to the selected regions.
                 hole_maker: "HoleMakerTechnique" = None # The strategy used to make the holes.
        ):
        self.modifier = modifier if modifier else RegionModifier()
        self.hole_maker = hole_maker if hole_maker else HoleMakerRandom()

    def make_hole(self,
                  mask): # The mask associated with the image where the hole is going to be made.
        "Makes the holes in the mask."
        return self.hole_maker.get_hole(mask)

    def fill_hole(self,
                  image: np.ndarray, # The image where the hole is going to be made.
                  mask: np.ndarray, # The mask associated with the image where the hole is going to be made.
                  xhole: slice, # The slice that defines the x-region where the hole is.
                  yhole: slice, # The slice that defines the y-region where the hole is.
                  fill_values: Union[Callable[[np.ndarray], np.ndarray], np.ndarray, float]): # The value to fill the hole (a function to apply or a constant).
        "Fills a specific hole with something."
        if type(fill_values[0]) is np.ndarray and type(fill_values[1]) is np.ndarray:
            fill_values = self.modifier.apply(*fill_values)

        image[:, yhole, xhole] = fill_values[0](image) if callable(fill_values[0]) else fill_values[0]
        mask[yhole, xhole] = fill_values[1](mask) if callable(fill_values[1]) else fill_values[1]
