import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type Logzio::MyService::MyName::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * Your Logz.io operations token.
     *
     * @schema CfnModulePropsParameters#logzioOperationsToken
     */
    readonly logzioOperationsToken?: CfnModulePropsParametersLogzioOperationsToken;
    /**
     * Your Logz.io listener with port 8070/8071. For example https://listener.logz.io:8071.
     *
     * @schema CfnModulePropsParameters#logzioListener
     */
    readonly logzioListener?: CfnModulePropsParametersLogzioListener;
    /**
     * Log level for the function.
     *
     * @schema CfnModulePropsParameters#logzioLogLevel
     */
    readonly logzioLogLevel?: CfnModulePropsParametersLogzioLogLevel;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#logzioSecurityHubCollector
     */
    readonly logzioSecurityHubCollector?: CfnModulePropsResourcesLogzioSecurityHubCollector;
    /**
     * @schema CfnModulePropsResources#eventRule
     */
    readonly eventRule?: CfnModulePropsResourcesEventRule;
    /**
     * @schema CfnModulePropsResources#lambdaPermissions
     */
    readonly lambdaPermissions?: CfnModulePropsResourcesLambdaPermissions;
    /**
     * @schema CfnModulePropsResources#lambdaIamRole
     */
    readonly lambdaIamRole?: CfnModulePropsResourcesLambdaIamRole;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Your Logz.io operations token.
 *
 * @schema CfnModulePropsParametersLogzioOperationsToken
 */
export interface CfnModulePropsParametersLogzioOperationsToken {
    /**
     * @schema CfnModulePropsParametersLogzioOperationsToken#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioOperationsToken#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioOperationsToken' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioOperationsToken(obj: CfnModulePropsParametersLogzioOperationsToken | undefined): Record<string, any> | undefined;
/**
 * Your Logz.io listener with port 8070/8071. For example https://listener.logz.io:8071.
 *
 * @schema CfnModulePropsParametersLogzioListener
 */
export interface CfnModulePropsParametersLogzioListener {
    /**
     * @schema CfnModulePropsParametersLogzioListener#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioListener#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioListener' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioListener(obj: CfnModulePropsParametersLogzioListener | undefined): Record<string, any> | undefined;
/**
 * Log level for the function.
 *
 * @schema CfnModulePropsParametersLogzioLogLevel
 */
export interface CfnModulePropsParametersLogzioLogLevel {
    /**
     * @schema CfnModulePropsParametersLogzioLogLevel#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioLogLevel#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioLogLevel' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioLogLevel(obj: CfnModulePropsParametersLogzioLogLevel | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLogzioSecurityHubCollector
 */
export interface CfnModulePropsResourcesLogzioSecurityHubCollector {
    /**
     * @schema CfnModulePropsResourcesLogzioSecurityHubCollector#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLogzioSecurityHubCollector#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLogzioSecurityHubCollector' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLogzioSecurityHubCollector(obj: CfnModulePropsResourcesLogzioSecurityHubCollector | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesEventRule
 */
export interface CfnModulePropsResourcesEventRule {
    /**
     * @schema CfnModulePropsResourcesEventRule#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesEventRule#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesEventRule' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesEventRule(obj: CfnModulePropsResourcesEventRule | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLambdaPermissions
 */
export interface CfnModulePropsResourcesLambdaPermissions {
    /**
     * @schema CfnModulePropsResourcesLambdaPermissions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLambdaPermissions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLambdaPermissions' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLambdaPermissions(obj: CfnModulePropsResourcesLambdaPermissions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLambdaIamRole
 */
export interface CfnModulePropsResourcesLambdaIamRole {
    /**
     * @schema CfnModulePropsResourcesLambdaIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLambdaIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLambdaIamRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLambdaIamRole(obj: CfnModulePropsResourcesLambdaIamRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Logzio::MyService::MyName::MODULE`.
 *
 * @external
 * @cloudformationResource Logzio::MyService::MyName::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Logzio::MyService::MyName::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `Logzio::MyService::MyName::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
