# pulp_certguard-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.1.0rc4
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_certguard
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_certguard
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import pulpcore.client.pulp_certguard
from pulpcore.client.pulp_certguard.rest import ApiException
from pprint import pprint

configuration = pulpcore.client.pulp_certguard.Configuration()
# Configure HTTP basic authorization: Basic
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# Defining host is optional and default to http://localhost:24817
configuration.host = "http://localhost:24817"
# Enter a context with an instance of the API client
with pulpcore.client.pulp_certguard.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_certguard.ContentguardsRhsmApi(api_client)
    data = pulpcore.client.pulp_certguard.CertguardRHSMCertGuard() # CertguardRHSMCertGuard | 

    try:
        # Create a rhsm cert guard
        api_response = api_instance.create(data)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentguardsRhsmApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:24817*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentguardsRhsmApi* | [**create**](docs/ContentguardsRhsmApi.md#create) | **POST** /pulp/api/v3/contentguards/certguard/rhsm/ | Create a rhsm cert guard
*ContentguardsRhsmApi* | [**delete**](docs/ContentguardsRhsmApi.md#delete) | **DELETE** {r_h_s_m_cert_guard_href} | Delete a rhsm cert guard
*ContentguardsRhsmApi* | [**list**](docs/ContentguardsRhsmApi.md#list) | **GET** /pulp/api/v3/contentguards/certguard/rhsm/ | List rhsm cert guards
*ContentguardsRhsmApi* | [**partial_update**](docs/ContentguardsRhsmApi.md#partial_update) | **PATCH** {r_h_s_m_cert_guard_href} | Partially update a rhsm cert guard
*ContentguardsRhsmApi* | [**read**](docs/ContentguardsRhsmApi.md#read) | **GET** {r_h_s_m_cert_guard_href} | Inspect a rhsm cert guard
*ContentguardsRhsmApi* | [**update**](docs/ContentguardsRhsmApi.md#update) | **PUT** {r_h_s_m_cert_guard_href} | Update a rhsm cert guard
*ContentguardsX509Api* | [**create**](docs/ContentguardsX509Api.md#create) | **POST** /pulp/api/v3/contentguards/certguard/x509/ | Create a x509 cert guard
*ContentguardsX509Api* | [**delete**](docs/ContentguardsX509Api.md#delete) | **DELETE** {x509_cert_guard_href} | Delete a x509 cert guard
*ContentguardsX509Api* | [**list**](docs/ContentguardsX509Api.md#list) | **GET** /pulp/api/v3/contentguards/certguard/x509/ | List x509 cert guards
*ContentguardsX509Api* | [**partial_update**](docs/ContentguardsX509Api.md#partial_update) | **PATCH** {x509_cert_guard_href} | Partially update a x509 cert guard
*ContentguardsX509Api* | [**read**](docs/ContentguardsX509Api.md#read) | **GET** {x509_cert_guard_href} | Inspect a x509 cert guard
*ContentguardsX509Api* | [**update**](docs/ContentguardsX509Api.md#update) | **PUT** {x509_cert_guard_href} | Update a x509 cert guard


## Documentation For Models

 - [CertguardRHSMCertGuard](docs/CertguardRHSMCertGuard.md)
 - [CertguardX509CertGuard](docs/CertguardX509CertGuard.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication


## Author




