import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostCatalogConfig extends cdktf.TerraformMetaArguments {
    /**
    * The host catalog description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog#description HostCatalog#description}
    */
    readonly description?: string;
    /**
    * The host catalog name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog#name HostCatalog#name}
    */
    readonly name?: string;
    /**
    * The scope ID in which the resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog#scope_id HostCatalog#scope_id}
    */
    readonly scopeId: string;
    /**
    * The host catalog type. Only `static` is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog#type HostCatalog#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog boundary_host_catalog}
*/
export declare class HostCatalog extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_host_catalog";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog boundary_host_catalog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostCatalogConfig
    */
    constructor(scope: Construct, id: string, config: HostCatalogConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
