/*
 * Decompiled with CFR 0.152.
 */
package xyz.ylimit;

import java.util.ArrayList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.PackManager;
import soot.PatchingChain;
import soot.Scene;
import soot.Transform;
import soot.Unit;
import soot.options.Options;
import xyz.ylimit.Config;
import xyz.ylimit.Util;

public class Instrumenter {
    public static void configSoot() {
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_src_prec(5);
        Options.v().set_output_dir(Config.outputDir);
        Options.v().set_debug(true);
        Options.v().set_validate(true);
        Options.v().set_output_format(10);
        ArrayList<String> process_dirs = new ArrayList<String>();
        process_dirs.add(Config.inputAPK);
        Options.v().set_process_dir(process_dirs);
        Options.v().set_force_android_jar(Config.forceAndroidJarPath);
    }

    public static void instrument() {
        Util.LOGGER.info("Start instrumenting...");
        Scene.v().loadNecessaryClasses();
        PackManager.v().getPack("jtp").add(new Transform("jtp.androcov", new BodyTransformer(){

            protected void internalTransform(Body b, String phaseName, Map options) {
                PatchingChain<Unit> units = b.getUnits();
                String methodSig = b.getMethod().getSignature();
                String logStr = String.format("Instrumenting: %s", methodSig);
                Util.LOGGER.info(logStr);
            }
        }));
        PackManager.v().runPacks();
        PackManager.v().writeOutput();
    }
}

