/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.IdentityHashMap;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.AbstractFlowAnalysis;

public abstract class FlowAnalysis<N, A>
extends AbstractFlowAnalysis<N, A> {
    protected Map<N, A> unitToAfterFlow;
    protected Map<N, A> filterUnitToAfterFlow;

    public FlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
        this.unitToAfterFlow = new IdentityHashMap<N, A>(graph.size() * 2 + 1);
    }

    protected abstract void flowThrough(A var1, N var2, A var3);

    public A getFlowAfter(N s) {
        return this.unitToAfterFlow.get(s);
    }

    protected Orderer<N> constructOrderer() {
        return new PseudoTopologicalOrderer();
    }

    protected FlowInfo<A, N> getFlowInfo(N s, A flow, Map<?, A> filterFlow, boolean b) {
        Object savedFlow;
        if (filterFlow != null) {
            savedFlow = filterFlow.get(s);
            this.copy(filterFlow.get(s), savedFlow);
        } else {
            savedFlow = this.newInitialFlow();
            this.copy(flow, savedFlow);
        }
        return new FlowInfo(savedFlow, s, b);
    }

    protected void afterFlowThrough(N s, A flow, boolean handleStop) {
        InteractionHandler h = InteractionHandler.v();
        FlowInfo<A, N> fi = this.getFlowInfo(s, flow, this.filterUnitToAfterFlow, false);
        if (handleStop && h.getStopUnitList() != null && h.getStopUnitList().contains(s)) {
            h.handleStopAtNodeEvent(s);
        }
        h.handleAfterAnalysisEvent(fi);
    }

    protected void beforeFlowThrough(N s, A flow, boolean handleStop) {
        InteractionHandler h = InteractionHandler.v();
        FlowInfo<A, N> fi = this.getFlowInfo(s, flow, this.filterUnitToBeforeFlow, true);
        if (handleStop && h.getStopUnitList() != null && h.getStopUnitList().contains(s)) {
            h.handleStopAtNodeEvent(s);
        }
        h.handleBeforeAnalysisEvent(fi);
    }
}

