/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.pointer.CodeBlockRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionAwareSideEffectAnalysis;
import soot.jimple.toolkits.thread.synchronization.LocksetFlowInfo;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BackwardFlowAnalysis;

public class LockableReferenceAnalysis
extends BackwardFlowAnalysis {
    UnitGraph graph;
    SootMethod method;
    CriticalSectionAwareSideEffectAnalysis tasea;
    RWSet contributingRWSet;
    CriticalSection tn;
    Stmt begin;
    boolean lostObjects;
    Map<Ref, EquivalentValue> refToBase;
    Map<Ref, EquivalentValue> refToIndex;
    static HashSet analyzing = new HashSet();
    static int groupNum = 1;

    public LockableReferenceAnalysis(UnitGraph g) {
        super(g);
        this.graph = g;
        this.method = g.getBody().getMethod();
        this.contributingRWSet = null;
        this.tn = null;
        this.begin = null;
        this.lostObjects = false;
        this.refToBase = new HashMap<Ref, EquivalentValue>();
        this.refToIndex = new HashMap<Ref, EquivalentValue>();
    }

    public void printMsg(String msg) {
        G.v().out.print("[wjtp.tn] ");
        for (int i = 0; i < analyzing.size() - 1; ++i) {
            G.v().out.print("  ");
        }
        G.v().out.println(msg);
    }

    public List<EquivalentValue> getLocksetOf(CriticalSectionAwareSideEffectAnalysis tasea, RWSet contributingRWSet, CriticalSection tn) {
        analyzing.add(this.method);
        this.tasea = tasea;
        tasea.setExemptTransaction(tn);
        this.contributingRWSet = contributingRWSet;
        this.tn = tn;
        this.begin = tn == null ? null : tn.beginning;
        this.lostObjects = false;
        this.doAnalysis();
        if (this.lostObjects) {
            this.printMsg("Failed lockset:");
            analyzing.remove(this.method);
            return null;
        }
        ArrayList<EquivalentValue> lockset = new ArrayList<EquivalentValue>();
        LocksetFlowInfo resultsInfo = null;
        Map<EquivalentValue, Integer> results = null;
        if (this.begin == null) {
            Iterator<Unit> it = this.graph.iterator();
            if (it.hasNext()) {
                resultsInfo = (LocksetFlowInfo)this.getFlowBefore(it.next());
            }
        } else {
            resultsInfo = (LocksetFlowInfo)this.getFlowBefore(this.begin);
        }
        if (resultsInfo == null) {
            analyzing.remove(this.method);
            throw new RuntimeException("Why is getFlowBefore null???");
        }
        results = resultsInfo.groups;
        HashMap reversed = new HashMap();
        for (EquivalentValue key : results.keySet()) {
            List<EquivalentValue> keys;
            Integer value = results.get(key);
            if (!reversed.containsKey(value)) {
                keys = new ArrayList();
                reversed.put(value, keys);
            } else {
                keys = (List)reversed.get(value);
            }
            keys.add(key);
        }
        for (List objects : reversed.values()) {
            EquivalentValue bestLock = null;
            for (EquivalentValue object : objects) {
                if (bestLock != null && !(object.getValue() instanceof IdentityRef) && (!(object.getValue() instanceof Ref) || bestLock instanceof IdentityRef)) continue;
                bestLock = object;
            }
            Integer group = results.get(bestLock);
            for (Ref ref : resultsInfo.refToBaseGroup.keySet()) {
                if (group != resultsInfo.refToBaseGroup.get(ref)) continue;
                this.refToBase.put(ref, bestLock);
            }
            for (Ref ref : resultsInfo.refToIndexGroup.keySet()) {
                if (group != resultsInfo.refToIndexGroup.get(ref)) continue;
                this.refToIndex.put(ref, bestLock);
            }
            if (group < 0) continue;
            lockset.add(bestLock);
        }
        if (lockset.size() == 0) {
            this.printMsg("Empty lockset: S" + lockset.size() + "/G" + reversed.keySet().size() + "/O" + results.keySet().size() + " Method:" + this.method + " Begin:" + this.begin + " Result:" + results + " RW:" + contributingRWSet);
            this.printMsg("|= results:" + results + " refToBaseGroup:" + resultsInfo.refToBaseGroup);
        } else {
            this.printMsg("Healthy lockset: S" + lockset.size() + "/G" + reversed.keySet().size() + "/O" + results.keySet().size() + " " + lockset + " refToBase:" + this.refToBase + " refToIndex:" + this.refToIndex);
            this.printMsg("|= results:" + results + " refToBaseGroup:" + resultsInfo.refToBaseGroup);
        }
        analyzing.remove(this.method);
        return lockset;
    }

    public EquivalentValue baseFor(Ref ref) {
        return this.refToBase.get(ref);
    }

    public EquivalentValue indexFor(Ref ref) {
        return this.refToIndex.get(ref);
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        LocksetFlowInfo in1Info = (LocksetFlowInfo)in1;
        LocksetFlowInfo in2Info = (LocksetFlowInfo)in2;
        LocksetFlowInfo outInfo = (LocksetFlowInfo)out;
        Map<EquivalentValue, Integer> inMap1 = in1Info.groups;
        Map<EquivalentValue, Integer> inMap2 = in2Info.groups;
        LocksetFlowInfo tmpInfo = new LocksetFlowInfo();
        this.copy(in1Info, outInfo);
        this.copy(in2Info, tmpInfo);
        for (EquivalentValue key : tmpInfo.groups.keySet()) {
            Map.Entry<Value, Integer> entry;
            Integer newvalue = tmpInfo.groups.get(key);
            if (!outInfo.groups.containsKey(key)) {
                outInfo.groups.put(key, newvalue);
                continue;
            }
            if (outInfo.groups.get(key) == tmpInfo.groups.get(key)) continue;
            Integer oldvalue = outInfo.groups.get(key);
            for (Map.Entry<EquivalentValue, Integer> entry2 : outInfo.groups.entrySet()) {
                entry = entry2;
                if (entry.getValue() != oldvalue) continue;
                entry.setValue(newvalue);
            }
            for (Map.Entry<EquivalentValue, Integer> entry3 : tmpInfo.groups.entrySet()) {
                entry = entry3;
                if (entry.getValue() != oldvalue) continue;
                entry.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry4 : outInfo.refToBaseGroup.entrySet()) {
                entry = entry4;
                if (entry.getValue() != oldvalue) continue;
                entry.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry5 : outInfo.refToIndexGroup.entrySet()) {
                entry = entry5;
                if (entry.getValue() != oldvalue) continue;
                entry.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry6 : tmpInfo.refToBaseGroup.entrySet()) {
                entry = entry6;
                if (entry.getValue() != oldvalue) continue;
                entry.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry7 : tmpInfo.refToIndexGroup.entrySet()) {
                entry = entry7;
                if (entry.getValue() != oldvalue) continue;
                entry.setValue(newvalue);
            }
        }
        for (Ref ref : tmpInfo.refToBaseGroup.keySet()) {
            if (outInfo.refToBaseGroup.containsKey(ref)) continue;
            outInfo.refToBaseGroup.put(ref, tmpInfo.refToBaseGroup.get(ref));
        }
        for (Ref ref : tmpInfo.refToIndexGroup.keySet()) {
            if (outInfo.refToIndexGroup.containsKey(ref)) continue;
            outInfo.refToIndexGroup.put(ref, tmpInfo.refToIndexGroup.get(ref));
        }
    }

    public Integer addFromSubanalysis(LocksetFlowInfo outInfo, LockableReferenceAnalysis la, Stmt stmt, Value lock) {
        Map<EquivalentValue, Integer> out = outInfo.groups;
        InvokeExpr ie = stmt.getInvokeExpr();
        this.printMsg("Attempting to bring up '" + lock + "' from inner lockset at (" + stmt.hashCode() + ") " + stmt);
        if (lock instanceof ThisRef && ie instanceof InstanceInvokeExpr) {
            Value use = ((InstanceInvokeExpr)ie).getBase();
            if (!out.containsKey(new EquivalentValue(use))) {
                Integer newGroup = new Integer(groupNum++);
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof ParameterRef) {
            Value use = ie.getArg(((ParameterRef)lock).getIndex());
            if (!out.containsKey(new EquivalentValue(use))) {
                Integer newGroup = new Integer(groupNum++);
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof StaticFieldRef) {
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                Integer newGroup = new Integer(groupNum++);
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof InstanceFieldRef) {
            EquivalentValue baseEqVal;
            if (((InstanceFieldRef)lock).getBase() instanceof FakeJimpleLocal) {
                ((FakeJimpleLocal)((InstanceFieldRef)lock).getBase()).setInfo(this);
            }
            if ((baseEqVal = la.baseFor((Ref)lock)) == null) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ previously lost base) at " + stmt);
                return 0;
            }
            Value base = baseEqVal.getValue();
            Integer baseGroup = this.addFromSubanalysis(outInfo, la, stmt, base);
            if (baseGroup == 0) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ newly lost base) at " + stmt);
                return 0;
            }
            outInfo.refToBaseGroup.put((Ref)lock, baseGroup);
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                Integer newGroup = new Integer(groupNum++);
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof ArrayRef) {
            if (((ArrayRef)lock).getBase() instanceof FakeJimpleLocal) {
                ((FakeJimpleLocal)((ArrayRef)lock).getBase()).setInfo(this);
            }
            if (((ArrayRef)lock).getIndex() instanceof FakeJimpleLocal) {
                ((FakeJimpleLocal)((ArrayRef)lock).getIndex()).setInfo(this);
            }
            EquivalentValue baseEqVal = la.baseFor((Ref)lock);
            EquivalentValue indexEqVal = la.indexFor((Ref)lock);
            if (baseEqVal == null) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ previously lost base) at " + stmt);
                return 0;
            }
            if (indexEqVal == null) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ previously lost index) at " + stmt);
                return 0;
            }
            Value base = baseEqVal.getValue();
            Value index = indexEqVal.getValue();
            Integer baseGroup = this.addFromSubanalysis(outInfo, la, stmt, base);
            if (baseGroup == 0) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ newly lost base) at " + stmt);
                return 0;
            }
            Integer indexGroup = this.addFromSubanalysis(outInfo, la, stmt, index);
            if (indexGroup == 0) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ newly lost index) at " + stmt);
                return 0;
            }
            outInfo.refToBaseGroup.put((Ref)lock, baseGroup);
            outInfo.refToIndexGroup.put((Ref)lock, indexGroup);
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                Integer newGroup = new Integer(groupNum++);
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof Constant) {
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                Integer newGroup = new Integer(groupNum++);
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        this.printMsg("Lost Object from inner Lockset (unknown or unhandled object type) at " + stmt);
        return 0;
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        LocksetFlowInfo inInfo = (LocksetFlowInfo)inValue;
        LocksetFlowInfo outInfo = (LocksetFlowInfo)outValue;
        this.merge(inInfo, outInfo.clone(), outInfo);
        Stmt stmt = (Stmt)unit;
        Map<EquivalentValue, Integer> out = outInfo.groups;
        if ((this.tn == null || this.tn.units.contains(stmt)) && !this.lostObjects) {
            RWSet stmtWrite;
            CodeBlockRWSet stmtRW = null;
            HashSet allUses = new HashSet();
            RWSet stmtRead = this.tasea.readSet(this.method, stmt, this.tn, allUses);
            if (stmtRead != null) {
                stmtRW = (CodeBlockRWSet)stmtRead;
            }
            if ((stmtWrite = this.tasea.writeSet(this.method, stmt, this.tn, allUses)) != null) {
                if (stmtRW != null) {
                    stmtRW.union(stmtWrite);
                } else {
                    stmtRW = (CodeBlockRWSet)stmtWrite;
                }
            }
            if (stmtRW != null && stmtRW.hasNonEmptyIntersection(this.contributingRWSet)) {
                ArrayRef ar;
                ArrayList<Value> uses = new ArrayList<Value>();
                Iterator allUsesIt = allUses.iterator();
                while (allUsesIt.hasNext()) {
                    RWSet valRW;
                    FieldRef fr;
                    Value value;
                    Value v = value = (Value)allUsesIt.next();
                    if (stmt.containsFieldRef() && (fr = stmt.getFieldRef()) instanceof InstanceFieldRef && ((InstanceFieldRef)fr).getBase() == v) {
                        v = fr;
                    }
                    if (stmt.containsArrayRef() && (ar = stmt.getArrayRef()).getBase() == v) {
                        v = ar;
                    }
                    if ((valRW = this.tasea.valueRWSet(v, this.method, stmt, this.tn)) == null || !valRW.hasNonEmptyIntersection(this.contributingRWSet)) continue;
                    uses.add(value);
                }
                if (stmt.containsInvokeExpr()) {
                    InvokeExpr invokeExpr = stmt.getInvokeExpr();
                    SootMethod called = invokeExpr.getMethod();
                    if (called.isConcrete()) {
                        if (called.getDeclaringClass().toString().startsWith("java.util") || called.getDeclaringClass().toString().startsWith("java.lang")) {
                            if (uses.size() <= 0) {
                                this.printMsg("Lost Object at library call at " + stmt);
                                this.lostObjects = true;
                            }
                        } else if (!analyzing.contains(called)) {
                            LockableReferenceAnalysis la = new LockableReferenceAnalysis(new BriefUnitGraph(called.retrieveActiveBody()));
                            List<EquivalentValue> innerLockset = la.getLocksetOf(this.tasea, stmtRW, null);
                            if (innerLockset == null || innerLockset.size() <= 0) {
                                this.printMsg("innerLockset: " + (innerLockset == null ? "Lost Objects" : "Mysteriously Empty"));
                                this.lostObjects = true;
                            } else {
                                this.printMsg("innerLockset: " + innerLockset.toString());
                                for (EquivalentValue lockEqVal : innerLockset) {
                                    Value lock = lockEqVal.getValue();
                                    if (this.addFromSubanalysis(outInfo, la, stmt, lock) != 0) continue;
                                    this.lostObjects = true;
                                    this.printMsg("Lost Object in addFromSubanalysis()");
                                    break;
                                }
                            }
                        } else {
                            this.lostObjects = true;
                            this.printMsg("Lost Object due to recursion " + stmt);
                        }
                    } else if (uses.size() <= 0) {
                        this.lostObjects = true;
                        this.printMsg("Lost Object from non-concrete method call at " + stmt);
                    }
                } else if (uses.size() <= 0) {
                    this.lostObjects = true;
                    this.printMsg("Lost Object SOMEHOW at " + stmt);
                }
                Iterator iterator = uses.iterator();
                while (iterator.hasNext() && !this.lostObjects) {
                    Local oldbase;
                    Value use = (Value)iterator.next();
                    if (use instanceof InstanceFieldRef) {
                        InstanceFieldRef ifr = (InstanceFieldRef)use;
                        oldbase = (Local)ifr.getBase();
                        if (!(oldbase instanceof FakeJimpleLocal)) {
                            FakeJimpleLocal newbase = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                            InstanceFieldRef node = Jimple.v().newInstanceFieldRef(newbase, ifr.getField().makeRef());
                            EquivalentValue nodeEqVal = new EquivalentValue(node);
                            use = node;
                        }
                    } else if (use instanceof ArrayRef) {
                        ar = (ArrayRef)use;
                        oldbase = (Local)ar.getBase();
                        Value oldindex = ar.getIndex();
                        if (!(oldbase instanceof FakeJimpleLocal)) {
                            FakeJimpleLocal newbase = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                            Value newindex = oldindex instanceof Local ? new FakeJimpleLocal("fakeindex", oldindex.getType(), (Local)oldindex, this) : oldindex;
                            ArrayRef node = Jimple.v().newArrayRef(newbase, newindex);
                            EquivalentValue nodeEqVal = new EquivalentValue(node);
                            use = node;
                        }
                    }
                    if (out.containsKey(new EquivalentValue(use))) continue;
                    out.put(new EquivalentValue(use), new Integer(groupNum++));
                }
            }
        }
        if (this.graph.getBody().getUnits().getSuccOf(stmt) == this.begin) {
            out.clear();
        }
        if ((this.tn == null || this.tn.units.contains(stmt)) && !out.isEmpty() && stmt instanceof DefinitionStmt && !this.lostObjects) {
            Value newindex;
            Local oldbase;
            FakeJimpleLocal newbase;
            DefinitionStmt ds = (DefinitionStmt)stmt;
            EquivalentValue lvalue = new EquivalentValue(ds.getLeftOp());
            if (ds.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)ds.getLeftOp();
                Local oldbase2 = (Local)ifr.getBase();
                if (!(oldbase2 instanceof FakeJimpleLocal)) {
                    EquivalentValue equivalentValue;
                    FakeJimpleLocal newbase2 = new FakeJimpleLocal("fakethis", oldbase2.getType(), oldbase2, this);
                    InstanceFieldRef node = Jimple.v().newInstanceFieldRef(newbase2, ifr.getField().makeRef());
                    lvalue = equivalentValue = new EquivalentValue(node);
                }
            } else if (ds.getLeftOp() instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)ds.getLeftOp();
                Local oldbase2 = (Local)ar.getBase();
                Value oldindex = ar.getIndex();
                if (!(oldbase2 instanceof FakeJimpleLocal)) {
                    EquivalentValue nodeEqVal;
                    newbase = new FakeJimpleLocal("fakethis", oldbase2.getType(), oldbase2, this);
                    Value value = oldindex instanceof Local ? new FakeJimpleLocal("fakeindex", oldindex.getType(), (Local)oldindex, this) : oldindex;
                    ArrayRef node = Jimple.v().newArrayRef(newbase, value);
                    lvalue = nodeEqVal = new EquivalentValue(node);
                }
            }
            EquivalentValue rvalue = new EquivalentValue(ds.getRightOp());
            if (ds.getRightOp() instanceof CastExpr) {
                rvalue = new EquivalentValue(((CastExpr)ds.getRightOp()).getOp());
            } else if (ds.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)ds.getRightOp();
                oldbase = (Local)ifr.getBase();
                if (!(oldbase instanceof FakeJimpleLocal)) {
                    EquivalentValue nodeEqVal;
                    newbase = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                    InstanceFieldRef instanceFieldRef = Jimple.v().newInstanceFieldRef(newbase, ifr.getField().makeRef());
                    rvalue = nodeEqVal = new EquivalentValue(instanceFieldRef);
                }
            } else if (ds.getRightOp() instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)ds.getRightOp();
                oldbase = (Local)ar.getBase();
                Value oldindex = ar.getIndex();
                if (!(oldbase instanceof FakeJimpleLocal)) {
                    EquivalentValue nodeEqVal;
                    FakeJimpleLocal fakeJimpleLocal = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                    newindex = oldindex instanceof Local ? new FakeJimpleLocal("fakeindex", oldindex.getType(), (Local)oldindex, this) : oldindex;
                    ArrayRef node = Jimple.v().newArrayRef(fakeJimpleLocal, newindex);
                    rvalue = nodeEqVal = new EquivalentValue(node);
                }
            }
            if (out.containsKey(lvalue)) {
                Map.Entry<Value, Integer> entry;
                Integer rvaluevalue;
                Integer lvaluevalue = out.get(lvalue);
                if (stmt instanceof IdentityStmt) {
                    if (out.containsKey(rvalue)) {
                        rvaluevalue = out.get(rvalue);
                        for (Map.Entry<EquivalentValue, Integer> entry2 : out.entrySet()) {
                            entry = entry2;
                            if (entry.getValue() != lvaluevalue) continue;
                            entry.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry3 : outInfo.refToBaseGroup.entrySet()) {
                            entry = entry3;
                            if (entry.getValue() != lvaluevalue) continue;
                            entry.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry4 : outInfo.refToIndexGroup.entrySet()) {
                            entry = entry4;
                            if (entry.getValue() != lvaluevalue) continue;
                            entry.setValue(rvaluevalue);
                        }
                    } else {
                        out.put(rvalue, lvaluevalue);
                    }
                } else {
                    if (out.containsKey(rvalue)) {
                        rvaluevalue = out.get(rvalue);
                        for (Map.Entry<EquivalentValue, Integer> entry5 : out.entrySet()) {
                            entry = entry5;
                            if (entry.getValue() != lvaluevalue) continue;
                            entry.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry6 : outInfo.refToBaseGroup.entrySet()) {
                            entry = entry6;
                            if (entry.getValue() != lvaluevalue) continue;
                            entry.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry7 : outInfo.refToIndexGroup.entrySet()) {
                            entry = entry7;
                            if (entry.getValue() != lvaluevalue) continue;
                            entry.setValue(rvaluevalue);
                        }
                    } else if (rvalue.getValue() instanceof Local || rvalue.getValue() instanceof StaticFieldRef || rvalue.getValue() instanceof Constant) {
                        out.put(rvalue, lvaluevalue);
                    } else if (rvalue.getValue() instanceof InstanceFieldRef) {
                        InstanceFieldRef ifr = (InstanceFieldRef)rvalue.getValue();
                        newbase = (FakeJimpleLocal)ifr.getBase();
                        Local local = newbase.getRealLocal();
                        out.put(rvalue, lvaluevalue);
                        Integer baseGroup = out.containsKey(new EquivalentValue(local)) ? out.get(new EquivalentValue(local)) : new Integer(-groupNum++);
                        if (!outInfo.refToBaseGroup.containsKey(ifr)) {
                            outInfo.refToBaseGroup.put(ifr, baseGroup);
                        }
                        out.put(new EquivalentValue(local), baseGroup);
                    } else if (rvalue.getValue() instanceof ArrayRef) {
                        ArrayRef ar = (ArrayRef)rvalue.getValue();
                        newbase = (FakeJimpleLocal)ar.getBase();
                        Local local = newbase.getRealLocal();
                        newindex = ar.getIndex() instanceof FakeJimpleLocal ? (FakeJimpleLocal)ar.getIndex() : null;
                        Value oldindex = newindex != null ? ((FakeJimpleLocal)newindex).getRealLocal() : ar.getIndex();
                        out.put(rvalue, lvaluevalue);
                        Integer indexGroup = out.containsKey(new EquivalentValue(oldindex)) ? out.get(new EquivalentValue(oldindex)) : new Integer(-groupNum++);
                        if (!outInfo.refToIndexGroup.containsKey(ar)) {
                            outInfo.refToIndexGroup.put(ar, indexGroup);
                        }
                        out.put(new EquivalentValue(oldindex), indexGroup);
                        Integer baseGroup = out.containsKey(new EquivalentValue(local)) ? out.get(new EquivalentValue(local)) : new Integer(-groupNum++);
                        if (!outInfo.refToBaseGroup.containsKey(ar)) {
                            outInfo.refToBaseGroup.put(ar, baseGroup);
                        }
                        out.put(new EquivalentValue(local), baseGroup);
                    } else if (rvalue.getValue() instanceof AnyNewExpr) {
                        this.printMsg("Ignored Object (assigned new value) at " + stmt);
                    } else {
                        this.printMsg("Lost Object (assigned unacceptable value) at " + stmt);
                        this.lostObjects = true;
                    }
                    out.remove(lvalue);
                }
            }
        }
    }

    @Override
    protected void copy(Object source, Object dest) {
        LocksetFlowInfo sourceInfo = (LocksetFlowInfo)source;
        LocksetFlowInfo destInfo = (LocksetFlowInfo)dest;
        destInfo.groups.clear();
        destInfo.groups.putAll(sourceInfo.groups);
        destInfo.refToBaseGroup.clear();
        destInfo.refToBaseGroup.putAll(sourceInfo.refToBaseGroup);
        destInfo.refToIndexGroup.clear();
        destInfo.refToIndexGroup.putAll(sourceInfo.refToIndexGroup);
    }

    @Override
    protected Object entryInitialFlow() {
        return new LocksetFlowInfo();
    }

    @Override
    protected Object newInitialFlow() {
        return new LocksetFlowInfo();
    }
}

