/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;

public class ToppedSet<T>
extends AbstractFlowSet<T> {
    FlowSet<T> underlyingSet;
    boolean isTop;

    public void setTop(boolean top) {
        this.isTop = top;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public ToppedSet(FlowSet<T> under) {
        this.underlyingSet = under;
    }

    @Override
    public ToppedSet<T> clone() {
        ToppedSet<T> newSet = new ToppedSet<T>(this.underlyingSet.clone());
        newSet.setTop(this.isTop());
        return newSet;
    }

    @Override
    public void copy(FlowSet<T> d) {
        ToppedSet dest = (ToppedSet)d;
        if (!this.isTop()) {
            this.underlyingSet.copy(dest.underlyingSet);
            dest.setTop(false);
            return;
        }
        dest.setTop(true);
    }

    @Override
    public FlowSet<T> emptySet() {
        return new ToppedSet<T>(this.underlyingSet.emptySet());
    }

    @Override
    public void clear() {
        this.isTop = false;
        this.underlyingSet.clear();
    }

    @Override
    public void union(FlowSet<T> o, FlowSet<T> d) {
        if (o instanceof ToppedSet && d instanceof ToppedSet) {
            ToppedSet other = (ToppedSet)o;
            ToppedSet dest = (ToppedSet)d;
            if (this.isTop()) {
                this.copy(dest);
                return;
            }
            if (other.isTop()) {
                other.copy(dest);
            } else {
                this.underlyingSet.union(other.underlyingSet, dest.underlyingSet);
                dest.setTop(false);
            }
        } else {
            super.union(o, d);
        }
    }

    @Override
    public void intersection(FlowSet<T> o, FlowSet<T> d) {
        if (this.isTop()) {
            o.copy(d);
            return;
        }
        ToppedSet other = (ToppedSet)o;
        ToppedSet dest = (ToppedSet)d;
        if (other.isTop()) {
            this.copy(dest);
            return;
        }
        this.underlyingSet.intersection(other.underlyingSet, dest.underlyingSet);
        dest.setTop(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void difference(FlowSet<T> o, FlowSet<T> d) {
        ToppedSet other = (ToppedSet)o;
        ToppedSet dest = (ToppedSet)d;
        if (this.isTop()) {
            if (other.isTop()) {
                dest.clear();
                return;
            } else {
                if (!(other.underlyingSet instanceof BoundedFlowSet)) throw new RuntimeException("can't take difference!");
                ((BoundedFlowSet)other.underlyingSet).complement(dest);
            }
            return;
        } else if (other.isTop()) {
            dest.clear();
            return;
        } else {
            this.underlyingSet.difference(other.underlyingSet, dest.underlyingSet);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.isTop()) {
            return false;
        }
        return this.underlyingSet.isEmpty();
    }

    @Override
    public int size() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.size();
    }

    @Override
    public void add(T obj) {
        if (this.isTop()) {
            return;
        }
        this.underlyingSet.add(obj);
    }

    @Override
    public void remove(T obj) {
        if (this.isTop()) {
            return;
        }
        this.underlyingSet.remove(obj);
    }

    @Override
    public boolean contains(T obj) {
        if (this.isTop()) {
            return true;
        }
        return this.underlyingSet.contains(obj);
    }

    @Override
    public List<T> toList() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.toList();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ToppedSet)) {
            return false;
        }
        ToppedSet other = (ToppedSet)o;
        if (other.isTop() != this.isTop()) {
            return false;
        }
        return this.underlyingSet.equals(other.underlyingSet);
    }

    @Override
    public String toString() {
        if (this.isTop()) {
            return "{TOP}";
        }
        return this.underlyingSet.toString();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.iterator();
    }
}

