/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.base.Zonation;
import soot.jimple.toolkits.base.Zone;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

public class Aggregator
extends BodyTransformer {
    public Aggregator(Singletons.Global g) {
    }

    public static Aggregator v() {
        return G.v().soot_jimple_toolkits_base_Aggregator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        StmtBody body = (StmtBody)b;
        boolean onlyStackVars = PhaseOptions.getBoolean(options, "only-stack-locals");
        int aggregateCount = 1;
        if (Options.v().time()) {
            Timers.v().aggregationTimer.start();
        }
        boolean changed = false;
        HashMap<ValueBox, Zone> boxToZone = new HashMap<ValueBox, Zone>(body.getUnits().size() * 2 + 1, 0.7f);
        Zonation zonation = new Zonation(body);
        for (Unit u : body.getUnits()) {
            Zone zone = zonation.getZoneOf(u);
            for (ValueBox box : u.getUseBoxes()) {
                boxToZone.put(box, zone);
            }
            for (ValueBox box : u.getDefBoxes()) {
                boxToZone.put(box, zone);
            }
        }
        do {
            if (Options.v().verbose()) {
                G.v().out.println("[" + body.getMethod().getName() + "] Aggregating iteration " + aggregateCount + "...");
            }
            changed = Aggregator.internalAggregate(body, boxToZone, onlyStackVars);
            ++aggregateCount;
        } while (changed);
        if (Options.v().time()) {
            Timers.v().aggregationTimer.end();
        }
    }

    private static boolean internalAggregate(StmtBody body, Map<ValueBox, Zone> boxToZone, boolean onlyStackVars) {
        boolean hadAggregation = false;
        PatchingChain<Unit> units = body.getUnits();
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
        SmartLocalDefs localDefs = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        SimpleLocalUses localUses = new SimpleLocalUses(graph, (LocalDefs)localDefs);
        List<Unit> unitList = new PseudoTopologicalOrderer<Unit>().newList(graph, false);
        for (Unit u : unitList) {
            Value aggregatee;
            List<UnitValueBoxPair> lu;
            AssignStmt s;
            Value lhs;
            if (!(u instanceof AssignStmt) || !((lhs = (s = (AssignStmt)u).getLeftOp()) instanceof Local)) continue;
            Local lhsLocal = (Local)lhs;
            if (onlyStackVars && !lhsLocal.getName().startsWith("$") || (lu = localUses.getUsesOf(s)).size() != 1) continue;
            UnitValueBoxPair usepair = lu.get(0);
            Unit use = usepair.unit;
            ValueBox useBox = usepair.valueBox;
            List<Unit> ld = localDefs.getDefsOfAt(lhsLocal, use);
            if (ld.size() != 1 || boxToZone.get(s.getRightOpBox()) != boxToZone.get(usepair.valueBox)) continue;
            boolean cantAggr = false;
            boolean propagatingInvokeExpr = false;
            boolean propagatingFieldRef = false;
            boolean propagatingArrayRef = false;
            ArrayList<FieldRef> fieldRefList = new ArrayList<FieldRef>();
            LinkedList<Value> localsUsed = new LinkedList<Value>();
            for (ValueBox vb : s.getUseBoxes()) {
                Value v = vb.getValue();
                if (v instanceof Local) {
                    localsUsed.add(v);
                    continue;
                }
                if (v instanceof InvokeExpr) {
                    propagatingInvokeExpr = true;
                    continue;
                }
                if (v instanceof ArrayRef) {
                    propagatingArrayRef = true;
                    continue;
                }
                if (!(v instanceof FieldRef)) continue;
                propagatingFieldRef = true;
                fieldRefList.add((FieldRef)v);
            }
            List<Unit> path = graph.getExtendedBasicBlockPathBetween(s, use);
            if (path == null) continue;
            Iterator<Unit> pathIt = path.iterator();
            if (pathIt.hasNext()) {
                pathIt.next();
            }
            block2: while (pathIt.hasNext() && !cantAggr) {
                Value v;
                Stmt between = (Stmt)pathIt.next();
                if (between != use) {
                    block3: for (ValueBox vb : between.getDefBoxes()) {
                        v = vb.getValue();
                        if (localsUsed.contains(v)) {
                            cantAggr = true;
                            break;
                        }
                        if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                        if (v instanceof FieldRef) {
                            if (propagatingInvokeExpr) {
                                cantAggr = true;
                                break;
                            }
                            if (!propagatingFieldRef) continue;
                            for (FieldRef fieldRef : fieldRefList) {
                                if (((FieldRef)v).getField() != fieldRef.getField()) continue;
                                cantAggr = true;
                                continue block3;
                            }
                            continue;
                        }
                        if (!(v instanceof ArrayRef)) continue;
                        if (propagatingInvokeExpr) {
                            cantAggr = true;
                            break;
                        }
                        if (!propagatingArrayRef) continue;
                        cantAggr = true;
                        break;
                    }
                    if (propagatingInvokeExpr && between instanceof MonitorStmt) {
                        cantAggr = true;
                    }
                }
                if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                for (ValueBox box : between.getUseBoxes()) {
                    if (between == use && box == useBox) continue block2;
                    v = box.getValue();
                    if (!(v instanceof InvokeExpr) && (!propagatingInvokeExpr || !(v instanceof FieldRef) && !(v instanceof ArrayRef))) continue;
                    cantAggr = true;
                    continue block2;
                }
            }
            if (cantAggr || !usepair.valueBox.canContainValue(aggregatee = s.getRightOp())) continue;
            boolean wasSimpleCopy = Aggregator.isSimpleCopy(usepair.unit);
            usepair.valueBox.setValue(aggregatee);
            units.remove(s);
            hadAggregation = true;
            if (!wasSimpleCopy) continue;
            usepair.unit.addAllTagsOf(s);
        }
        return hadAggregation;
    }

    private static boolean isSimpleCopy(Unit u) {
        if (!(u instanceof DefinitionStmt)) {
            return false;
        }
        DefinitionStmt defstmt = (DefinitionStmt)u;
        if (!(defstmt.getRightOp() instanceof Local)) {
            return false;
        }
        return defstmt.getLeftOp() instanceof Local;
    }
}

