/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.callgraph;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.MethodOrMethodContext;
import soot.MethodToContexts;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.tagkit.Host;
import soot.tagkit.LinkTag;

public class CallGraphTagger
extends BodyTransformer {
    private MethodToContexts methodToContexts;

    public CallGraphTagger(Singletons.Global g) {
    }

    public static CallGraphTagger v() {
        return G.v().soot_jimple_toolkits_annotation_callgraph_CallGraphTagger();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        CallGraph cg = Scene.v().getCallGraph();
        if (this.methodToContexts == null) {
            this.methodToContexts = new MethodToContexts(Scene.v().getReachableMethods().listener());
        }
        for (Stmt stmt : b.getUnits()) {
            Iterator<Edge> edges = cg.edgesOutOf(stmt);
            while (edges.hasNext()) {
                Edge e = edges.next();
                SootMethod m = e.tgt();
                stmt.addTag(new LinkTag("CallGraph: Type: " + e.kind() + " Target Method/Context: " + e.getTgt().toString(), m, m.getDeclaringClass().getName(), "Call Graph"));
            }
        }
        SootMethod sootMethod = b.getMethod();
        for (MethodOrMethodContext momc : this.methodToContexts.get(sootMethod)) {
            Iterator<Edge> callerEdges = cg.edgesInto(momc);
            while (callerEdges.hasNext()) {
                SootMethod methodCaller;
                Edge callEdge = callerEdges.next();
                Host src = methodCaller = callEdge.src();
                if (callEdge.srcUnit() != null) {
                    src = callEdge.srcUnit();
                }
                sootMethod.addTag(new LinkTag("CallGraph: Source Type: " + callEdge.kind() + " Source Method/Context: " + callEdge.getSrc().toString(), src, methodCaller.getDeclaringClass().getName(), "Call Graph"));
            }
        }
    }
}

