/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.PrimaryExpr;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Value;

public class ParExpr
extends PrimaryExpr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ParExpr clone() throws CloneNotSupportedException {
        ParExpr node = (ParExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ParExpr copy() {
        try {
            ParExpr node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ParExpr fullCopy() {
        ParExpr tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("(");
        this.getExpr().toString(s);
        s.append(")");
    }

    @Override
    public void typeCheck() {
        if (this.getExpr().isTypeAccess()) {
            this.error("" + this.getExpr() + " is a type and may not be used in parenthesized expression");
        }
    }

    @Override
    public void emitEvalBranch(Body b) {
        this.getExpr().emitEvalBranch(b);
    }

    @Override
    public Value eval(Body b) {
        return this.getExpr().eval(b);
    }

    public ParExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public ParExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant = this.getExpr().constant();
        return constant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isConstant();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable varDecl() {
        ASTNode$State state = this.state();
        Variable variable = this.getExpr().varDecl();
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDAafterTrue(v) || this.isFalse();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDAafterFalse(v) || this.isTrue();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDAafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDUafterTrue(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDUafterFalse(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDUafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuperAccess() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isSuperAccess();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisAccess() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isThisAccess();
        return bl;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getExpr().isTypeAccess() ? this.unknownType() : this.getExpr().type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVariable() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isVariable();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().staticContextQualifier();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean bl = this.getParent().definesLabel();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canBeTrue() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().canBeTrue();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canBeFalse() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().canBeFalse();
        return bl;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

