/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "value", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "convertedFromSigned", "", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;Z)V", "getConvertedFromSigned", "()Z", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "typeConstructor", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "unknownIntegerType", "Lorg/jetbrains/kotlin/types/SimpleType;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "equals", "other", "", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "hashCode", "", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "toString", "", "Companion", "descriptors"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    private final IntegerValueTypeConstructor typeConstructor;
    @NotNull
    private final SimpleType unknownIntegerType;
    private final Number value;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    private final boolean convertedFromSigned;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (ConstantValue)new IntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (ConstantValue)new ByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (ConstantValue)new ShortValue(this.value.shortValue()) : (KotlinBuiltIns.isLong(type2) ? (ConstantValue)new LongValue(this.value.longValue()) : (KotlinBuiltIns.isUInt(type2) ? (ConstantValue)new UIntValue(this.value.intValue()) : (KotlinBuiltIns.isUByte(type2) ? (ConstantValue)new UByteValue(this.value.byteValue()) : (KotlinBuiltIns.isUShort(type2) ? (ConstantValue)new UShortValue(this.value.shortValue()) : (KotlinBuiltIns.isULong(type2) ? (ConstantValue)new ULongValue(this.value.longValue()) : (ConstantValue)new LongValue(this.value.longValue()))))))));
    }

    @NotNull
    public final SimpleType getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType kotlinType2 = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.getPrimitiveNu\u2026onstructor, expectedType)");
        return kotlinType2;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntegerValueTypeConstant && Intrinsics.areEqual(this.value, ((IntegerValueTypeConstant)other).value) && Intrinsics.areEqual(this.getParameters(), ((IntegerValueTypeConstant)other).getParameters());
    }

    @Override
    public int hashCode() {
        return 31 * this.value.hashCode() + this.getParameters().hashCode();
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public final boolean getConvertedFromSigned() {
        return this.convertedFromSigned;
    }

    public IntegerValueTypeConstant(@NotNull Number value, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2, boolean convertedFromSigned) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.value = value;
        this.parameters = parameters2;
        this.convertedFromSigned = convertedFromSigned;
        this.typeConstructor = new IntegerValueTypeConstructor(this.value.longValue(), module2, this.getParameters());
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = this.typeConstructor;
        List list2 = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor + ')', true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026$typeConstructor)\", true)");
        this.unknownIntegerType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor2, list2, false, memberScope2);
    }

    public /* synthetic */ IntegerValueTypeConstant(Number number, ModuleDescriptor moduleDescriptor, CompileTimeConstant.Parameters parameters2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(number, moduleDescriptor, parameters2, bl);
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isUnsignedNumberLiteral() {
        return CompileTimeConstant.DefaultImpls.isUnsignedNumberLiteral(this);
    }

    @JvmStatic
    @NotNull
    public static final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $receiver, @NotNull ModuleDescriptor module2) {
        return Companion.convertToUnsignedConstant($receiver, module2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant$Companion;", "", "()V", "convertToSignedConstant", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "convertToUnsignedConstant", "descriptors"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $receiver, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
            Intrinsics.checkParameterIsNotNull(module2, "module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($receiver.getParameters().getCanBeUsedInAnnotation(), $receiver.getParameters().isPure(), true, $receiver.getParameters().isUnsignedLongNumberLiteral(), $receiver.getParameters().getUsesVariableAsConstant(), $receiver.getParameters().getUsesNonConstValAsConstant(), $receiver.getParameters().isConvertableConstVal());
            return new IntegerValueTypeConstant($receiver.value, module2, newParameters, true);
        }

        @NotNull
        public final IntegerValueTypeConstant convertToSignedConstant(@NotNull IntegerValueTypeConstant $receiver, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
            Intrinsics.checkParameterIsNotNull(module2, "module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($receiver.getParameters().getCanBeUsedInAnnotation(), $receiver.getParameters().isPure(), false, $receiver.getParameters().isUnsignedLongNumberLiteral(), $receiver.getParameters().getUsesVariableAsConstant(), $receiver.getParameters().getUsesNonConstValAsConstant(), $receiver.getParameters().isConvertableConstVal());
            return new IntegerValueTypeConstant($receiver.value, module2, newParameters, true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

