/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader;

import java.util.Map;
import org.jetbrains.kotlin.org.jline.reader.Buffer;
import org.jetbrains.kotlin.org.jline.reader.EndOfFileException;
import org.jetbrains.kotlin.org.jline.reader.History;
import org.jetbrains.kotlin.org.jline.reader.UserInterruptException;

public interface LineReader {
    public String readLine(String var1) throws UserInterruptException, EndOfFileException;

    public Map<String, Object> getVariables();

    public Object getVariable(String var1);

    public boolean isSet(Option var1);

    public void setOpt(Option var1);

    public Buffer getBuffer();

    public History getHistory();

    public String getSearchTerm();

    public RegionType getRegionActive();

    public int getRegionMark();

    public static enum RegionType {
        NONE,
        CHAR,
        LINE;

    }

    public static enum Option {
        COMPLETE_IN_WORD,
        DISABLE_EVENT_EXPANSION,
        HISTORY_VERIFY,
        HISTORY_IGNORE_SPACE(true),
        HISTORY_IGNORE_DUPS(true),
        HISTORY_REDUCE_BLANKS(true),
        HISTORY_BEEP(true),
        HISTORY_INCREMENTAL(true),
        AUTO_GROUP(true),
        AUTO_MENU(true),
        AUTO_LIST(true),
        RECOGNIZE_EXACT,
        GROUP,
        CASE_INSENSITIVE,
        LIST_AMBIGUOUS,
        LIST_PACKED,
        LIST_ROWS_FIRST,
        GLOB_COMPLETE,
        MENU_COMPLETE,
        AUTO_FRESH_LINE,
        DELAY_LINE_WRAP,
        AUTO_PARAM_SLASH(true),
        AUTO_REMOVE_SLASH(true),
        INSERT_TAB(true),
        MOUSE,
        DISABLE_HIGHLIGHTER;

        private final boolean def;

        private Option() {
            this(false);
        }

        private Option(boolean def) {
            this.def = def;
        }

        public boolean isDef() {
            return this.def;
        }
    }
}

