/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.channels;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.channels.AbstractChannel;
import org.jetbrains.kotlin.kotlinx.coroutines.channels.AbstractChannelKt;
import org.jetbrains.kotlin.kotlinx.coroutines.channels.Closed;
import org.jetbrains.kotlin.kotlinx.coroutines.channels.ReceiveOrClosed;
import org.jetbrains.kotlin.kotlinx.coroutines.channels.Send;
import org.jetbrains.kotlin.kotlinx.coroutines.selects.SelectInstance;
import org.jetbrains.kotlin.kotlinx.coroutines.selects.SelectKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0015\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00028\u00002\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014\u00a2\u0006\u0002\u0010#J\n\u0010$\u001a\u0004\u0018\u00010\bH\u0014J\u0016\u0010%\u001a\u0004\u0018\u00010\b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0012\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/channels/ArrayChannel;", "E", "Lorg/jetbrains/kotlin/kotlinx/coroutines/channels/AbstractChannel;", "capacity", "", "(I)V", "buffer", "", "", "[Ljava/lang/Object;", "bufferDebugString", "", "getBufferDebugString", "()Ljava/lang/String;", "getCapacity", "()I", "head", "isBufferAlwaysEmpty", "", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/ReentrantLock;", "size", "cleanupSendQueueOnCancel", "", "offerInternal", "element", "(Ljava/lang/Object;)Ljava/lang/Object;", "offerSelectInternal", "select", "Lorg/jetbrains/kotlin/kotlinx/coroutines/selects/SelectInstance;", "(Ljava/lang/Object;Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "pollInternal", "pollSelectInternal", "kotlinx-coroutines-core"})
public class ArrayChannel<E>
extends AbstractChannel<E> {
    private final ReentrantLock lock;
    private final Object[] buffer;
    private int head;
    private volatile int size;
    private final int capacity;

    @Override
    protected final boolean isBufferAlwaysEmpty() {
        return false;
    }

    @Override
    protected final boolean isBufferEmpty() {
        return this.size == 0;
    }

    @Override
    protected final boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected final boolean isBufferFull() {
        return this.size == this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected Object offerInternal(E element) {
        int size;
        Object token;
        ReceiveOrClosed<E> receive;
        block13: {
            block15: {
                block16: {
                    Lock lock;
                    block14: {
                        receive = null;
                        token = null;
                        ReentrantLock $receiver$iv = this.lock;
                        lock = $receiver$iv;
                        lock.lock();
                        size = this.size;
                        Closed<?> closed = this.getClosedForSend();
                        if (closed != null) {
                            Closed<?> closed2;
                            Closed<?> it;
                            Closed<?> closed3 = it = (closed2 = closed);
                            return closed3;
                        }
                        if (size >= this.capacity) break block14;
                        this.size = size + 1;
                        if (size != 0) break block15;
                        break block16;
                    }
                    Object object = AbstractChannelKt.OFFER_FAILED;
                    return object;
                    finally {
                        lock.unlock();
                    }
                }
                while (this.takeFirstReceiveOrPeekClosed() != null) {
                    if (receive instanceof Closed) {
                        this.size = size;
                        ReceiveOrClosed<E> receiveOrClosed = receive;
                        if (receiveOrClosed == null) {
                            Intrinsics.throwNpe();
                        }
                        ReceiveOrClosed<E> receiveOrClosed2 = receiveOrClosed;
                        return receiveOrClosed2;
                    }
                    ReceiveOrClosed<E> receiveOrClosed = receive;
                    if (receiveOrClosed == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((token = receiveOrClosed.tryResumeReceive(element, null)) == null) continue;
                    break block13;
                }
            }
            this.buffer[(this.head + size) % this.capacity] = element;
            Object object = AbstractChannelKt.OFFER_SUCCESS;
            return object;
        }
        this.size = size;
        Unit unit = Unit.INSTANCE;
        ReceiveOrClosed<E> receiveOrClosed = receive;
        if (receiveOrClosed == null) {
            Intrinsics.throwNpe();
        }
        receiveOrClosed.completeResumeReceive(token);
        ReceiveOrClosed<E> receiveOrClosed3 = receive;
        if (receiveOrClosed3 != null) return receiveOrClosed3.getOfferResult();
        Intrinsics.throwNpe();
        return receiveOrClosed3.getOfferResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Object offerSelectInternal(E element, @NotNull SelectInstance<?> select) {
        Intrinsics.checkParameterIsNotNull(select, "select");
        receive = null;
        token = null;
        $receiver$iv = this.lock;
        var6_6 = $receiver$iv;
        var6_6.lock();
        try {
            size = this.size;
            v0 = this.getClosedForSend();
            if (v0 != null) {
                var19_12 = it = (var8_8 = v0);
                return var19_12;
            }
            if (size >= this.capacity) ** GOTO lbl42
            this.size = size + 1;
            if (size != 0) ** GOTO lbl35
            offerOp = this.describeTryOffer(element);
            failure = select.performAtomicTrySelect(offerOp);
            if (failure == null) {
                this.size = size;
                receive = (ReceiveOrClosed)offerOp.getResult();
                token = offerOp.resumeToken;
                v1 = var10_13 = token != null;
                if (!var10_13) {
                    var11_15 = "Check failed.";
                    throw (Throwable)new IllegalStateException(var11_15.toString());
                }
            } else {
                if (failure != AbstractChannelKt.OFFER_FAILED) {
                    if (failure == SelectKt.getALREADY_SELECTED() || failure instanceof Closed) {
                        this.size = size;
                        var18_16 = failure;
                        return var18_16;
                    }
                    var10_14 = "performAtomicTrySelect(describeTryOffer) returned " + failure;
                    throw (Throwable)new IllegalStateException(var10_14.toString());
                }
lbl35:
                // 3 sources

                if (!select.trySelect(null)) {
                    this.size = size;
                    var17_17 = SelectKt.getALREADY_SELECTED();
                    return var17_17;
                }
                this.buffer[(this.head + size) % this.capacity] = element;
                var16_18 = AbstractChannelKt.OFFER_SUCCESS;
                return var16_18;
lbl42:
                // 1 sources

                var15_19 = AbstractChannelKt.OFFER_FAILED;
                return var15_19;
            }
            var13_20 = Unit.INSTANCE;
        }
        finally {
            var6_6.unlock();
        }
        v2 = receive;
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        v3 = token;
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        v2.completeResumeReceive(v3);
        v4 = receive;
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        return v4.getOfferResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollInternal() {
        Send send = null;
        Object token = null;
        Object result2 = null;
        ReentrantLock $receiver$iv = this.lock;
        Lock lock = $receiver$iv;
        lock.lock();
        try {
            Object replacement;
            int size;
            block13: {
                size = this.size;
                if (size == 0) {
                    Closed<?> closed = this.getClosedForSend();
                    if (closed == null) {
                        closed = AbstractChannelKt.POLL_FAILED;
                    }
                    Closed<?> closed2 = closed;
                    return closed2;
                }
                result2 = this.buffer[this.head];
                this.buffer[this.head] = null;
                this.size = size - 1;
                replacement = AbstractChannelKt.POLL_FAILED;
                if (size == this.capacity) {
                    Send send2;
                    do {
                        if (this.takeFirstSendOrPeekClosed() == null) {
                            break block13;
                        }
                        send2 = send;
                        if (send2 != null) continue;
                        Intrinsics.throwNpe();
                    } while ((token = send2.tryResumeSend(null)) == null);
                    Send send3 = send;
                    if (send3 == null) {
                        Intrinsics.throwNpe();
                    }
                    replacement = send3.getPollResult();
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.capacity] = replacement;
            }
            this.head = (this.head + 1) % this.capacity;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (token != null) {
            Send send4 = send;
            if (send4 == null) {
                Intrinsics.throwNpe();
            }
            send4.completeResumeSend(token);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollSelectInternal(@NotNull SelectInstance<?> select) {
        Intrinsics.checkParameterIsNotNull(select, "select");
        Send send = null;
        Object token = null;
        Object result2 = null;
        ReentrantLock $receiver$iv = this.lock;
        Lock lock = $receiver$iv;
        lock.lock();
        try {
            int size = this.size;
            if (size == 0) {
                Closed<?> closed = this.getClosedForSend();
                if (closed == null) {
                    closed = AbstractChannelKt.POLL_FAILED;
                }
                Closed<?> closed2 = closed;
                return closed2;
            }
            result2 = this.buffer[this.head];
            this.buffer[this.head] = null;
            this.size = size - 1;
            Object replacement = AbstractChannelKt.POLL_FAILED;
            if (size == this.capacity) {
                AbstractChannel.TryPollDesc pollOp = this.describeTryPoll();
                Object failure = select.performAtomicTrySelect(pollOp);
                if (failure == null) {
                    boolean bl;
                    send = (Send)pollOp.getResult();
                    token = pollOp.resumeToken;
                    boolean bl2 = bl = token != null;
                    if (!bl) {
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Send send2 = send;
                    if (send2 == null) {
                        Intrinsics.throwNpe();
                    }
                    replacement = send2.getPollResult();
                } else if (failure != AbstractChannelKt.POLL_FAILED) {
                    if (failure == SelectKt.getALREADY_SELECTED()) {
                        this.size = size;
                        this.buffer[this.head] = result2;
                        Object object = failure;
                        return object;
                    }
                    if (failure instanceof Closed) {
                        send = (Send)failure;
                        token = ((Closed)failure).tryResumeSend(null);
                        replacement = failure;
                    } else {
                        String string = "performAtomicTrySelect(describeTryOffer) returned " + failure;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.capacity] = replacement;
            } else if (!select.trySelect(null)) {
                this.size = size;
                this.buffer[this.head] = result2;
                Object object = SelectKt.getALREADY_SELECTED();
                return object;
            }
            this.head = (this.head + 1) % this.capacity;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (token != null) {
            Send send3 = send;
            if (send3 == null) {
                Intrinsics.throwNpe();
            }
            send3.completeResumeSend(token);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanupSendQueueOnCancel() {
        ReentrantLock $receiver$iv = this.lock;
        Lock lock = $receiver$iv;
        lock.lock();
        try {
            int n = this.size;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                this.buffer[this.head] = 0;
                this.head = (this.head + 1) % this.capacity;
            }
            this.size = 0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        super.cleanupSendQueueOnCancel();
    }

    @Override
    @NotNull
    protected String getBufferDebugString() {
        return "(buffer:capacity=" + this.buffer.length + ",size=" + this.size + ')';
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public ArrayChannel(int capacity) {
        boolean bl;
        this.capacity = capacity;
        boolean bl2 = bl = this.capacity >= 1;
        if (!bl) {
            String string = "ArrayChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.lock = new ReentrantLock();
        this.buffer = new Object[this.capacity];
    }
}

