/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.org.objectweb.asm.Type;

public class PackagePartCodegen
extends MemberCodegen<KtFile> {
    private final Type packagePartType;

    public PackagePartCodegen(@NotNull ClassBuilder v2, @NotNull KtFile file2, @NotNull Type packagePartType, @NotNull FieldOwnerContext context, @NotNull GenerationState state2) {
        super(state2, null, context, file2, v2);
        this.packagePartType = packagePartType;
    }

    @Override
    protected void generateDeclaration() {
        this.v.defineClass((PsiElement)((Object)this.element), this.state.getClassFileVersion(), 49, this.packagePartType.getInternalName(), null, "java/lang/Object", ArrayUtil.EMPTY_STRING_ARRAY);
        this.v.visitSource(((KtFile)this.element).getName(), null);
        this.generatePropertyMetadataArrayFieldIfNeeded(this.packagePartType);
        this.generateAnnotationsForPartClass();
    }

    private void generateAnnotationsForPartClass() {
        ArrayList<AnnotationDescriptor> fileAnnotationDescriptors = new ArrayList<AnnotationDescriptor>();
        for (KtAnnotationEntry annotationEntry : ((KtFile)this.element).getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor = this.state.getBindingContext().get(BindingContext.ANNOTATION, annotationEntry);
            if (annotationDescriptor == null) continue;
            fileAnnotationDescriptors.add(annotationDescriptor);
        }
        AnnotatedImpl annotatedFile = new AnnotatedImpl(Annotations.Companion.create(fileAnnotationDescriptors));
        AnnotationCodegen.forClass(this.v.getVisitor(), this, this.state).genAnnotations(annotatedFile, null);
    }

    @Override
    protected void generateBody() {
        for (KtDeclaration declaration : CodegenUtil.getDeclarationsToGenerate((KtFile)this.element, this.state.getBindingContext())) {
            if (!(declaration instanceof KtNamedFunction) && !(declaration instanceof KtProperty) && !(declaration instanceof KtTypeAlias)) continue;
            this.genSimpleMember(declaration);
        }
        if (this.state.getClassBuilderMode().generateBodies) {
            this.generateInitializers(this::createOrGetClInitCodegen);
        }
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        Pair<DescriptorSerializer, ProtoBuf.Package> serializedPart = PackagePartCodegen.serializePackagePartMembers(this, this.packagePartType);
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.FILE_FACADE, 0, av -> {
            AsmUtil.writeAnnotationData(av, (DescriptorSerializer)serializedPart.getFirst(), (MessageLite)serializedPart.getSecond());
            FqName kotlinPackageFqName = ((KtFile)this.element).getPackageFqName();
            if (!kotlinPackageFqName.equals(JvmClassName.byInternalName(this.packagePartType.getInternalName()).getPackageFqName())) {
                av.visit("pn", kotlinPackageFqName.asString());
            }
            return Unit.INSTANCE;
        });
    }

    @NotNull
    protected static Pair<DescriptorSerializer, ProtoBuf.Package> serializePackagePartMembers(@NotNull MemberCodegen<? extends KtFile> codegen, @NotNull Type packagePartType) {
        BindingContext bindingContext = codegen.bindingContext;
        List<KtDeclaration> allDeclarations = CodegenUtil.getDeclarationsToGenerate((KtFile)codegen.element, bindingContext);
        List<DeclarationDescriptor> members2 = CollectionsKt.mapNotNull(allDeclarations, declaration -> {
            if (declaration instanceof KtNamedFunction) {
                return bindingContext.get(BindingContext.FUNCTION, declaration);
            }
            if (declaration instanceof KtProperty) {
                return bindingContext.get(BindingContext.VARIABLE, declaration);
            }
            if (declaration instanceof KtTypeAlias) {
                return bindingContext.get(BindingContext.TYPE_ALIAS, declaration);
            }
            return null;
        });
        JvmSerializerExtension extension = new JvmSerializerExtension(codegen.v.getSerializationBindings(), codegen.state);
        DescriptorSerializer serializer = DescriptorSerializer.createTopLevel(extension);
        ProtoBuf.Package.Builder builder = serializer.packagePartProto(((KtFile)codegen.element).getPackageFqName(), members2);
        extension.serializeJvmPackage(builder, packagePartType);
        return new Pair<DescriptorSerializer, ProtoBuf.Package>(serializer, builder.build());
    }

    @Override
    protected void generateSyntheticPartsAfterBody() {
        this.generateSyntheticAccessors();
    }
}

