/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
        Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(superDescriptor, subDescriptor, subClassDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(superDescriptor, subDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition.Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        boolean isOneOfDescriptorsHidden;
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || KotlinBuiltIns.isBuiltIn(subDescriptor)) {
            return false;
        }
        Name name = ((FunctionDescriptor)subDescriptor).getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "subDescriptor.name");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            Name name2 = ((FunctionDescriptor)subDescriptor).getName();
            Intrinsics.checkExpressionValueIsNotNull(name2, "subDescriptor.name");
            if (!BuiltinMethodsWithDifferentJvmName.INSTANCE.getSameAsRenamedInJvmBuiltin(name2)) {
                return false;
            }
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        boolean bl = ((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash();
        CallableDescriptor callableDescriptor = superDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        boolean bl2 = functionDescriptor == null || bl != functionDescriptor.isHiddenToOvercomeSignatureClash() ? true : (isOneOfDescriptorsHidden = false);
        if (isOneOfDescriptorsHidden && (overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return false;
        }
        if (overriddenBuiltin == null || SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, overriddenBuiltin)) {
            return false;
        }
        if (overriddenBuiltin instanceof FunctionDescriptor && superDescriptor instanceof FunctionDescriptor && BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)overriddenBuiltin) != null) {
            String string = MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)subDescriptor, false, false, 2, null);
            FunctionDescriptor functionDescriptor2 = ((FunctionDescriptor)superDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "superDescriptor.original");
            if (Intrinsics.areEqual(string, MethodSignatureMappingKt.computeJvmDescriptor$default(functionDescriptor2, false, false, 2, null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        return ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    public static final class Companion {
        public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
            Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
            if (!(subDescriptor instanceof JavaMethodDescriptor) || !(superDescriptor instanceof FunctionDescriptor)) {
                return false;
            }
            boolean bl2 = bl = ((JavaMethodDescriptor)subDescriptor).getValueParameters().size() == ((FunctionDescriptor)superDescriptor).getValueParameters().size();
            if (_Assertions.ENABLED && !bl) {
                String string = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = ((JavaMethodDescriptor)subDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor, "subDescriptor.original");
            List<ValueParameterDescriptor> list2 = simpleFunctionDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "subDescriptor.original.valueParameters");
            Iterable iterable = list2;
            FunctionDescriptor functionDescriptor = ((FunctionDescriptor)superDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "superDescriptor.original");
            List<ValueParameterDescriptor> list3 = functionDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "superDescriptor.original.valueParameters");
            for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list3)) {
                ValueParameterDescriptor subParameter = (ValueParameterDescriptor)pair.component1();
                ValueParameterDescriptor superParameter = (ValueParameterDescriptor)pair.component2();
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)subDescriptor;
                ValueParameterDescriptor valueParameterDescriptor = subParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "subParameter");
                boolean isSubPrimitive = this.mapValueParameterType(functionDescriptor2, valueParameterDescriptor) instanceof JvmType.Primitive;
                FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)superDescriptor;
                ValueParameterDescriptor valueParameterDescriptor2 = superParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "superParameter");
                boolean isSuperPrimitive = this.mapValueParameterType(functionDescriptor3, valueParameterDescriptor2) instanceof JvmType.Primitive;
                if (isSubPrimitive == isSuperPrimitive) continue;
                return true;
            }
            return false;
        }

        private final JvmType mapValueParameterType(FunctionDescriptor f, ValueParameterDescriptor valueParameterDescriptor) {
            JvmType jvmType;
            if (MethodSignatureMappingKt.forceSingleValueParameterBoxing(f) || this.isPrimitiveCompareTo(f)) {
                KotlinType kotlinType2 = valueParameterDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "valueParameterDescriptor.type");
                jvmType = MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(kotlinType2));
            } else {
                KotlinType kotlinType3 = valueParameterDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "valueParameterDescriptor.type");
                jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType3);
            }
            return jvmType;
        }

        private final boolean isPrimitiveCompareTo(FunctionDescriptor f) {
            if (f.getValueParameters().size() != 1) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = f.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor2 == null) {
                return false;
            }
            ClassDescriptor classDescriptor3 = classDescriptor2;
            List<ValueParameterDescriptor> list2 = f.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "f.valueParameters");
            ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.single(list2);
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "f.valueParameters.single()");
            ClassifierDescriptor classifierDescriptor = valueParameterDescriptor.getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor4 = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor4 == null) {
                return false;
            }
            ClassDescriptor parameterClass = classDescriptor4;
            return KotlinBuiltIns.isPrimitiveClass(classDescriptor3) && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor3), DescriptorUtilsKt.getFqNameSafe(parameterClass));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

