/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteFunction;
import gnu.trove.TByteProcedure;
import gnu.trove.TIntByteIterator;
import gnu.trove.TIntByteProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TIntByteHashMap
extends TIntHash {
    protected transient byte[] _values;

    public TIntByteHashMap() {
    }

    public TIntByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TIntByteHashMap(TIntHashingStrategy strategy) {
        super(strategy);
    }

    public TIntByteHashMap(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TIntByteHashMap(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TIntByteHashMap m = (TIntByteHashMap)super.clone();
        m._values = this._values == null ? null : (byte[])this._values.clone();
        return m;
    }

    public TIntByteIterator iterator() {
        return new TIntByteIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new byte[capacity];
        return capacity;
    }

    public byte put(int key, byte value) {
        byte previous = 0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        int[] oldKeys = this._set;
        byte[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
            this._states[index2] = 1;
        }
    }

    public byte get(int key) {
        int index2 = this.index(key);
        return index2 < 0 ? (byte)0 : this._values[index2];
    }

    public void clear() {
        super.clear();
        int[] keys2 = this._set;
        byte[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public byte remove(int key) {
        byte prev = 0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntByteHashMap)) {
            return false;
        }
        TIntByteHashMap that = (TIntByteHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0;
        super.removeAt(index2);
    }

    public byte[] getValues() {
        byte[] vals = new byte[this.size()];
        byte[] v2 = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v2[i];
            }
        }
        return vals;
    }

    public int[] keys() {
        int[] keys2 = new int[this.size()];
        int[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys2[j++] = k[i];
            }
        }
        return keys2;
    }

    public boolean containsValue(byte val) {
        byte[] states = this._states;
        byte[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return this.contains(key);
    }

    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TIntByteProcedure procedure) {
        byte[] states = this._states;
        int[] keys2 = this._set;
        byte[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TIntByteProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        int[] keys2 = this._set;
        byte[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TByteFunction function2) {
        byte[] states = this._states;
        byte[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values2[i] = function2.execute(values2[i]);
            }
        }
    }

    public boolean increment(int key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(int key, byte amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    private void writeObject(ObjectOutputStream stream2) throws IOException {
        stream2.defaultWriteObject();
        stream2.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream2);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        stream2.defaultReadObject();
        int size = stream2.readInt();
        this.setUp(size);
        while (size-- > 0) {
            int key = stream2.readInt();
            byte val = stream2.readByte();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TIntByteProcedure(){

            public boolean execute(int key, byte value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TIntByteProcedure {
        private final TIntByteHashMap _otherMap;

        EqProcedure(TIntByteHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(int key, byte value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(byte v1, byte v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TIntByteProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(int key, byte value) {
            this.h += TIntByteHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

