/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.ast.AccessSpecifier;

public final class ModifierSet {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;

    public static AccessSpecifier getAccessSpecifier(int modifiers2) {
        if (ModifierSet.isPublic(modifiers2)) {
            return AccessSpecifier.PUBLIC;
        }
        if (ModifierSet.isProtected(modifiers2)) {
            return AccessSpecifier.PROTECTED;
        }
        if (ModifierSet.isPrivate(modifiers2)) {
            return AccessSpecifier.PRIVATE;
        }
        return AccessSpecifier.DEFAULT;
    }

    public static int addModifier(int modifiers2, int mod) {
        return modifiers2 | mod;
    }

    public static boolean hasModifier(int modifiers2, int modifier) {
        return (modifiers2 & modifier) != 0;
    }

    public static boolean isAbstract(int modifiers2) {
        return (modifiers2 & 0x400) != 0;
    }

    public static boolean isFinal(int modifiers2) {
        return (modifiers2 & 0x10) != 0;
    }

    public static boolean isNative(int modifiers2) {
        return (modifiers2 & 0x100) != 0;
    }

    public static boolean isPrivate(int modifiers2) {
        return (modifiers2 & 2) != 0;
    }

    public static boolean isProtected(int modifiers2) {
        return (modifiers2 & 4) != 0;
    }

    public static boolean hasPackageLevelAccess(int modifiers2) {
        return !ModifierSet.isPublic(modifiers2) && !ModifierSet.isProtected(modifiers2) && !ModifierSet.isPrivate(modifiers2);
    }

    public static boolean isPublic(int modifiers2) {
        return (modifiers2 & 1) != 0;
    }

    public static boolean isStatic(int modifiers2) {
        return (modifiers2 & 8) != 0;
    }

    public static boolean isStrictfp(int modifiers2) {
        return (modifiers2 & 0x800) != 0;
    }

    public static boolean isSynchronized(int modifiers2) {
        return (modifiers2 & 0x20) != 0;
    }

    public static boolean isTransient(int modifiers2) {
        return (modifiers2 & 0x80) != 0;
    }

    public static boolean isVolatile(int modifiers2) {
        return (modifiers2 & 0x40) != 0;
    }

    public static int removeModifier(int modifiers2, int mod) {
        return modifiers2 & ~mod;
    }

    private ModifierSet() {
    }
}

