/*
 * Decompiled with CFR 0.152.
 */
package AndroidProjectRepresentation;

import AndroidProjectRepresentation.AppInfo;
import AndroidProjectRepresentation.ClassInfo;
import AndroidProjectRepresentation.JSONSerializable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ProjectInfo
implements Serializable,
JSONSerializable {
    public String projectID = "unknown";
    public String projectBuildTool = "gradle";
    public String projectDescription = "";
    public String projectLocation = "";
    public List<AppInfo> apps = new ArrayList<AppInfo>();
    public Set<String> allPackagesOfProject = new HashSet<String>();

    public ProjectInfo() {
    }

    public ProjectInfo(AppInfo app) {
        this.apps.add(0, app);
    }

    public ProjectInfo(String projectID, String projectBuildTool, String projectDescription) {
        this.projectID = projectID;
        this.projectBuildTool = projectBuildTool;
        this.projectDescription = projectDescription;
    }

    public AppInfo getCurrentApp() {
        try {
            return this.apps.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new AppInfo();
        }
    }

    public ClassInfo getClassOfMethod(String method_id) {
        return new ClassInfo("");
    }

    @Override
    public JSONObject toJSONObject(String requiredId) {
        JSONObject jo = new JSONObject();
        jo.put("project_id", this.projectID);
        jo.put("project_build_tool", this.projectBuildTool);
        jo.put("project_description", this.projectDescription);
        JSONArray packages2 = new JSONArray();
        for (String pack : this.allPackagesOfProject) {
            JSONObject pa = new JSONObject();
            pa.put("package", pack);
            packages2.add(pa);
        }
        jo.put("project_packages", packages2);
        JSONArray apps = new JSONArray();
        for (AppInfo app : this.apps) {
            apps.add(app.toJSONObject(this.projectID));
        }
        jo.put("project_apps", apps);
        return jo;
    }

    public static ProjectInfo getSimpleProjectJSON(JSONObject jo) {
        JSONObject pro = new JSONObject();
        pro.put("project_id", jo.get("project_id"));
        pro.put("project_build_tool", jo.get("project_build_tool"));
        pro.put("project_description", jo.get("project_description"));
        pro.put("project_location", jo.get("project_location"));
        return (ProjectInfo)new ProjectInfo().fromJSONObject(pro);
    }

    @Override
    public JSONSerializable fromJSONObject(JSONObject jo) {
        JSONObject job;
        ProjectInfo proj2 = new ProjectInfo();
        proj2.projectID = (String)jo.get("project_id");
        proj2.projectDescription = (String)jo.get("project_description");
        proj2.projectLocation = (String)jo.get("project_location");
        proj2.projectBuildTool = (String)jo.get("project_build_tool");
        try {
            JSONArray packages2 = (JSONArray)jo.get("project_packages");
            for (Object j : packages2) {
                job = (JSONObject)j;
                proj2.allPackagesOfProject.add((String)job.get("package"));
            }
        }
        catch (Exception packages2) {
            // empty catch block
        }
        try {
            JSONArray apps = (JSONArray)jo.get("project_apps");
            for (Object j : apps) {
                job = (JSONObject)j;
                if (!job.containsKey("app_id")) continue;
                proj2.apps.add((AppInfo)new AppInfo().fromJSONObject(job));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proj2;
    }

    @Override
    public JSONObject fromJSONFile(String pathToJSONFile) {
        JSONParser parser = new JSONParser();
        JSONObject ja = new JSONObject();
        try {
            Object obj = parser.parse(new FileReader(pathToJSONFile));
            JSONObject jsonObject = (JSONObject)obj;
            if (jsonObject.containsKey("project_id") && jsonObject.containsKey("project_packages") && jsonObject.containsKey("project_apps")) {
                return jsonObject;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ja;
    }
}

