/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ASTParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.PositionUtils;
import com.github.javaparser.SourcesHelper;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.comments.CommentsParser;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class JavaParser {
    private static boolean _doNotAssignCommentsPreceedingEmptyLines = true;
    private static boolean _doNotConsiderAnnotationsAsNodeStartForCodeAttribution = false;

    private JavaParser() {
    }

    public static boolean getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution() {
        return _doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public static void setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(boolean doNotConsiderAnnotationsAsNodeStartForCodeAttribution) {
        _doNotConsiderAnnotationsAsNodeStartForCodeAttribution = doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public static boolean getDoNotAssignCommentsPreceedingEmptyLines() {
        return _doNotAssignCommentsPreceedingEmptyLines;
    }

    public static void setDoNotAssignCommentsPreceedingEmptyLines(boolean doNotAssignCommentsPreceedingEmptyLines) {
        _doNotAssignCommentsPreceedingEmptyLines = doNotAssignCommentsPreceedingEmptyLines;
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        return JavaParser.parse(in, encoding, true);
    }

    public static CompilationUnit parse(InputStream in, String encoding, boolean considerComments) throws ParseException {
        try {
            String code = SourcesHelper.streamToString(in, encoding);
            InputStream in1 = SourcesHelper.stringToStream(code);
            CompilationUnit cu = new ASTParser(in1, encoding).CompilationUnit();
            if (considerComments) {
                JavaParser.insertComments(cu, code);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null, true);
    }

    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        return JavaParser.parse(file, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(File file, String encoding, boolean considerComments) throws ParseException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding, considerComments);
            return compilationUnit;
        }
        finally {
            in.close();
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null, true);
    }

    public static CompilationUnit parse(Reader reader, boolean considerComments) throws ParseException {
        try {
            String code = SourcesHelper.readerToString(reader);
            Reader reader1 = SourcesHelper.stringToReader(code);
            CompilationUnit cu = new ASTParser(reader1).CompilationUnit();
            if (considerComments) {
                JavaParser.insertComments(cu, code);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static BlockStmt parseBlock(String blockStatement) throws ParseException {
        StringReader sr = new StringReader(blockStatement);
        BlockStmt result = new ASTParser(sr).Block();
        sr.close();
        return result;
    }

    public static Statement parseStatement(String statement) throws ParseException {
        StringReader sr = new StringReader(statement);
        Statement stmt = new ASTParser(sr).Statement();
        sr.close();
        return stmt;
    }

    public static ImportDeclaration parseImport(String importDeclaration) throws ParseException {
        StringReader sr = new StringReader(importDeclaration);
        ImportDeclaration id = new ASTParser(sr).ImportDeclaration();
        sr.close();
        return id;
    }

    public static Expression parseExpression(String expression) throws ParseException {
        StringReader sr = new StringReader(expression);
        Expression e = new ASTParser(sr).Expression();
        sr.close();
        return e;
    }

    public static AnnotationExpr parseAnnotation(String annotation) throws ParseException {
        StringReader sr = new StringReader(annotation);
        AnnotationExpr ae = new ASTParser(sr).Annotation();
        sr.close();
        return ae;
    }

    public static BodyDeclaration parseBodyDeclaration(String body) throws ParseException {
        StringReader sr = new StringReader(body);
        BodyDeclaration bd = new ASTParser(sr).AnnotationBodyDeclaration();
        sr.close();
        return bd;
    }

    private static void insertCommentsInCu(CompilationUnit cu, CommentsCollection commentsCollection) {
        if (commentsCollection.size() == 0) {
            return;
        }
        List<Comment> comments = commentsCollection.getAll();
        PositionUtils.sortByBeginPosition(comments);
        List<Node> children = cu.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        if (cu.getPackage() != null && (children.size() == 0 || PositionUtils.areInOrder(comments.get(0), children.get(0)))) {
            cu.setComment(comments.get(0));
            comments.remove(0);
        }
        JavaParser.insertCommentsInNode(cu, comments);
    }

    private static boolean attributeLineCommentToNodeOrChild(Node node, LineComment lineComment) {
        if (node.getBeginLine() == lineComment.getBeginLine() && !node.hasComment()) {
            node.setComment(lineComment);
            return true;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        children.addAll(node.getChildrenNodes());
        PositionUtils.sortByBeginPosition(children);
        Collections.reverse(children);
        for (Node child : children) {
            if (!JavaParser.attributeLineCommentToNodeOrChild(child, lineComment)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void insertCommentsInNode(Node node, List<Comment> commentsToAttribute) {
        if (commentsToAttribute.size() == 0) {
            return;
        }
        List<Node> children = node.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        for (Node node2 : children) {
            LinkedList<Comment> commentsInsideChild = new LinkedList<Comment>();
            for (Comment c : commentsToAttribute) {
                if (!PositionUtils.nodeContains(node2, c, _doNotConsiderAnnotationsAsNodeStartForCodeAttribution)) continue;
                commentsInsideChild.add(c);
            }
            commentsToAttribute.removeAll(commentsInsideChild);
            JavaParser.insertCommentsInNode(node2, commentsInsideChild);
        }
        LinkedList<Object> attributedComments = new LinkedList<Object>();
        for (Comment comment : commentsToAttribute) {
            if (!comment.isLineComment()) continue;
            for (Node child : children) {
                if (child.getEndLine() != comment.getBeginLine() || !JavaParser.attributeLineCommentToNodeOrChild(child, comment.asLineComment())) continue;
                attributedComments.add(comment);
            }
        }
        Object var4_6 = null;
        attributedComments = new LinkedList();
        LinkedList<Node> childrenAndComments = new LinkedList<Node>();
        childrenAndComments.addAll(children);
        childrenAndComments.addAll(commentsToAttribute);
        PositionUtils.sortByBeginPosition(childrenAndComments, _doNotConsiderAnnotationsAsNodeStartForCodeAttribution);
        for (Node thing : childrenAndComments) {
            void var4_7;
            if (thing instanceof Comment) {
                Comment comment = (Comment)thing;
                if (comment.isOrphan()) continue;
                Object var4_9 = null;
                continue;
            }
            if (var4_7 == null || thing.hasComment() || _doNotAssignCommentsPreceedingEmptyLines && JavaParser.thereAreLinesBetween((Node)var4_7, thing)) continue;
            thing.setComment((Comment)var4_7);
            attributedComments.add(var4_7);
            Object var4_10 = null;
        }
        commentsToAttribute.removeAll(attributedComments);
        for (Comment c : commentsToAttribute) {
            if (!c.isOrphan()) continue;
            node.addOrphanComment(c);
        }
    }

    private static boolean thereAreLinesBetween(Node a, Node b) {
        if (!PositionUtils.areInOrder(a, b)) {
            return JavaParser.thereAreLinesBetween(b, a);
        }
        int endOfA = a.getEndLine();
        return b.getBeginLine() > a.getEndLine() + 1;
    }

    private static void insertComments(CompilationUnit cu, String code) throws IOException {
        CommentsParser commentsParser = new CommentsParser();
        CommentsCollection allComments = commentsParser.parse(code);
        JavaParser.insertCommentsInCu(cu, allComments);
    }
}

