/*
 * Decompiled with CFR 0.152.
 */
package AnaDroidAnalyzer.GreenSourceBridge;

import AndroidProjectRepresentation.JSONSerializable;
import java.io.FileReader;
import java.io.Serializable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DeviceTestState
implements Serializable,
JSONSerializable {
    public double memory = 0.0;
    public double cpu = 0.0;
    public double gpu = 0.0;
    public float androidVersion = 0.0f;
    public float apiLevel = 0.0f;
    public int nr_processes_running = 0;

    @Override
    public JSONObject toJSONObject(String requiredId) {
        JSONObject jo = new JSONObject();
        jo.put("device_state_mem", this.memory);
        jo.put("device_state_cpu_free", this.cpu);
        jo.put("device_state_nr_processes_running", this.nr_processes_running);
        jo.put("device_state_api_level", Float.valueOf(this.apiLevel));
        jo.put("device_state_android_version", Float.valueOf(this.androidVersion));
        return jo;
    }

    @Override
    public JSONSerializable fromJSONObject(JSONObject jo) {
        DeviceTestState d = new DeviceTestState();
        d.androidVersion = ((Float)jo.get("device_state_android_version")).floatValue();
        d.apiLevel = ((Float)jo.get("device_state_api_level")).floatValue();
        d.nr_processes_running = (Integer)jo.get("device_state_nr_processes_running");
        d.cpu = (Double)jo.get("device_state_cpu_free");
        d.memory = (Double)jo.get("device_state_mem");
        return d;
    }

    @Override
    public JSONObject fromJSONFile(String pathToJSONFile) {
        JSONParser parser = new JSONParser();
        JSONObject ja = new JSONObject();
        try {
            Object obj = parser.parse(new FileReader(pathToJSONFile));
            JSONObject jsonObject = (JSONObject)obj;
            return jsonObject;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return ja;
        }
    }
}

