/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.postprocessing.logcat;

import androidx.test.tools.crawler.postprocessing.logcat.AutoValue_LogLine;
import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import org.joda.time.Duration;
import org.joda.time.Instant;

@AutoValue
public abstract class LogLine {
    static boolean instrumentationTestFinishedLine(LogLine logLine) {
        return logLine.type() == LogMessageType.INSTRUMENTATION_TEST_FINISHED;
    }

    static boolean instrumentationTestStartedLine(LogLine logLine) {
        return logLine.type() == LogMessageType.INSTRUMENTATION_TEST_STARTED;
    }

    static boolean lowMemoryKillerLine(LogLine logLine) {
        return logLine.type() == LogMessageType.LOW_MEMORY_KILLER;
    }

    static boolean startProcLine(LogLine logLine) {
        return logLine.type() == LogMessageType.START_PROC;
    }

    static boolean nonSdkApiUsedViolationLine(LogLine logLine) {
        return logLine.type() == LogMessageType.NON_SDK_API_USED_VIOLATION;
    }

    static boolean processDiedLine(LogLine logLine) {
        return logLine.type() == LogMessageType.PROCESS_DIED;
    }

    static boolean processLine(LogLine logLine) {
        return logLine.type() == LogMessageType.PROCESS;
    }

    static boolean suppressedCrashLine(LogLine logLine) {
        return logLine.type() == LogMessageType.SUPPRESSED_CRASH;
    }

    static boolean roboTestCompleteLine(LogLine logLine) {
        return logLine.type() == LogMessageType.ROBO_TEST_COMPLETE;
    }

    static boolean startupFullyDrawnLine(LogLine logLine) {
        return logLine.type() == LogMessageType.STARTUP_TIME_FULLY_DRAWN;
    }

    static boolean startupDefaultLine(LogLine logLine) {
        return logLine.type() == LogMessageType.STARTUP_TIME_DEFAULT;
    }

    static boolean nativeCrashLine(LogLine logLine) {
        return logLine.type() == LogMessageType.NATIVE_CRASH;
    }

    static boolean stackTraceLine(LogLine logLine) {
        return logLine.type() == LogMessageType.STACK_FRAME || logLine.type() == LogMessageType.CAUSED_BY;
    }

    public static Builder builder() {
        return new AutoValue_LogLine.Builder();
    }

    public abstract LogMessageType type();

    public abstract Instant timeStamp();

    public abstract LogSeverity severity();

    public abstract String tag();

    public abstract int processId();

    public abstract int lineNumber();

    public abstract String message();

    public abstract String fullLogLine();

    public abstract Optional<String> sourceClass();

    public abstract Optional<String> sourceMethod();

    public abstract Optional<String> sourceLine();

    public abstract Optional<String> causedBy();

    public abstract Optional<String> packageName();

    public abstract Optional<Integer> targetProcessId();

    public abstract Optional<Duration> startupTime();

    public abstract Optional<String> nonSdkApiSignature();

    public static abstract class Builder {
        public abstract Builder type(LogMessageType var1);

        public abstract Builder timeStamp(Instant var1);

        public abstract Builder severity(LogSeverity var1);

        public abstract Builder tag(String var1);

        public abstract Builder processId(int var1);

        public abstract Builder lineNumber(int var1);

        public abstract Builder message(String var1);

        public abstract Builder fullLogLine(String var1);

        public abstract Builder sourceMethod(String var1);

        public abstract Builder sourceClass(String var1);

        public abstract Builder sourceLine(String var1);

        public abstract Builder causedBy(String var1);

        public abstract Builder packageName(String var1);

        public abstract Builder targetProcessId(int var1);

        public abstract Builder startupTime(Duration var1);

        public abstract Builder nonSdkApiSignature(String var1);

        public abstract LogLine build();
    }

    public static enum LogSeverity {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL,
        UNKNOWN,
        VERBOSE;

    }

    public static enum LogMessageType {
        OTHER,
        STACK_FRAME,
        CAUSED_BY,
        NATIVE_CRASH,
        STARTUP_TIME_DEFAULT,
        STARTUP_TIME_FULLY_DRAWN,
        ROBO_TEST_COMPLETE,
        PROCESS,
        PROCESS_DIED,
        CRASH_DURING_INSTRUMENTATION,
        SUPPRESSED_CRASH,
        LOW_MEMORY_KILLER,
        INSTRUMENTATION_TEST_STARTED,
        INSTRUMENTATION_TEST_FINISHED,
        NON_SDK_API_USED_VIOLATION,
        START_PROC;

    }
}

