# ===================================================================================== #
# Distributed as part of ConIII.
# Author : Edward Lee, edlee@alumni.princeton.edu
# ===================================================================================== #
#
# MIT License
# 
# Copyright (c) 2019 Edward D. Lee, Bryan C. Daniels
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
from .utils import *


def test_Ising():
    n = 5
    model = Ising(n, h=-10, J=.1)
    assert model.hJ.size==(n*(n-1)//2+n)
    assert model.Jmat.shape==(n,n)
    assert np.array_equal(model.find_basin(np.ones(n)), -np.ones(n))
    assert np.array_equal(model.find_basin(-np.ones(n)), -np.ones(n))

    model.correlations()
    model.correlations('1')
    model.fields()
    model.fields('1')
    model.couplings()
    model.couplings('1')
