# [Django Admin Argon](https://github.com/app-generator/django-admin-argon-dashboard)

Modern template for **Django Admin Interface** coded on top of **Argon Dashboard**, an open-source `Boostrap 5` design from `Creative-Tim`.

> Actively supported by [AppSeed](https://appseed.us/) via `Email` and `Discord`.

<br>

**Links & Resources**

- [Django Argon Dashboard](https://appseed.us/product/argon-dashboard/django/) - free starter with the same design
- [Django Argon Dashboard](https://django-argon-dashboard.appseed-srv1.com/) - LIVE Demo

<br />

![Argon Dashboard - Starter generated by AppSeed.](https://user-images.githubusercontent.com/51070104/183684596-4b29a886-f13d-4da5-98d3-12b5b90df47f.png)

<br />

## Why `Django Argon Design`

- Modern `Bootstrap 5` Design
- `Responsive Interface`
- `Minimal Template` overriding
- `Easy integration`

<br />

## How to use it

<br />

> **Install the package** via `PIP` 

```bash
$ pip install django-admin-argon-dashboard
// OR
$ pip install git+https://github.com/app-generator/django-admin-argon-dashboard.git
```

<br />

> Add `admin_material` application to the `INSTALLED_APPS` setting of your Django project `settings.py` file (note it should be before `django.contrib.admin`):

```python
    INSTALLED_APPS = (
        ...
        'admin_argon.apps.AdminArgonConfig',
        'django.contrib.admin',
    )
```

<br />

> **Collect static** if you are in `production environment`:

```bash
$ python manage.py collectstatic
```

<br />

> **Start the app**

```bash
$ # Set up the database
$ python manage.py makemigrations
$ python manage.py migrate
$
$ # Create the superuser
$ python manage.py createsuperuser
$
$ # Start the application (development mode)
$ python manage.py runserver # default port 8000
```

Access the `admin` section in the browser: `http://127.0.0.1:8000/`

<br />

## How to use it for common users

- Create view functions for a particular pages and render the html template.

> Sample

```python
    def dashboard(request):
        return render(request, 'pages/dashboard.html')
```

- Create urls.py file and map the function to the urls.py file.

Sample

```python
    path('dashboard/', views.dashboard, name="dashboard")
```

- Type the path manually in browser or make sidebar `href` dynamic.

<br />

## Screenshots

@ToDo

<br />

---
**[Django Admin Material](https://github.com/app-generator/django-admin-argon-dashboard)** - Modern Admin Interface provided by **[AppSeed](https://appseed.us/)**
