# Copyright 2022 UW-IT, University of Washington
# SPDX-License-Identifier: Apache-2.0

from unittest import TestCase
from uw_pws import PWS
from restclients_core.exceptions import DataFailureException
from uw_pws.exceptions import InvalidProxRFID
from uw_pws.util import fdao_pws_override


@fdao_pws_override
class IdCardTestCard(TestCase):

    def test_by_rfid(self):
        pws = PWS()
        person = pws.get_person_by_prox_rfid('1223221621633408')
        self.assertEquals(person.uwnetid, 'javerage', "Correct netid")
        self.assertEquals(person.uwregid,
                          '9136CCB8F66711D5BE060004AC494FFE', "Correct regid")

        # Valid non-existent RFID
        self.assertRaises(DataFailureException,
                          pws.get_person_by_prox_rfid,
                          '1234567890123456')

        self.assertRaises(InvalidProxRFID,
                          pws.get_person_by_prox_rfid,
                          '123456')

    def test_bad_prox_rfids(self):
        pws = PWS()
        self.assertRaises(InvalidProxRFID, pws.get_person_by_prox_rfid, "")
        self.assertRaises(InvalidProxRFID,
                          pws.get_person_by_prox_rfid, " ")
        self.assertRaises(InvalidProxRFID,
                          pws.get_person_by_prox_rfid, "A")
        self.assertRaises(InvalidProxRFID,
                          pws.get_person_by_prox_rfid, "123456789012345N")
        self.assertRaises(InvalidProxRFID,
                          pws.get_person_by_prox_rfid, "1")
        self.assertRaises(InvalidProxRFID,
                          pws.get_person_by_prox_rfid, "1234567890")
