# Generated by Django 2.2.13 on 2020-07-23 22:14

import arvestust.models.abstracts.file
import arvestust.models.validators.file
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('content', models.CharField(max_length=64, verbose_name='content')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tag', to='contenttypes.ContentType')),
            ],
            options={
                'db_table': 'arvestust_tags',
            },
        ),
        migrations.CreateModel(
            name='Save',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('notes', models.CharField(blank=True, max_length=255, null=True, verbose_name='notes')),
                ('permalink', models.URLField(blank=True, null=True, verbose_name='permalink')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='save', to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='saves', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'db_table': 'arvestust_saves',
            },
        ),
        migrations.CreateModel(
            name='Like',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='like', to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='likes', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'db_table': 'arvestust_likes',
            },
        ),
        migrations.CreateModel(
            name='Follow',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='follow', to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='follows', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'db_table': 'arvestust_follows',
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('name', models.CharField(blank=True, max_length=50)),
                ('file', models.FileField(upload_to=arvestust.models.abstracts.file.file_upload_path, validators=[arvestust.models.validators.file.validate_file_size, arvestust.models.validators.file.validate_file_type], verbose_name='file')),
                ('mime', models.CharField(blank=True, editable=False, max_length=100)),
                ('is_private', models.BooleanField(default=False)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='file', to='contenttypes.ContentType')),
                ('uploaded_by', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='file', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'arvestust_files',
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('content', models.TextField(blank=True, verbose_name='content')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comment', to='contenttypes.ContentType')),
                ('reports', models.ManyToManyField(blank=True, related_name='reported_comments', to=settings.AUTH_USER_MODEL, verbose_name='reports')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='comments', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'db_table': 'arvestust_comments',
                'ordering': ['-created_at'],
            },
        ),
        migrations.AddIndex(
            model_name='follow',
            index=models.Index(fields=['user', 'created_at'], name='arvestust_f_user_id_3052ae_idx'),
        ),
        migrations.AddIndex(
            model_name='comment',
            index=models.Index(fields=['user', 'created_at'], name='arvestust_c_user_id_429c1c_idx'),
        ),
    ]
