# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 application_key: Optional[pulumi.Input[str]] = None,
                 application_secret: Optional[pulumi.Input[str]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] application_key: The OVH API Application Key.
        :param pulumi.Input[str] application_secret: The OVH API Application Secret.
        :param pulumi.Input[str] consumer_key: The OVH API Consumer key.
        :param pulumi.Input[str] endpoint: The OVH API endpoint to target (ex: "ovh-eu").
        """
        if application_key is None:
            application_key = _utilities.get_env('OVH_APPLICATION_KEY')
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if application_secret is None:
            application_secret = _utilities.get_env('OVH_APPLICATION_SECRET')
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if consumer_key is None:
            consumer_key = _utilities.get_env('OVH_CONSUMER_KEY')
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if endpoint is None:
            endpoint = _utilities.get_env('OVH_ENDPOINT')
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OVH API Application Key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The OVH API Application Secret.
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_secret", value)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OVH API Consumer key.
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_key", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The OVH API endpoint to target (ex: "ovh-eu").
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 application_secret: Optional[pulumi.Input[str]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the ovh package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The OVH API Application Key.
        :param pulumi.Input[str] application_secret: The OVH API Application Secret.
        :param pulumi.Input[str] consumer_key: The OVH API Consumer key.
        :param pulumi.Input[str] endpoint: The OVH API endpoint to target (ex: "ovh-eu").
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the ovh package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 application_secret: Optional[pulumi.Input[str]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if application_key is None:
                application_key = _utilities.get_env('OVH_APPLICATION_KEY')
            __props__.__dict__["application_key"] = application_key
            if application_secret is None:
                application_secret = _utilities.get_env('OVH_APPLICATION_SECRET')
            __props__.__dict__["application_secret"] = application_secret
            if consumer_key is None:
                consumer_key = _utilities.get_env('OVH_CONSUMER_KEY')
            __props__.__dict__["consumer_key"] = None if consumer_key is None else pulumi.Output.secret(consumer_key)
            if endpoint is None:
                endpoint = _utilities.get_env('OVH_ENDPOINT')
            __props__.__dict__["endpoint"] = endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["consumerKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'ovh',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[Optional[str]]:
        """
        The OVH API Application Key.
        """
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> pulumi.Output[Optional[str]]:
        """
        The OVH API Application Secret.
        """
        return pulumi.get(self, "application_secret")

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> pulumi.Output[Optional[str]]:
        """
        The OVH API Consumer key.
        """
        return pulumi.get(self, "consumer_key")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The OVH API endpoint to target (ex: "ovh-eu").
        """
        return pulumi.get(self, "endpoint")

