# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MeInstallationTemplatePartitionSchemeArgs', 'MeInstallationTemplatePartitionScheme']

@pulumi.input_type
class MeInstallationTemplatePartitionSchemeArgs:
    def __init__(__self__, *,
                 priority: pulumi.Input[int],
                 template_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MeInstallationTemplatePartitionScheme resource.
        :param pulumi.Input[int] priority: on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
               among all the compatible partitioning schemes (given the underlying hardware specifications)
        :param pulumi.Input[str] template_name: This template name
        :param pulumi.Input[str] name: name of this partitioning scheme
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "template_name", template_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
        among all the compatible partitioning schemes (given the underlying hardware specifications)
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[str]:
        """
        This template name
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of this partitioning scheme
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MeInstallationTemplatePartitionSchemeState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MeInstallationTemplatePartitionScheme resources.
        :param pulumi.Input[str] name: name of this partitioning scheme
        :param pulumi.Input[int] priority: on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
               among all the compatible partitioning schemes (given the underlying hardware specifications)
        :param pulumi.Input[str] template_name: This template name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of this partitioning scheme
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
        among all the compatible partitioning schemes (given the underlying hardware specifications)
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        This template name
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)


class MeInstallationTemplatePartitionScheme(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to create partition scheme for a custom installation template available for dedicated servers.

        ## Import

        Use the fake id format to import the resource `template_name/name`

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: name of this partitioning scheme
        :param pulumi.Input[int] priority: on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
               among all the compatible partitioning schemes (given the underlying hardware specifications)
        :param pulumi.Input[str] template_name: This template name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MeInstallationTemplatePartitionSchemeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create partition scheme for a custom installation template available for dedicated servers.

        ## Import

        Use the fake id format to import the resource `template_name/name`

        :param str resource_name: The name of the resource.
        :param MeInstallationTemplatePartitionSchemeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MeInstallationTemplatePartitionSchemeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MeInstallationTemplatePartitionSchemeArgs.__new__(MeInstallationTemplatePartitionSchemeArgs)

            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
        super(MeInstallationTemplatePartitionScheme, __self__).__init__(
            'ovh:index/meInstallationTemplatePartitionScheme:MeInstallationTemplatePartitionScheme',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            template_name: Optional[pulumi.Input[str]] = None) -> 'MeInstallationTemplatePartitionScheme':
        """
        Get an existing MeInstallationTemplatePartitionScheme resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: name of this partitioning scheme
        :param pulumi.Input[int] priority: on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
               among all the compatible partitioning schemes (given the underlying hardware specifications)
        :param pulumi.Input[str] template_name: This template name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MeInstallationTemplatePartitionSchemeState.__new__(_MeInstallationTemplatePartitionSchemeState)

        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["template_name"] = template_name
        return MeInstallationTemplatePartitionScheme(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of this partitioning scheme
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        on a reinstall, if a partitioning scheme is not specified, the one with the higher priority will be used by default,
        among all the compatible partitioning schemes (given the underlying hardware specifications)
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[str]:
        """
        This template name
        """
        return pulumi.get(self, "template_name")

