# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpLoadBalancingResult',
    'AwaitableGetIpLoadBalancingResult',
    'get_ip_load_balancing',
    'get_ip_load_balancing_output',
]

@pulumi.output_type
class GetIpLoadBalancingResult:
    """
    A collection of values returned by getIpLoadBalancing.
    """
    def __init__(__self__, display_name=None, id=None, ip_loadbalancing=None, ipv4=None, ipv6=None, metrics_token=None, offer=None, orderable_zones=None, service_name=None, ssl_configuration=None, state=None, vrack_eligibility=None, vrack_name=None, zones=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_loadbalancing and not isinstance(ip_loadbalancing, str):
            raise TypeError("Expected argument 'ip_loadbalancing' to be a str")
        pulumi.set(__self__, "ip_loadbalancing", ip_loadbalancing)
        if ipv4 and not isinstance(ipv4, str):
            raise TypeError("Expected argument 'ipv4' to be a str")
        pulumi.set(__self__, "ipv4", ipv4)
        if ipv6 and not isinstance(ipv6, str):
            raise TypeError("Expected argument 'ipv6' to be a str")
        pulumi.set(__self__, "ipv6", ipv6)
        if metrics_token and not isinstance(metrics_token, str):
            raise TypeError("Expected argument 'metrics_token' to be a str")
        pulumi.set(__self__, "metrics_token", metrics_token)
        if offer and not isinstance(offer, str):
            raise TypeError("Expected argument 'offer' to be a str")
        pulumi.set(__self__, "offer", offer)
        if orderable_zones and not isinstance(orderable_zones, list):
            raise TypeError("Expected argument 'orderable_zones' to be a list")
        pulumi.set(__self__, "orderable_zones", orderable_zones)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if ssl_configuration and not isinstance(ssl_configuration, str):
            raise TypeError("Expected argument 'ssl_configuration' to be a str")
        pulumi.set(__self__, "ssl_configuration", ssl_configuration)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vrack_eligibility and not isinstance(vrack_eligibility, bool):
            raise TypeError("Expected argument 'vrack_eligibility' to be a bool")
        pulumi.set(__self__, "vrack_eligibility", vrack_eligibility)
        if vrack_name and not isinstance(vrack_name, str):
            raise TypeError("Expected argument 'vrack_name' to be a str")
        pulumi.set(__self__, "vrack_name", vrack_name)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipLoadbalancing")
    def ip_loadbalancing(self) -> str:
        return pulumi.get(self, "ip_loadbalancing")

    @property
    @pulumi.getter
    def ipv4(self) -> str:
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter
    def ipv6(self) -> str:
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="metricsToken")
    def metrics_token(self) -> str:
        """
        The metrics token associated with your IP load balancing
        This attribute is sensitive.
        """
        return pulumi.get(self, "metrics_token")

    @property
    @pulumi.getter
    def offer(self) -> str:
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="orderableZones")
    def orderable_zones(self) -> Sequence['outputs.GetIpLoadBalancingOrderableZoneResult']:
        """
        Available additional zone for your Load Balancer
        """
        return pulumi.get(self, "orderable_zones")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> str:
        return pulumi.get(self, "ssl_configuration")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vrackEligibility")
    def vrack_eligibility(self) -> bool:
        return pulumi.get(self, "vrack_eligibility")

    @property
    @pulumi.getter(name="vrackName")
    def vrack_name(self) -> str:
        return pulumi.get(self, "vrack_name")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[str]:
        return pulumi.get(self, "zones")


class AwaitableGetIpLoadBalancingResult(GetIpLoadBalancingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpLoadBalancingResult(
            display_name=self.display_name,
            id=self.id,
            ip_loadbalancing=self.ip_loadbalancing,
            ipv4=self.ipv4,
            ipv6=self.ipv6,
            metrics_token=self.metrics_token,
            offer=self.offer,
            orderable_zones=self.orderable_zones,
            service_name=self.service_name,
            ssl_configuration=self.ssl_configuration,
            state=self.state,
            vrack_eligibility=self.vrack_eligibility,
            vrack_name=self.vrack_name,
            zones=self.zones)


def get_ip_load_balancing(display_name: Optional[str] = None,
                          ip_loadbalancing: Optional[str] = None,
                          ipv4: Optional[str] = None,
                          ipv6: Optional[str] = None,
                          offer: Optional[str] = None,
                          service_name: Optional[str] = None,
                          ssl_configuration: Optional[str] = None,
                          state: Optional[str] = None,
                          vrack_eligibility: Optional[bool] = None,
                          vrack_name: Optional[str] = None,
                          zones: Optional[Sequence[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpLoadBalancingResult:
    """
    Use this data source to retrieve information about an IP Load Balancing product

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    lb = ovh.IpLoadBalancing.get_ip_load_balancing(service_name="XXXXXX",
        state="ok")
    ```


    :param str display_name: the name displayed in ManagerV6 for your iplb (max 50 chars)
    :param str ip_loadbalancing: Your IP load balancing
    :param str ipv4: The IPV4 associated to your IP load balancing
    :param str ipv6: The IPV6 associated to your IP load balancing
    :param str offer: The offer of your IP load balancing
    :param str service_name: The internal name of your IP load balancing
    :param str ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30,
           IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8.
           Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5,
           Safari 1, Windows XP IE8, Android 2.3, Java 7.
           Can take any of the following value: "intermediate", "modern"
    :param str state: Current state of your IP. Can take any of the following value:
           "blacklisted", "deleted", "free", "ok", "quarantined", "suspended"
    :param bool vrack_eligibility: Vrack eligibility. Takes a boolean value.
    :param str vrack_name: Name of the vRack on which the current Load Balancer is
           attached to, as it is named on vRack product
    :param Sequence[str] zones: Location where your service is. This takes an array of values.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['ipLoadbalancing'] = ip_loadbalancing
    __args__['ipv4'] = ipv4
    __args__['ipv6'] = ipv6
    __args__['offer'] = offer
    __args__['serviceName'] = service_name
    __args__['sslConfiguration'] = ssl_configuration
    __args__['state'] = state
    __args__['vrackEligibility'] = vrack_eligibility
    __args__['vrackName'] = vrack_name
    __args__['zones'] = zones
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:IpLoadBalancing/getIpLoadBalancing:getIpLoadBalancing', __args__, opts=opts, typ=GetIpLoadBalancingResult).value

    return AwaitableGetIpLoadBalancingResult(
        display_name=__ret__.display_name,
        id=__ret__.id,
        ip_loadbalancing=__ret__.ip_loadbalancing,
        ipv4=__ret__.ipv4,
        ipv6=__ret__.ipv6,
        metrics_token=__ret__.metrics_token,
        offer=__ret__.offer,
        orderable_zones=__ret__.orderable_zones,
        service_name=__ret__.service_name,
        ssl_configuration=__ret__.ssl_configuration,
        state=__ret__.state,
        vrack_eligibility=__ret__.vrack_eligibility,
        vrack_name=__ret__.vrack_name,
        zones=__ret__.zones)


@_utilities.lift_output_func(get_ip_load_balancing)
def get_ip_load_balancing_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 ip_loadbalancing: Optional[pulumi.Input[Optional[str]]] = None,
                                 ipv4: Optional[pulumi.Input[Optional[str]]] = None,
                                 ipv6: Optional[pulumi.Input[Optional[str]]] = None,
                                 offer: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 ssl_configuration: Optional[pulumi.Input[Optional[str]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 vrack_eligibility: Optional[pulumi.Input[Optional[bool]]] = None,
                                 vrack_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 zones: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpLoadBalancingResult]:
    """
    Use this data source to retrieve information about an IP Load Balancing product

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    lb = ovh.IpLoadBalancing.get_ip_load_balancing(service_name="XXXXXX",
        state="ok")
    ```


    :param str display_name: the name displayed in ManagerV6 for your iplb (max 50 chars)
    :param str ip_loadbalancing: Your IP load balancing
    :param str ipv4: The IPV4 associated to your IP load balancing
    :param str ipv6: The IPV6 associated to your IP load balancing
    :param str offer: The offer of your IP load balancing
    :param str service_name: The internal name of your IP load balancing
    :param str ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30,
           IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8.
           Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5,
           Safari 1, Windows XP IE8, Android 2.3, Java 7.
           Can take any of the following value: "intermediate", "modern"
    :param str state: Current state of your IP. Can take any of the following value:
           "blacklisted", "deleted", "free", "ok", "quarantined", "suspended"
    :param bool vrack_eligibility: Vrack eligibility. Takes a boolean value.
    :param str vrack_name: Name of the vRack on which the current Load Balancer is
           attached to, as it is named on vRack product
    :param Sequence[str] zones: Location where your service is. This takes an array of values.
    """
    ...
