# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpLoadBalancingArgs', 'IpLoadBalancing']

@pulumi.input_type
class IpLoadBalancingArgs:
    def __init__(__self__, *,
                 ovh_subsidiary: pulumi.Input[str],
                 payment_mean: pulumi.Input[str],
                 plan: pulumi.Input['IpLoadBalancingPlanArgs'],
                 display_name: Optional[pulumi.Input[str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]]] = None,
                 ssl_configuration: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IpLoadBalancing resource.
        :param pulumi.Input[str] ovh_subsidiary: Ovh Subsidiary
        :param pulumi.Input[str] payment_mean: Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        :param pulumi.Input['IpLoadBalancingPlanArgs'] plan: Product Plan to order
        :param pulumi.Input[str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]] plan_options: Product Plan to order
        :param pulumi.Input[str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        pulumi.set(__self__, "payment_mean", payment_mean)
        pulumi.set(__self__, "plan", plan)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Input[str]:
        """
        Ovh Subsidiary
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: pulumi.Input[str]):
        pulumi.set(self, "ovh_subsidiary", value)

    @property
    @pulumi.getter(name="paymentMean")
    def payment_mean(self) -> pulumi.Input[str]:
        """
        Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        """
        return pulumi.get(self, "payment_mean")

    @payment_mean.setter
    def payment_mean(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_mean", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input['IpLoadBalancingPlanArgs']:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input['IpLoadBalancingPlanArgs']):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class _IpLoadBalancingState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ip_loadbalancing: Optional[pulumi.Input[str]] = None,
                 ipv4: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[str]] = None,
                 metrics_token: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 orderable_zones: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderableZoneArgs']]]] = None,
                 orders: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderArgs']]]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[str]] = None,
                 payment_mean: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input['IpLoadBalancingPlanArgs']] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 ssl_configuration: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 vrack_eligibility: Optional[pulumi.Input[bool]] = None,
                 vrack_name: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering IpLoadBalancing resources.
        :param pulumi.Input[str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[str] ip_loadbalancing: Your IP load balancing
        :param pulumi.Input[str] ipv4: The IPV4 associated to your IP load balancing
        :param pulumi.Input[str] ipv6: The IPV6 associated to your IP load balancing. DEPRECATED.
        :param pulumi.Input[str] metrics_token: The metrics token associated with your IP load balancing
        :param pulumi.Input[str] offer: The offer of your IP load balancing
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderableZoneArgs']]] orderable_zones: Available additional zone for your Load Balancer
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderArgs']]] orders: Details about an Order
        :param pulumi.Input[str] ovh_subsidiary: Ovh Subsidiary
        :param pulumi.Input[str] payment_mean: Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        :param pulumi.Input['IpLoadBalancingPlanArgs'] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]] plan_options: Product Plan to order
        :param pulumi.Input[str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        :param pulumi.Input[str] state: Current state of your IP
        :param pulumi.Input[bool] vrack_eligibility: Vrack eligibility
        :param pulumi.Input[str] vrack_name: Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Location where your service is
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ip_loadbalancing is not None:
            pulumi.set(__self__, "ip_loadbalancing", ip_loadbalancing)
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if metrics_token is not None:
            pulumi.set(__self__, "metrics_token", metrics_token)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if orderable_zones is not None:
            pulumi.set(__self__, "orderable_zones", orderable_zones)
        if orders is not None:
            pulumi.set(__self__, "orders", orders)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if payment_mean is not None:
            pulumi.set(__self__, "payment_mean", payment_mean)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vrack_eligibility is not None:
            pulumi.set(__self__, "vrack_eligibility", vrack_eligibility)
        if vrack_name is not None:
            pulumi.set(__self__, "vrack_name", vrack_name)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="ipLoadbalancing")
    def ip_loadbalancing(self) -> Optional[pulumi.Input[str]]:
        """
        Your IP load balancing
        """
        return pulumi.get(self, "ip_loadbalancing")

    @ip_loadbalancing.setter
    def ip_loadbalancing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_loadbalancing", value)

    @property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        The IPV4 associated to your IP load balancing
        """
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        The IPV6 associated to your IP load balancing. DEPRECATED.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter(name="metricsToken")
    def metrics_token(self) -> Optional[pulumi.Input[str]]:
        """
        The metrics token associated with your IP load balancing
        """
        return pulumi.get(self, "metrics_token")

    @metrics_token.setter
    def metrics_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics_token", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        The offer of your IP load balancing
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter(name="orderableZones")
    def orderable_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderableZoneArgs']]]]:
        """
        Available additional zone for your Load Balancer
        """
        return pulumi.get(self, "orderable_zones")

    @orderable_zones.setter
    def orderable_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderableZoneArgs']]]]):
        pulumi.set(self, "orderable_zones", value)

    @property
    @pulumi.getter
    def orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderArgs']]]]:
        """
        Details about an Order
        """
        return pulumi.get(self, "orders")

    @orders.setter
    def orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderArgs']]]]):
        pulumi.set(self, "orders", value)

    @property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[str]]:
        """
        Ovh Subsidiary
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @property
    @pulumi.getter(name="paymentMean")
    def payment_mean(self) -> Optional[pulumi.Input[str]]:
        """
        Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        """
        return pulumi.get(self, "payment_mean")

    @payment_mean.setter
    def payment_mean(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_mean", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['IpLoadBalancingPlanArgs']]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['IpLoadBalancingPlanArgs']]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Current state of your IP
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="vrackEligibility")
    def vrack_eligibility(self) -> Optional[pulumi.Input[bool]]:
        """
        Vrack eligibility
        """
        return pulumi.get(self, "vrack_eligibility")

    @vrack_eligibility.setter
    def vrack_eligibility(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vrack_eligibility", value)

    @property
    @pulumi.getter(name="vrackName")
    def vrack_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        """
        return pulumi.get(self, "vrack_name")

    @vrack_name.setter
    def vrack_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vrack_name", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Location where your service is
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


class IpLoadBalancing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[str]] = None,
                 payment_mean: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanArgs']]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanOptionArgs']]]]] = None,
                 ssl_configuration: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Orders an IP load balancing.

        ## Important

        This resource orders an OVH product for a long period of time and may generate heavy costs !
        Use with caution.

        __NOTE__ 1: the "default-payment-mean" will scan your registered bank accounts, credit card and paypal payment means to find your default payment mean.

        __NOTE__ 2: this resource is in beta state. Use with caution.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh
        import pulumi_ovh as ovh

        mycart = ovh.get_order_cart(ovh_subsidiary="fr",
            description="mycart")
        iplb = ovh.get_order_cart_product_plan(cart_id=mycart.id,
            price_capacity="renew",
            product="ipLoadbalancing",
            plan_code="iplb-lb1")
        bhs = ovh.get_order_cart_product_options_plan(cart_id=iplb.cart_id,
            price_capacity=iplb.price_capacity,
            product=iplb.product,
            plan_code=iplb.plan_code,
            options_plan_code="iplb-zone-lb1-rbx")
        iplb_lb1 = ovh.IpLoadBalancing("iplb-lb1",
            ovh_subsidiary=mycart.ovh_subsidiary,
            display_name="my ip loadbalancing",
            payment_mean="ovh-account",
            plan=ovh.IpLoadBalancingPlanArgs(
                duration=iplb.selected_prices[0].duration,
                plan_code=iplb.plan_code,
                pricing_mode=iplb.selected_prices[0].pricing_mode,
            ),
            plan_options=[ovh.IpLoadBalancingPlanOptionArgs(
                duration=bhs.selected_prices[0].duration,
                plan_code=bhs.plan_code,
                pricing_mode=bhs.selected_prices[0].pricing_mode,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[str] ovh_subsidiary: Ovh Subsidiary
        :param pulumi.Input[str] payment_mean: Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        :param pulumi.Input[pulumi.InputType['IpLoadBalancingPlanArgs']] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanOptionArgs']]]] plan_options: Product Plan to order
        :param pulumi.Input[str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpLoadBalancingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Orders an IP load balancing.

        ## Important

        This resource orders an OVH product for a long period of time and may generate heavy costs !
        Use with caution.

        __NOTE__ 1: the "default-payment-mean" will scan your registered bank accounts, credit card and paypal payment means to find your default payment mean.

        __NOTE__ 2: this resource is in beta state. Use with caution.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh
        import pulumi_ovh as ovh

        mycart = ovh.get_order_cart(ovh_subsidiary="fr",
            description="mycart")
        iplb = ovh.get_order_cart_product_plan(cart_id=mycart.id,
            price_capacity="renew",
            product="ipLoadbalancing",
            plan_code="iplb-lb1")
        bhs = ovh.get_order_cart_product_options_plan(cart_id=iplb.cart_id,
            price_capacity=iplb.price_capacity,
            product=iplb.product,
            plan_code=iplb.plan_code,
            options_plan_code="iplb-zone-lb1-rbx")
        iplb_lb1 = ovh.IpLoadBalancing("iplb-lb1",
            ovh_subsidiary=mycart.ovh_subsidiary,
            display_name="my ip loadbalancing",
            payment_mean="ovh-account",
            plan=ovh.IpLoadBalancingPlanArgs(
                duration=iplb.selected_prices[0].duration,
                plan_code=iplb.plan_code,
                pricing_mode=iplb.selected_prices[0].pricing_mode,
            ),
            plan_options=[ovh.IpLoadBalancingPlanOptionArgs(
                duration=bhs.selected_prices[0].duration,
                plan_code=bhs.plan_code,
                pricing_mode=bhs.selected_prices[0].pricing_mode,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param IpLoadBalancingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpLoadBalancingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[str]] = None,
                 payment_mean: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanArgs']]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanOptionArgs']]]]] = None,
                 ssl_configuration: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpLoadBalancingArgs.__new__(IpLoadBalancingArgs)

            __props__.__dict__["display_name"] = display_name
            if ovh_subsidiary is None and not opts.urn:
                raise TypeError("Missing required property 'ovh_subsidiary'")
            __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
            if payment_mean is None and not opts.urn:
                raise TypeError("Missing required property 'payment_mean'")
            __props__.__dict__["payment_mean"] = payment_mean
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["plan_options"] = plan_options
            __props__.__dict__["ssl_configuration"] = ssl_configuration
            __props__.__dict__["ip_loadbalancing"] = None
            __props__.__dict__["ipv4"] = None
            __props__.__dict__["ipv6"] = None
            __props__.__dict__["metrics_token"] = None
            __props__.__dict__["offer"] = None
            __props__.__dict__["orderable_zones"] = None
            __props__.__dict__["orders"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["vrack_eligibility"] = None
            __props__.__dict__["vrack_name"] = None
            __props__.__dict__["zones"] = None
        super(IpLoadBalancing, __self__).__init__(
            'ovh:index/ipLoadBalancing:IpLoadBalancing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            ip_loadbalancing: Optional[pulumi.Input[str]] = None,
            ipv4: Optional[pulumi.Input[str]] = None,
            ipv6: Optional[pulumi.Input[str]] = None,
            metrics_token: Optional[pulumi.Input[str]] = None,
            offer: Optional[pulumi.Input[str]] = None,
            orderable_zones: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingOrderableZoneArgs']]]]] = None,
            orders: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingOrderArgs']]]]] = None,
            ovh_subsidiary: Optional[pulumi.Input[str]] = None,
            payment_mean: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanArgs']]] = None,
            plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanOptionArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            ssl_configuration: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            vrack_eligibility: Optional[pulumi.Input[bool]] = None,
            vrack_name: Optional[pulumi.Input[str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'IpLoadBalancing':
        """
        Get an existing IpLoadBalancing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[str] ip_loadbalancing: Your IP load balancing
        :param pulumi.Input[str] ipv4: The IPV4 associated to your IP load balancing
        :param pulumi.Input[str] ipv6: The IPV6 associated to your IP load balancing. DEPRECATED.
        :param pulumi.Input[str] metrics_token: The metrics token associated with your IP load balancing
        :param pulumi.Input[str] offer: The offer of your IP load balancing
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingOrderableZoneArgs']]]] orderable_zones: Available additional zone for your Load Balancer
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingOrderArgs']]]] orders: Details about an Order
        :param pulumi.Input[str] ovh_subsidiary: Ovh Subsidiary
        :param pulumi.Input[str] payment_mean: Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        :param pulumi.Input[pulumi.InputType['IpLoadBalancingPlanArgs']] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpLoadBalancingPlanOptionArgs']]]] plan_options: Product Plan to order
        :param pulumi.Input[str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        :param pulumi.Input[str] state: Current state of your IP
        :param pulumi.Input[bool] vrack_eligibility: Vrack eligibility
        :param pulumi.Input[str] vrack_name: Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Location where your service is
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpLoadBalancingState.__new__(_IpLoadBalancingState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["ip_loadbalancing"] = ip_loadbalancing
        __props__.__dict__["ipv4"] = ipv4
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["metrics_token"] = metrics_token
        __props__.__dict__["offer"] = offer
        __props__.__dict__["orderable_zones"] = orderable_zones
        __props__.__dict__["orders"] = orders
        __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
        __props__.__dict__["payment_mean"] = payment_mean
        __props__.__dict__["plan"] = plan
        __props__.__dict__["plan_options"] = plan_options
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["ssl_configuration"] = ssl_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["vrack_eligibility"] = vrack_eligibility
        __props__.__dict__["vrack_name"] = vrack_name
        __props__.__dict__["zones"] = zones
        return IpLoadBalancing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="ipLoadbalancing")
    def ip_loadbalancing(self) -> pulumi.Output[str]:
        """
        Your IP load balancing
        """
        return pulumi.get(self, "ip_loadbalancing")

    @property
    @pulumi.getter
    def ipv4(self) -> pulumi.Output[str]:
        """
        The IPV4 associated to your IP load balancing
        """
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[str]:
        """
        The IPV6 associated to your IP load balancing. DEPRECATED.
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="metricsToken")
    def metrics_token(self) -> pulumi.Output[str]:
        """
        The metrics token associated with your IP load balancing
        """
        return pulumi.get(self, "metrics_token")

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Output[str]:
        """
        The offer of your IP load balancing
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="orderableZones")
    def orderable_zones(self) -> pulumi.Output[Sequence['outputs.IpLoadBalancingOrderableZone']]:
        """
        Available additional zone for your Load Balancer
        """
        return pulumi.get(self, "orderable_zones")

    @property
    @pulumi.getter
    def orders(self) -> pulumi.Output[Sequence['outputs.IpLoadBalancingOrder']]:
        """
        Details about an Order
        """
        return pulumi.get(self, "orders")

    @property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Output[str]:
        """
        Ovh Subsidiary
        """
        return pulumi.get(self, "ovh_subsidiary")

    @property
    @pulumi.getter(name="paymentMean")
    def payment_mean(self) -> pulumi.Output[str]:
        """
        Ovh payment mode (One of "default-payment-mean", "fidelity", "ovh-account")
        """
        return pulumi.get(self, "payment_mean")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output['outputs.IpLoadBalancingPlan']:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> pulumi.Output[Optional[Sequence['outputs.IpLoadBalancingPlanOption']]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> pulumi.Output[str]:
        """
        Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        return pulumi.get(self, "ssl_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of your IP
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vrackEligibility")
    def vrack_eligibility(self) -> pulumi.Output[bool]:
        """
        Vrack eligibility
        """
        return pulumi.get(self, "vrack_eligibility")

    @property
    @pulumi.getter(name="vrackName")
    def vrack_name(self) -> pulumi.Output[str]:
        """
        Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        """
        return pulumi.get(self, "vrack_name")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Location where your service is
        """
        return pulumi.get(self, "zones")

