# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PrivateDatabaseAllowlistArgs', 'PrivateDatabaseAllowlist']

@pulumi.input_type
class PrivateDatabaseAllowlistArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 service: pulumi.Input[bool],
                 service_name: pulumi.Input[str],
                 sftp: pulumi.Input[bool],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PrivateDatabaseAllowlist resource.
        :param pulumi.Input[str] ip: The whitelisted IP in your instance.
        :param pulumi.Input[bool] service: Authorize this IP to access service port. Values can be `true` or `false`
        :param pulumi.Input[str] service_name: The internal name of your private database.
        :param pulumi.Input[bool] sftp: Authorize this IP to access SFTP port. Values can be `true` or `false`
        :param pulumi.Input[str] name: Custom name for your Whitelisted IP.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "sftp", sftp)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The whitelisted IP in your instance.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[bool]:
        """
        Authorize this IP to access service port. Values can be `true` or `false`
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[bool]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The internal name of your private database.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def sftp(self) -> pulumi.Input[bool]:
        """
        Authorize this IP to access SFTP port. Values can be `true` or `false`
        """
        return pulumi.get(self, "sftp")

    @sftp.setter
    def sftp(self, value: pulumi.Input[bool]):
        pulumi.set(self, "sftp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom name for your Whitelisted IP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PrivateDatabaseAllowlistState:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[bool]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 sftp: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering PrivateDatabaseAllowlist resources.
        :param pulumi.Input[str] ip: The whitelisted IP in your instance.
        :param pulumi.Input[str] name: Custom name for your Whitelisted IP.
        :param pulumi.Input[bool] service: Authorize this IP to access service port. Values can be `true` or `false`
        :param pulumi.Input[str] service_name: The internal name of your private database.
        :param pulumi.Input[bool] sftp: Authorize this IP to access SFTP port. Values can be `true` or `false`
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if sftp is not None:
            pulumi.set(__self__, "sftp", sftp)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The whitelisted IP in your instance.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom name for your Whitelisted IP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[bool]]:
        """
        Authorize this IP to access service port. Values can be `true` or `false`
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The internal name of your private database.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def sftp(self) -> Optional[pulumi.Input[bool]]:
        """
        Authorize this IP to access SFTP port. Values can be `true` or `false`
        """
        return pulumi.get(self, "sftp")

    @sftp.setter
    def sftp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sftp", value)


class PrivateDatabaseAllowlist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[bool]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 sftp: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a new IP whitelist on your private cloud database instance.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        ip = ovh.hosting.PrivateDatabaseAllowlist("ip",
            ip="1.2.3.4",
            service=True,
            service_name="XXXXXX",
            sftp=True)
        ```

        ## Import

        OVHcloud database whitelist can be imported using the `service_name` and the `ip`, separated by "/" E.g.,

        ```sh
         $ pulumi import ovh:Hosting/privateDatabaseAllowlist:PrivateDatabaseAllowlist ip service_name/ip
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip: The whitelisted IP in your instance.
        :param pulumi.Input[str] name: Custom name for your Whitelisted IP.
        :param pulumi.Input[bool] service: Authorize this IP to access service port. Values can be `true` or `false`
        :param pulumi.Input[str] service_name: The internal name of your private database.
        :param pulumi.Input[bool] sftp: Authorize this IP to access SFTP port. Values can be `true` or `false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateDatabaseAllowlistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a new IP whitelist on your private cloud database instance.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        ip = ovh.hosting.PrivateDatabaseAllowlist("ip",
            ip="1.2.3.4",
            service=True,
            service_name="XXXXXX",
            sftp=True)
        ```

        ## Import

        OVHcloud database whitelist can be imported using the `service_name` and the `ip`, separated by "/" E.g.,

        ```sh
         $ pulumi import ovh:Hosting/privateDatabaseAllowlist:PrivateDatabaseAllowlist ip service_name/ip
        ```

        :param str resource_name: The name of the resource.
        :param PrivateDatabaseAllowlistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateDatabaseAllowlistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[bool]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 sftp: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateDatabaseAllowlistArgs.__new__(PrivateDatabaseAllowlistArgs)

            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            __props__.__dict__["name"] = name
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if sftp is None and not opts.urn:
                raise TypeError("Missing required property 'sftp'")
            __props__.__dict__["sftp"] = sftp
        super(PrivateDatabaseAllowlist, __self__).__init__(
            'ovh:Hosting/privateDatabaseAllowlist:PrivateDatabaseAllowlist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[bool]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            sftp: Optional[pulumi.Input[bool]] = None) -> 'PrivateDatabaseAllowlist':
        """
        Get an existing PrivateDatabaseAllowlist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip: The whitelisted IP in your instance.
        :param pulumi.Input[str] name: Custom name for your Whitelisted IP.
        :param pulumi.Input[bool] service: Authorize this IP to access service port. Values can be `true` or `false`
        :param pulumi.Input[str] service_name: The internal name of your private database.
        :param pulumi.Input[bool] sftp: Authorize this IP to access SFTP port. Values can be `true` or `false`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateDatabaseAllowlistState.__new__(_PrivateDatabaseAllowlistState)

        __props__.__dict__["ip"] = ip
        __props__.__dict__["name"] = name
        __props__.__dict__["service"] = service
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["sftp"] = sftp
        return PrivateDatabaseAllowlist(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        The whitelisted IP in your instance.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Custom name for your Whitelisted IP.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[bool]:
        """
        Authorize this IP to access service port. Values can be `true` or `false`
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The internal name of your private database.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def sftp(self) -> pulumi.Output[bool]:
        """
        Authorize this IP to access SFTP port. Values can be `true` or `false`
        """
        return pulumi.get(self, "sftp")

