# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCloudProjectDatabaseResult',
    'AwaitableGetCloudProjectDatabaseResult',
    'get_cloud_project_database',
    'get_cloud_project_database_output',
]

@pulumi.output_type
class GetCloudProjectDatabaseResult:
    """
    A collection of values returned by getCloudProjectDatabase.
    """
    def __init__(__self__, backup_time=None, cluster_id=None, created_at=None, description=None, endpoints=None, engine=None, flavor=None, id=None, maintenance_time=None, network_type=None, nodes=None, plan=None, service_name=None, status=None, version=None):
        if backup_time and not isinstance(backup_time, str):
            raise TypeError("Expected argument 'backup_time' to be a str")
        pulumi.set(__self__, "backup_time", backup_time)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if flavor and not isinstance(flavor, str):
            raise TypeError("Expected argument 'flavor' to be a str")
        pulumi.set(__self__, "flavor", flavor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_time and not isinstance(maintenance_time, str):
            raise TypeError("Expected argument 'maintenance_time' to be a str")
        pulumi.set(__self__, "maintenance_time", maintenance_time)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> str:
        """
        Time on which backups start every day.
        """
        return pulumi.get(self, "backup_time")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date of the creation of the cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetCloudProjectDatabaseEndpointResult']:
        """
        List of all endpoints objects of the service.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> str:
        """
        Time on which maintenances can start every day.
        """
        return pulumi.get(self, "maintenance_time")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Type of network of the cluster.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetCloudProjectDatabaseNodeResult']:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "version")


class AwaitableGetCloudProjectDatabaseResult(GetCloudProjectDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudProjectDatabaseResult(
            backup_time=self.backup_time,
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            description=self.description,
            endpoints=self.endpoints,
            engine=self.engine,
            flavor=self.flavor,
            id=self.id,
            maintenance_time=self.maintenance_time,
            network_type=self.network_type,
            nodes=self.nodes,
            plan=self.plan,
            service_name=self.service_name,
            status=self.status,
            version=self.version)


def get_cloud_project_database(cluster_id: Optional[str] = None,
                               engine: Optional[str] = None,
                               service_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudProjectDatabaseResult:
    """
    Use this data source to get the managed database of a public cloud project.

    ## Example Usage

    To get information of a database cluster service:
    ```python
    import pulumi
    import pulumi_ovh as ovh

    db = ovh.get_cloud_project_database(service_name="XXXXXX",
        engine="YYYY",
        cluster_id="ZZZZ")
    pulumi.export("clusterId", db.cluster_id)
    ```


    :param str cluster_id: Cluster ID
    :param str engine: The database engine you want to get information. To get a full list of available engine visit.
           [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getCloudProjectDatabase:getCloudProjectDatabase', __args__, opts=opts, typ=GetCloudProjectDatabaseResult).value

    return AwaitableGetCloudProjectDatabaseResult(
        backup_time=__ret__.backup_time,
        cluster_id=__ret__.cluster_id,
        created_at=__ret__.created_at,
        description=__ret__.description,
        endpoints=__ret__.endpoints,
        engine=__ret__.engine,
        flavor=__ret__.flavor,
        id=__ret__.id,
        maintenance_time=__ret__.maintenance_time,
        network_type=__ret__.network_type,
        nodes=__ret__.nodes,
        plan=__ret__.plan,
        service_name=__ret__.service_name,
        status=__ret__.status,
        version=__ret__.version)


@_utilities.lift_output_func(get_cloud_project_database)
def get_cloud_project_database_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                      engine: Optional[pulumi.Input[str]] = None,
                                      service_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCloudProjectDatabaseResult]:
    """
    Use this data source to get the managed database of a public cloud project.

    ## Example Usage

    To get information of a database cluster service:
    ```python
    import pulumi
    import pulumi_ovh as ovh

    db = ovh.get_cloud_project_database(service_name="XXXXXX",
        engine="YYYY",
        cluster_id="ZZZZ")
    pulumi.export("clusterId", db.cluster_id)
    ```


    :param str cluster_id: Cluster ID
    :param str engine: The database engine you want to get information. To get a full list of available engine visit.
           [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    ...
