# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudProjectUserArgs', 'CloudProjectUser']

@pulumi.input_type
class CloudProjectUserArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CloudProjectUser resource.
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, Any]] openstack_rc: a convenient map representing an openstack_rc file.
               Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: A list of role names. Values can be: 
               - administrator,
               - ai_training_operator
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        """
        pulumi.set(__self__, "service_name", service_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if openstack_rc is not None:
            pulumi.set(__self__, "openstack_rc", openstack_rc)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_names is not None:
            pulumi.set(__self__, "role_names", role_names)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The id of the public cloud project. If omitted,
        the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="openstackRc")
    def openstack_rc(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        a convenient map representing an openstack_rc file.
        Note: no password nor sensitive token is set in this map.
        """
        return pulumi.get(self, "openstack_rc")

    @openstack_rc.setter
    def openstack_rc(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "openstack_rc", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a role. See `role_names`.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of role names. Values can be: 
        - administrator,
        - ai_training_operator
        - authentication
        - backup_operator
        - compute_operator
        - image_operator
        - infrastructure_supervisor
        - network_operator
        - network_security_operator
        - objectstore_operator
        - volume_operator
        """
        return pulumi.get(self, "role_names")

    @role_names.setter
    def role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_names", value)


@pulumi.input_type
class _CloudProjectUserState:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectUserRoleArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudProjectUser resources.
        :param pulumi.Input[str] creation_date: the date the user was created.
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, Any]] openstack_rc: a convenient map representing an openstack_rc file.
               Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[str] password: (Sensitive) the password generated for the user. The password can
               be used with the Openstack API. This attribute is sensitive and will only be
               retrieve once during creation.
        :param pulumi.Input[str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: A list of role names. Values can be: 
               - administrator,
               - ai_training_operator
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[Sequence[pulumi.Input['CloudProjectUserRoleArgs']]] roles: A list of roles associated with the user.
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[str] status: the status of the user. should be normally set to 'ok'.
        :param pulumi.Input[str] username: the username generated for the user. This username can be used with
               the Openstack API.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if openstack_rc is not None:
            pulumi.set(__self__, "openstack_rc", openstack_rc)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_names is not None:
            pulumi.set(__self__, "role_names", role_names)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        the date the user was created.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="openstackRc")
    def openstack_rc(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        a convenient map representing an openstack_rc file.
        Note: no password nor sensitive token is set in this map.
        """
        return pulumi.get(self, "openstack_rc")

    @openstack_rc.setter
    def openstack_rc(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "openstack_rc", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Sensitive) the password generated for the user. The password can
        be used with the Openstack API. This attribute is sensitive and will only be
        retrieve once during creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a role. See `role_names`.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of role names. Values can be: 
        - administrator,
        - ai_training_operator
        - authentication
        - backup_operator
        - compute_operator
        - image_operator
        - infrastructure_supervisor
        - network_operator
        - network_security_operator
        - objectstore_operator
        - volume_operator
        """
        return pulumi.get(self, "role_names")

    @role_names.setter
    def role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_names", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectUserRoleArgs']]]]:
        """
        A list of roles associated with the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectUserRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the public cloud project. If omitted,
        the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        the status of the user. should be normally set to 'ok'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        the username generated for the user. This username can be used with
        the Openstack API.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class CloudProjectUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a user in a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_ovh as ovh

        user1 = ovh.CloudProjectUser("user1", service_name="XXX")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, Any]] openstack_rc: a convenient map representing an openstack_rc file.
               Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: A list of role names. Values can be: 
               - administrator,
               - ai_training_operator
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudProjectUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a user in a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_ovh as ovh

        user1 = ovh.CloudProjectUser("user1", service_name="XXX")
        ```

        :param str resource_name: The name of the resource.
        :param CloudProjectUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudProjectUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudProjectUserArgs.__new__(CloudProjectUserArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["openstack_rc"] = openstack_rc
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["role_names"] = role_names
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["roles"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["username"] = None
        super(CloudProjectUser, __self__).__init__(
            'ovh:index/cloudProjectUser:CloudProjectUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_date: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            openstack_rc: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudProjectUserRoleArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'CloudProjectUser':
        """
        Get an existing CloudProjectUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_date: the date the user was created.
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, Any]] openstack_rc: a convenient map representing an openstack_rc file.
               Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[str] password: (Sensitive) the password generated for the user. The password can
               be used with the Openstack API. This attribute is sensitive and will only be
               retrieve once during creation.
        :param pulumi.Input[str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: A list of role names. Values can be: 
               - administrator,
               - ai_training_operator
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudProjectUserRoleArgs']]]] roles: A list of roles associated with the user.
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[str] status: the status of the user. should be normally set to 'ok'.
        :param pulumi.Input[str] username: the username generated for the user. This username can be used with
               the Openstack API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudProjectUserState.__new__(_CloudProjectUserState)

        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["description"] = description
        __props__.__dict__["openstack_rc"] = openstack_rc
        __props__.__dict__["password"] = password
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["role_names"] = role_names
        __props__.__dict__["roles"] = roles
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["username"] = username
        return CloudProjectUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[str]:
        """
        the date the user was created.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="openstackRc")
    def openstack_rc(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        a convenient map representing an openstack_rc file.
        Note: no password nor sensitive token is set in this map.
        """
        return pulumi.get(self, "openstack_rc")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        (Sensitive) the password generated for the user. The password can
        be used with the Openstack API. This attribute is sensitive and will only be
        retrieve once during creation.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of a role. See `role_names`.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of role names. Values can be: 
        - administrator,
        - ai_training_operator
        - authentication
        - backup_operator
        - compute_operator
        - image_operator
        - infrastructure_supervisor
        - network_operator
        - network_security_operator
        - objectstore_operator
        - volume_operator
        """
        return pulumi.get(self, "role_names")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence['outputs.CloudProjectUserRole']]:
        """
        A list of roles associated with the user.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The id of the public cloud project. If omitted,
        the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        the status of the user. should be normally set to 'ok'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        the username generated for the user. This username can be used with
        the Openstack API.
        """
        return pulumi.get(self, "username")

