# django_core_micha/auth/serializers.py
from rest_framework import serializers
from .recovery import RecoveryRequest

class RecoveryRequestSerializer(serializers.ModelSerializer):
    user_email = serializers.EmailField(source="user.email", read_only=True)

    class Meta:
        model = RecoveryRequest
        fields = (
            "id",
            "user",
            "user_email",
            "message",
            "support_note",
            "status",
            "created_at",
            "resolved_at",
        )
        read_only_fields = (
            "user",
            "status",
            "created_at",
            "resolved_at",
        )