# src/django_core_micha/auth/models.py
from django.db import models
from django.conf import settings
from django.utils import timezone

class AbstractUserProfile(models.Model):
    """
    Abstrakte Basisklasse. Definiert Standardfelder für alle Projekte.
    """
    user = models.OneToOneField(
        settings.AUTH_USER_MODEL, 
        on_delete=models.CASCADE, 
        related_name="profile"
    )
    is_new = models.BooleanField(default=True)
    accepted_privacy_statement = models.BooleanField(default=False)
    accepted_convenience_cookies = models.BooleanField(default=False)

    class Meta:
        abstract = True  # WICHTIG: Erstellt keine Tabelle in der DB

