from django.conf import settings
from django.core.mail import send_mail
import logging

# Absoluter Import ist sicherer und klarer
from django_core_micha.emails import email_texts
from .recovery import RecoveryRequest

logger = logging.getLogger(__name__)

def send_recovery_link_to_user(rr: RecoveryRequest, recovery_url: str):
    """
    Sends the one-time recovery login link to the requesting user.
    """
    user = rr.user
    if not user or not user.email:
        return

    subject, message = email_texts.render_recovery_email(user, recovery_url)

    if getattr(settings, "ENV_TYPE", "") == "local":
        logger.info("[LOCAL] Recovery-Mail an %s: %s", user.email, recovery_url)
        return

    send_mail(
        subject,
        message,
        getattr(settings, "DEFAULT_FROM_EMAIL", None),
        [user.email],
        fail_silently=True, # Optional: auf False setzen, um Fehler im Log zu sehen
    )