# django_core_micha/api_urls.py
from django.urls import path, include
from rest_framework.routers import DefaultRouter

# Views
from django_core_micha.invitations.views import PasswordResetConfirmView
from django_core_micha.invitations import urls as invitations_urls
from django_core_micha.auth.views import (
    csrf_token_view, 
    RecoveryRequestViewSet, 
    recovery_complete_view
)

router = DefaultRouter()
router.register(
    r"recovery-requests",
    RecoveryRequestViewSet,
    basename="recovery-request",
)

urlpatterns = [
    # Allauth Headless Endpoints (Login, Signup, MFA, etc.)
    # URLs sind dann z.B. /api/auth/login, /api/auth/signup
    path("auth/", include("allauth.headless.urls")),
    
    # Hilfs-Endpoint für CSRF (wichtig für SPA)
    path("csrf/", csrf_token_view, name="csrf-token"),
    
    # Support-APIs (Recovery Requests verwalten)
    path("support/", include(router.urls)),
    
    # Recovery Abschluss (User klickt auf Link)
    path(
        "mfa/recovery/<str:token>/",
        recovery_complete_view,
        name="mfa-recovery-complete",
    ),

    # Password Reset Confirm (User klickt auf E-Mail Link)
    path(
        "users/password-reset/<uidb64>/<token>/", 
        PasswordResetConfirmView.as_view(), 
        name="password-reset-api"
    ),

    # Access-Code-API (Einladungen)
    # Hängt AccessCodeViewSet unter /access-codes/ ein
    path("", include(invitations_urls)),
]