"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_eks_HelmChartProps(props);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const timeout = (_b = props.timeout) === null || _b === void 0 ? void 0 : _b.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        if (!props.chart && !props.chartAsset) {
            throw new Error("Either 'chart' or 'chartAsset' must be specified to install a helm chart");
        }
        if (props.chartAsset && (props.repository || props.version)) {
            throw new Error("Neither 'repository' nor 'version' can be used when configuring 'chartAsset'");
        }
        // default not to wait
        const wait = (_c = props.wait) !== null && _c !== void 0 ? _c : false;
        // default to create new namespace
        const createNamespace = (_d = props.createNamespace) !== null && _d !== void 0 ? _d : true;
        (_e = props.chartAsset) === null || _e === void 0 ? void 0 : _e.grantRead(provider.handlerRole);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                Release: (_f = props.release) !== null && _f !== void 0 ? _f : core_1.Names.uniqueId(this).slice(-53).toLowerCase(),
                Chart: props.chart,
                ChartAssetURL: (_g = props.chartAsset) === null || _g === void 0 ? void 0 : _g.s3ObjectUrl,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: (_h = props.namespace) !== null && _h !== void 0 ? _h : 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
            },
        });
    }
}
exports.HelmChart = HelmChart;
_a = JSII_RTTI_SYMBOL_1;
HelmChart[_a] = { fqn: "@aws-cdk/aws-eks.HelmChart", version: "1.147.0" };
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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