# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RelationshipMetadata(Model):
    """Represents a Relationship.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param friendly_name: Gets the friendly name of the relationship.
    :type friendly_name: str
    :param name: Gets the unique name for relationship
    :type name: str
    :param description: Gets the description for relationship
    :type description: str
    :param relationship_type: Possible values include:
     'singleKeyRelationshipOrigin', 'singleKeyRelationshipDestination',
     'dataSourceLineageOrigin', 'dataSourceLineageDestination'
    :type relationship_type: str or ~dynamics.customerinsights.api.models.enum
    :param from_attribute_name: Gets the name of the foreign key reference
     attribute that this relationship originates from.
    :type from_attribute_name: str
    :param from_entity_name: Gets the name of the entity this relationship
     originates from.
    :type from_entity_name: str
    :param to_attribute_name: Gets the name of the foreign key attribute that
     this relationship points to.
    :type to_attribute_name: str
    :param to_entity_name: Gets the name of the entity this relationship
     points to.
    :type to_entity_name: str
    :param cardinality: Possible values include: 'oneToMany', 'oneToOne'
    :type cardinality: str or ~dynamics.customerinsights.api.models.enum
    :ivar version: Gets the version number of this object.
    :vartype version: long
    :ivar updated_by: Gets the UPN of the user who last updated this record.
    :vartype updated_by: str
    :ivar updated_utc: Gets the time the object was last updated.
    :vartype updated_utc: datetime
    :ivar created_by: Gets the email address of the user who created this
     record.
    :vartype created_by: str
    :ivar created_utc: Gets the time the object was initially created.
    :vartype created_utc: datetime
    :ivar instance_id: Gets the Customer Insights instance id associated with
     this object.
    :vartype instance_id: str
    """

    _validation = {
        'version': {'readonly': True},
        'updated_by': {'readonly': True},
        'updated_utc': {'readonly': True},
        'created_by': {'readonly': True},
        'created_utc': {'readonly': True},
        'instance_id': {'readonly': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'relationship_type': {'key': 'relationshipType', 'type': 'str'},
        'from_attribute_name': {'key': 'fromAttributeName', 'type': 'str'},
        'from_entity_name': {'key': 'fromEntityName', 'type': 'str'},
        'to_attribute_name': {'key': 'toAttributeName', 'type': 'str'},
        'to_entity_name': {'key': 'toEntityName', 'type': 'str'},
        'cardinality': {'key': 'cardinality', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'updated_utc': {'key': 'updatedUtc', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_utc': {'key': 'createdUtc', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, name: str=None, description: str=None, relationship_type=None, from_attribute_name: str=None, from_entity_name: str=None, to_attribute_name: str=None, to_entity_name: str=None, cardinality=None, **kwargs) -> None:
        super(RelationshipMetadata, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.name = name
        self.description = description
        self.relationship_type = relationship_type
        self.from_attribute_name = from_attribute_name
        self.from_entity_name = from_entity_name
        self.to_attribute_name = to_attribute_name
        self.to_entity_name = to_entity_name
        self.cardinality = cardinality
        self.version = None
        self.updated_by = None
        self.updated_utc = None
        self.created_by = None
        self.created_utc = None
        self.instance_id = None
