# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IAttributeSearchProperties(Model):
    """IAttributeSearchProperties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar is_searchable: Gets a value indicating whether the attribute
     supports full text search.
    :vartype is_searchable: bool
    :ivar is_filterable: Gets a value indicating whether the attribute
     supports filtering.
    :vartype is_filterable: bool
    :ivar is_facetable: Gets a value indicating whether the attribute can be
     included as facet results.
    :vartype is_facetable: bool
    :ivar is_sortable: Gets a value indicating whether the attribute can be
     included in orderby directives.
    :vartype is_sortable: bool
    :ivar facet_specification: Gets an optional specification for search
     faceting used at query time (advanced).
     this is the part behind the comma in the examples below.
     bucket facet: "price,interval:10"
     other type: "listPrice,values:10|25|100|500|1000|2500"
     value facet: city,count:5
    :vartype facet_specification: str
    """

    _validation = {
        'is_searchable': {'readonly': True},
        'is_filterable': {'readonly': True},
        'is_facetable': {'readonly': True},
        'is_sortable': {'readonly': True},
        'facet_specification': {'readonly': True},
    }

    _attribute_map = {
        'is_searchable': {'key': 'isSearchable', 'type': 'bool'},
        'is_filterable': {'key': 'isFilterable', 'type': 'bool'},
        'is_facetable': {'key': 'isFacetable', 'type': 'bool'},
        'is_sortable': {'key': 'isSortable', 'type': 'bool'},
        'facet_specification': {'key': 'facetSpecification', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IAttributeSearchProperties, self).__init__(**kwargs)
        self.is_searchable = None
        self.is_filterable = None
        self.is_facetable = None
        self.is_sortable = None
        self.facet_specification = None
