# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class CustomerInsightsConfiguration(Configuration):
    """Configuration for CustomerInsights
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        if not base_url:
            base_url = 'https://api.ci.ai.dynamics.com/v1'

        super(CustomerInsightsConfiguration, self).__init__(base_url)

        self.add_user_agent('customerinsights/{}'.format(VERSION))


class CustomerInsights(SDKClient):
    """API version 1.0

    :ivar config: Configuration for client.
    :vartype config: CustomerInsightsConfiguration

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        self.config = CustomerInsightsConfiguration(base_url)
        super(CustomerInsights, self).__init__(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def get_an_attribute_profile(
            self, instance_id, qualified_entity_name, attribute_name, custom_headers=None, raw=False, **operation_config):
        """Gets the specific attribute profile for the entity.

        Gets the specific attribute profile for the entity.

        :param instance_id: Format - uuid. Customer Insights instance id.
        :type instance_id: str
        :param qualified_entity_name: Qualified Entity Name.
        :type qualified_entity_name: str
        :param attribute_name: Attribute Name.
        :type attribute_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_an_attribute_profile.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'qualifiedEntityName': self._serialize.url("qualified_entity_name", qualified_entity_name, 'str'),
            'attributeName': self._serialize.url("attribute_name", attribute_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('AttributeDataProfile', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_an_attribute_profile.metadata = {'url': '/instances/{instanceId}/dataprofile/{qualifiedEntityName}/{attributeName}'}

    def get_all_data_sources(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Fetches a collection of DataSourceInfo configured for the Customer
        Insights instance.

        Fetches a collection of DataSourceInfo configured for the Customer
        Insights instance.

        :param instance_id: Format - uuid. The instance id for which to fetch
         data source info.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_data_sources.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[DataSourceInfo]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_data_sources.metadata = {'url': '/instances/{instanceId}/manage/datasources'}

    def get_data_source(
            self, instance_id, data_source_id, custom_headers=None, raw=False, **operation_config):
        """Fetches a DataSourceInfo matching the dataSourceId configured for the
        Customer Insights instance.

        Fetches a DataSourceInfo matching the dataSourceId configured for the
        Customer Insights instance.

        :param instance_id: Format - uuid. The instance id to fetch data
         source info for.
        :type instance_id: str
        :param data_source_id: Format - uuid. The data source id to fetch info
         for.
        :type data_source_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_data_source.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'dataSourceId': self._serialize.url("data_source_id", data_source_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('DataSourceInfo', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_data_source.metadata = {'url': '/instances/{instanceId}/manage/datasources/{dataSourceId}'}

    def delete_a_data_source(
            self, instance_id, data_source_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a data source from the instance.

        Deletes a data source from the instance.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param data_source_id: Format - uuid. The data source id.
        :type data_source_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_a_data_source.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'dataSourceId': self._serialize.url("data_source_id", data_source_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('OkResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    delete_a_data_source.metadata = {'url': '/instances/{instanceId}/manage/datasources/{dataSourceId}'}

    def create_an_entity(
            self, instance_id, entity_name, body=None, valid_until=None, caller=None, custom_headers=None, raw=False, **operation_config):
        """Writes an entity instance into the store, g. an activity entity.
        (Preview).

        Writes an entity instance into the store, g. an activity entity.
        (Preview).

        :param instance_id: Format - uuid. Customer Insights instance Id.
        :type instance_id: str
        :param entity_name: Fully qualified entity name, consisting of
         'DataSource_EntityName' e.g. 'PoS_posPurchases', or 'UnifiedActivity'.
        :type entity_name: str
        :param body: JSON document representing the entity. The schema must be
         consistent with the entity metadata. Use GET action of this resource
         to obtain an example.
        :type body: str
        :param valid_until: Format - date-time (as date-time in RFC3339).
         Expiration time of the change; ISO8601; optional. The value can be
         maximum 30 days in the future. If the datasource for this entity
         doesn't contain the changes after this time, the update disappears
         from the store.
        :type valid_until: str
        :param caller: String to identify the caller; optional.
        :type caller: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_an_entity.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'entityName': self._serialize.url("entity_name", entity_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if valid_until is not None:
            query_parameters['validUntil'] = self._serialize.query("valid_until", valid_until, 'str')
        if caller is not None:
            query_parameters['caller'] = self._serialize.query("caller", caller, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'str')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 202, 400, 401, 409, 429, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 201:
            deserialized = self._deserialize('CreatedResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }
        if response.status_code == 202:
            deserialized = self._deserialize('AcceptedResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }
        if response.status_code == 409:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    create_an_entity.metadata = {'url': '/instances/{instanceId}/data/{entityName}'}

    def update_an_entity(
            self, instance_id, entity_name, entity_id, body=None, valid_until=None, caller=None, custom_headers=None, raw=False, **operation_config):
        """Updates an entity instance in the store, g. Customer entity. (Preview).

        Updates an entity instance in the store, g. Customer entity. (Preview).

        :param instance_id: Format - uuid. Customer Insights instance Id.
        :type instance_id: str
        :param entity_name: Fully qualified entity name, e.g. 'Customer'.
        :type entity_name: str
        :param entity_id: Id of the entity to update, e.g. 'CustomerId' of a
         Customer entity.
        :type entity_id: str
        :param body: JSON document with set of changes to apply on the entity.
         Each change must be consistent with the entity metadata. Use GET
         action of this resource to obtain an example.
        :type body: str
        :param valid_until: Format - date-time (as date-time in RFC3339).
         Expiration time of the change; ISO8601; optional. The value can be
         maximum 30 days in the future. If the datasource for this entity
         doesn't contain the changes after this time, the update disappears
         from the store.
        :type valid_until: str
        :param caller: String to identify the caller; optional.
        :type caller: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_an_entity.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'entityName': self._serialize.url("entity_name", entity_name, 'str'),
            'entityId': self._serialize.url("entity_id", entity_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if valid_until is not None:
            query_parameters['validUntil'] = self._serialize.query("valid_until", valid_until, 'str')
        if caller is not None:
            query_parameters['caller'] = self._serialize.query("caller", caller, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'str')
        else:
            body_content = None

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 400, 401, 404, 429, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 204:
            deserialized = self._deserialize('NoContentResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
                'Retry-After': 'int',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_an_entity.metadata = {'url': '/instances/{instanceId}/data/{entityName}/{entityId}'}

    def get_entities_with_odata_path(
            self, instance_id, relative_path, force_search=None, proxy=None, search=None, select=None, skip=None, skiptoken=None, filter=None, orderby=None, expand=None, top=None, custom_headers=None, raw=False, **operation_config):
        """Submits an OData request to the service.

        Submits an OData request to the service.

        :param instance_id: Format - uuid. Customer Insights instance id.
        :type instance_id: str
        :param relative_path: Relative OData path. See
         https://www.odata.org/getting-started/basic-tutorial/ for info.
        :type relative_path: str
        :param force_search: Whether force use search to support the query.
        :type force_search: bool
        :param proxy: Whether or not we are requesting data by proxy.
        :type proxy: bool
        :param search: Search OData parameter.
        :type search: str
        :param select: Select OData parameter.
        :type select: str
        :param skip: Skip OData parameter.
        :type skip: str
        :param skiptoken: SkipToken OData parameter.
        :type skiptoken: str
        :param filter: Filter OData parameter.
        :type filter: str
        :param orderby: OrderBy OData parameter.
        :type orderby: str
        :param expand: Expand OData parameter.
        :type expand: str
        :param top: Top OData parameter.
        :type top: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_entities_with_odata_path.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'relativePath': self._serialize.url("relative_path", relative_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if force_search is not None:
            query_parameters['forceSearch'] = self._serialize.query("force_search", force_search, 'bool')
        if proxy is not None:
            query_parameters['proxy'] = self._serialize.query("proxy", proxy, 'bool')
        if search is not None:
            query_parameters['$search'] = self._serialize.query("search", search, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if skip is not None:
            query_parameters['$skip'] = self._serialize.query("skip", skip, 'str')
        if skiptoken is not None:
            query_parameters['$skiptoken'] = self._serialize.query("skiptoken", skiptoken, 'str')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if orderby is not None:
            query_parameters['$orderby'] = self._serialize.query("orderby", orderby, 'str')
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('ODataEntityPayload', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ODataError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_entities_with_odata_path.metadata = {'url': '/instances/{instanceId}/data/{relativePath}'}

    def get_all_entity_metadata(
            self, instance_id, attributes_annotations=False, include_quarantined=False, custom_headers=None, raw=False, **operation_config):
        """Retrieves the flattened entity model for the provided instanceId.

        Retrieves the flattened entity model for the provided instanceId.

        :param instance_id: Format - uuid. Customer Insights instance id.
        :type instance_id: str
        :param attributes_annotations: Indicates if extra annotations like
         'ReadOnly' or 'Mandatory' should be included.
        :type attributes_annotations: bool
        :param include_quarantined: Indicates if quarantined entities should
         be included in the output entity model.
        :type include_quarantined: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_entity_metadata.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if attributes_annotations is not None:
            query_parameters['attributesAnnotations'] = self._serialize.query("attributes_annotations", attributes_annotations, 'bool')
        if include_quarantined is not None:
            query_parameters['includeQuarantined'] = self._serialize.query("include_quarantined", include_quarantined, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('IC360EntityModel', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_entity_metadata.metadata = {'url': '/instances/{instanceId}/manage/entities'}

    def get_entity_metadata(
            self, instance_id, entity_name, attributes_annotations=False, custom_headers=None, raw=False, **operation_config):
        """Retrieves the entity metadata for the provided instanceId and
        entityName.

        Retrieves the entity metadata for the provided instanceId and
        entityName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param entity_name: Entity name
        :type entity_name: str
        :param attributes_annotations: Indicates if extra annotations like
         'ReadOnly' or 'Mandatory' should be included.
        :type attributes_annotations: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_entity_metadata.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'entityName': self._serialize.url("entity_name", entity_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if attributes_annotations is not None:
            query_parameters['attributesAnnotations'] = self._serialize.query("attributes_annotations", attributes_annotations, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('IEntityMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_entity_metadata.metadata = {'url': '/instances/{instanceId}/manage/entities/{entityName}'}

    def get_entity_size(
            self, instance_id, entity_name, custom_headers=None, raw=False, **operation_config):
        """Retrieves the entity size for the provided instanceId and entityName.

        Retrieves the entity size for the provided instanceId and entityName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param entity_name: Entity name
        :type entity_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_entity_size.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'entityName': self._serialize.url("entity_name", entity_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('EntitySize', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_entity_size.metadata = {'url': '/instances/{instanceId}/manage/entities/{entityName}/entitysize'}

    def reset_an_instance(
            self, instance_id, instance_management_operation_scope=None, custom_headers=None, raw=False, **operation_config):
        """Reset scopes in the given instance. Provide optional management
        operation scope to reset only that scope. (Preview).

        Reset scopes in the given instance. Provide optional management
        operation scope to reset only that scope. (Preview).

        :param instance_id: Format - uuid. The instance Id.
        :type instance_id: str
        :param instance_management_operation_scope: The management operation
         scope for reset.
        :type instance_management_operation_scope: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.reset_an_instance.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if instance_management_operation_scope is not None:
            query_parameters['instanceManagementOperationScope'] = self._serialize.query("instance_management_operation_scope", instance_management_operation_scope, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('bool', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 403:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    reset_an_instance.metadata = {'url': '/instances/{instanceId}/manage/reset'}

    def reset_instance_for_scope(
            self, instance_id, instance_management_operation_scope, custom_headers=None, raw=False, **operation_config):
        """Reset scopes in the given instance. Provide optional management
        operation scope to reset only that scope. (Preview).

        Reset scopes in the given instance. Provide optional management
        operation scope to reset only that scope. (Preview).

        :param instance_id: Format - uuid. The instance Id.
        :type instance_id: str
        :param instance_management_operation_scope: The management operation
         scope for reset.
        :type instance_management_operation_scope: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.reset_instance_for_scope.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'instanceManagementOperationScope': self._serialize.url("instance_management_operation_scope", instance_management_operation_scope, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('bool', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 403:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    reset_instance_for_scope.metadata = {'url': '/instances/{instanceId}/manage/reset/operationScope/{instanceManagementOperationScope}'}

    def get_all_instances(
            self, custom_headers=None, raw=False, **operation_config):
        """Retrieves all instances of the current user.

        Retrieves all instances of the current user.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_instances.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[InstanceInfo]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_instances.metadata = {'url': '/instances'}

    def get_all_instances_in_batches_by_instanceids(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Retrieves instances based on instance ids, it can only accept batch of
        instances.

        Retrieves instances based on instance ids, it can only accept batch of
        instances.

        :param body: Instance ids of instances to get.
        :type body: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_instances_in_batches_by_instanceids.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[str]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[InstanceInfo]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_instances_in_batches_by_instanceids.metadata = {'url': '/instances/batch'}

    def get_instance_metadata(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Retrieves metadata for a Customer Insights instance based on its
        instanceId.

        Retrieves metadata for a Customer Insights instance based on its
        instanceId.

        :param instance_id: Format - uuid. Unique id for the Customer Insights
         instance.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_instance_metadata.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('InstanceMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_instance_metadata.metadata = {'url': '/instances/{instanceId}'}

    def delete_an_instance(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Detele an instance.

        Detele an instance.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_an_instance.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('bool', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 403:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    delete_an_instance.metadata = {'url': '/instances/{instanceId}'}

    def create_an_instance(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new instance.

        Creates a new instance.

        :param body: The instance creation request.
        :type body:
         ~dynamics.customerinsights.api.models.InstanceCreationRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_an_instance.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstanceCreationRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 409, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('InstanceMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 403:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 409:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    create_an_instance.metadata = {'url': '/instances/V2'}

    def update_an_instance(
            self, instance_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Patches the Market Verticals, Display name, Domain Name, CDS
        environment and BYOSA secret to the instance.

        Patches the Market Verticals, Display name, Domain Name, CDS
        environment and BYOSA secret to the instance.

        :param instance_id: Format - uuid.
        :type instance_id: str
        :param body:
        :type body:
         ~dynamics.customerinsights.api.models.InstanceCreationRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_an_instance.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstanceCreationRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('InstanceMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_an_instance.metadata = {'url': '/instances/{instanceId}/V2'}

    def copy_an_instance(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Create a new instance and copy metadata from an existing instance.

        Create a new instance and copy metadata from an existing instance.

        :param body: The metadata to use to create the new instance.
        :type body: ~dynamics.customerinsights.api.models.InstanceCopyRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.copy_an_instance.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstanceCopyRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 409, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('InstanceMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 403:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 409:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    copy_an_instance.metadata = {'url': '/instances/copy'}

    def get_a_list_of_measures_metadata(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Retrieves a list of measures metadata for the provided instanceId.

        Retrieves a list of measures metadata for the provided instanceId.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_a_list_of_measures_metadata.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[MeasureMetadata]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_a_list_of_measures_metadata.metadata = {'url': '/instances/{instanceId}/manage/measures'}

    def create_a_measure(
            self, instance_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Create new measure metadata with measureMetadata on instanceId.

        Create new measure metadata with measureMetadata on instanceId.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param body: New Measure metadata to be created
        :type body: ~dynamics.customerinsights.api.models.MeasureMetadata
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_a_measure.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'MeasureMetadata')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('MeasureMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ParsingError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    create_a_measure.metadata = {'url': '/instances/{instanceId}/manage/measures'}

    def get_metadata_for_a_measure(
            self, instance_id, measure_name, include_historic_stats=False, historic_stats_days=30, custom_headers=None, raw=False, **operation_config):
        """Retrieves the measure metadata for the provided instanceId and
        measureName.

        Retrieves the measure metadata for the provided instanceId and
        measureName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param measure_name: Name of the measure
        :type measure_name: str
        :param include_historic_stats: Boolean for historical stats
        :type include_historic_stats: bool
        :param historic_stats_days: Format - int32. Number of lookback days
        :type historic_stats_days: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_metadata_for_a_measure.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'measureName': self._serialize.url("measure_name", measure_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_historic_stats is not None:
            query_parameters['includeHistoricStats'] = self._serialize.query("include_historic_stats", include_historic_stats, 'bool')
        if historic_stats_days is not None:
            query_parameters['historicStatsDays'] = self._serialize.query("historic_stats_days", historic_stats_days, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('MeasureMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_metadata_for_a_measure.metadata = {'url': '/instances/{instanceId}/manage/measures/{measureName}'}

    def update_a_measure(
            self, instance_id, measure_name, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates measures metadata for the provided instanceId and
        measureMetadata.
        Existing measure is retrieved using measureName.

        Updates measures metadata for the provided instanceId and
        measureMetadata.
        Existing measure is retrieved using measureName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param measure_name: Name of the measure
        :type measure_name: str
        :param body: Update measure metadata
        :type body: ~dynamics.customerinsights.api.models.MeasureMetadata
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_a_measure.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'measureName': self._serialize.url("measure_name", measure_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'MeasureMetadata')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('MeasureMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ParsingError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_a_measure.metadata = {'url': '/instances/{instanceId}/manage/measures/{measureName}'}

    def delete_a_measure(
            self, instance_id, measure_name, custom_headers=None, raw=False, **operation_config):
        """Deletes the measure metadata for the provided instanceId using
        measureName.

        Deletes the measure metadata for the provided instanceId using
        measureName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param measure_name: Name of the measure
        :type measure_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_a_measure.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'measureName': self._serialize.url("measure_name", measure_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('DeletionResponse', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('DeletionResponse', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    delete_a_measure.metadata = {'url': '/instances/{instanceId}/manage/measures/{measureName}'}

    def get_key_ring(
            self, instance_id, data_source_name, entity_name, key, custom_headers=None, raw=False, **operation_config):
        """Gets the KeyRing (collection of all alternate keys) for the given
        instance by alternate key.

        Gets the KeyRing (collection of all alternate keys) for the given
        instance by alternate key.

        :param instance_id: Format - uuid. Identifier for the instance
        :type instance_id: str
        :param data_source_name: The name of the datasource that contains the
         given entity.
        :type data_source_name: str
        :param entity_name: The name of the entity that contains the given
         key.
        :type entity_name: str
        :param key: The value of the alternate key provided.
        :type key: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ApiErrorResult or ClientRawResponse if raw=true
        :rtype: ~dynamics.customerinsights.api.models.ApiErrorResult or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_key_ring.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['dataSourceName'] = self._serialize.query("data_source_name", data_source_name, 'str')
        query_parameters['entityName'] = self._serialize.query("entity_name", entity_name, 'str')
        query_parameters['key'] = self._serialize.query("key", key, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 400:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_key_ring.metadata = {'url': '/instances/{instanceId}/profile/keyring'}

    def get_profile_store_state(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Gets the profile store state infoformation.

        Gets the profile store state infoformation.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_profile_store_state.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileStoreStateInfo', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_profile_store_state.metadata = {'url': '/instances/{instanceId}/profilestore/stateinfo'}

    def get_all_role_definitions(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Get all role definitions.

        Get all role definitions.

        :param instance_id:
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~dynamics.customerinsights.api.models.RoleDefinition] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_role_definitions.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[RoleDefinition]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_role_definitions.metadata = {'url': '/instances/{instanceId}/rbac/roles'}

    def get_current_user_role(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Get role of current user.

        Get role of current user.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RoleAssignment or ClientRawResponse if raw=true
        :rtype: ~dynamics.customerinsights.api.models.RoleAssignment or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_current_user_role.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('RoleAssignment', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_current_user_role.metadata = {'url': '/instances/{instanceId}/rbac/myrole'}

    def update_a_role_assignment(
            self, instance_id, principal_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Adds or updates a role assignment for a principal.

        Adds or updates a role assignment for a principal.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param principal_id: The principal id.
        :type principal_id: str
        :param body: The role assignment.
        :type body: ~dynamics.customerinsights.api.models.RoleAssignment
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~dynamics.customerinsights.api.models.RoleAssignment] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_a_role_assignment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'principalId': self._serialize.url("principal_id", principal_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'RoleAssignment')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[RoleAssignment]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_a_role_assignment.metadata = {'url': '/instances/{instanceId}/rbac/principals/{principalId}/assignment'}

    def deletes_a_role_assignment(
            self, instance_id, principal_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a role assignment for the principal.

        Deletes a role assignment for the principal.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param principal_id: The principal id.
        :type principal_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.deletes_a_role_assignment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'principalId': self._serialize.url("principal_id", principal_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'WWW-Authenticate': 'str',
            })
            return client_raw_response
    deletes_a_role_assignment.metadata = {'url': '/instances/{instanceId}/rbac/principals/{principalId}/assignment'}

    def get_all_role_assignments(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Gets all role assignments for the instance.

        Gets all role assignments for the instance.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~dynamics.customerinsights.api.models.RoleAssignment] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_role_assignments.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[RoleAssignment]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_role_assignments.metadata = {'url': '/instances/{instanceId}/rbac/assignments'}

    def get_all_relationships(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Gets all relationship metadata for the provided instanceId.

        Gets all relationship metadata for the provided instanceId.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_relationships.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[RelationshipMetadata]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_relationships.metadata = {'url': '/instances/{instanceId}/manage/relationships'}

    def create_a_relationship(
            self, instance_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates new relationship metadata for the provided instanceId, using
        input.

        Creates new relationship metadata for the provided instanceId, using
        input.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param body: The updated relationship metadata
        :type body: ~dynamics.customerinsights.api.models.RelationshipMetadata
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_a_relationship.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'RelationshipMetadata')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('RelationshipMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    create_a_relationship.metadata = {'url': '/instances/{instanceId}/manage/relationships'}

    def get_a_relationship(
            self, instance_id, relationship_name, custom_headers=None, raw=False, **operation_config):
        """Gets the relationship metadata for the provided instanceId and
        relationshipName.

        Gets the relationship metadata for the provided instanceId and
        relationshipName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param relationship_name: Relationship name
        :type relationship_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_a_relationship.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'relationshipName': self._serialize.url("relationship_name", relationship_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('RelationshipMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_a_relationship.metadata = {'url': '/instances/{instanceId}/manage/relationships/{relationshipName}'}

    def delete_a_relationship(
            self, instance_id, relationship_name, custom_headers=None, raw=False, **operation_config):
        """Deletes the relationship metadata for the provided instanceId and
        relationshipName.

        Deletes the relationship metadata for the provided instanceId and
        relationshipName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param relationship_name: Relationship name
        :type relationship_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_a_relationship.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'relationshipName': self._serialize.url("relationship_name", relationship_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('DeletionResponse', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    delete_a_relationship.metadata = {'url': '/instances/{instanceId}/manage/relationships/{relationshipName}'}

    def update_a_relationship(
            self, instance_id, relationship_name, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates the relationship metadata for the provided instanceId and
        relationshipName, using input.

        Updates the relationship metadata for the provided instanceId and
        relationshipName, using input.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param relationship_name: Relationship name
        :type relationship_name: str
        :param body: The updated relationship metadata
        :type body: ~dynamics.customerinsights.api.models.RelationshipMetadata
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_a_relationship.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'relationshipName': self._serialize.url("relationship_name", relationship_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'RelationshipMetadata')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('RelationshipMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_a_relationship.metadata = {'url': '/instances/{instanceId}/manage/relationships/{relationshipName}'}

    def get_search_configuration(
            self, instance_id, custom_headers=None, raw=False, **operation_config):
        """Gets the search configuration for the instance.

        Gets the search configuration for the instance.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_search_configuration.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('InstanceSearchConfiguration', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_search_configuration.metadata = {'url': '/instances/{instanceId}/manage/search'}

    def update_search_configuration(
            self, instance_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates the search configuration for the instance.

        Updates the search configuration for the instance.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param body: The search configuration for the instance.
        :type body:
         ~dynamics.customerinsights.api.models.InstanceSearchConfiguration
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_search_configuration.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstanceSearchConfiguration')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('InstanceSearchConfiguration', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 503:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_search_configuration.metadata = {'url': '/instances/{instanceId}/manage/search'}

    def get_all_segments(
            self, instance_id, include_historic_stats=False, historic_stats_days=10, custom_headers=None, raw=False, **operation_config):
        """Retrieves a list of segment metadata for the provided instanceId.

        Retrieves a list of segment metadata for the provided instanceId.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param include_historic_stats: Optional parameter to retrieve
         evaluation history of all the sgements in instanceId.
        :type include_historic_stats: bool
        :param historic_stats_days: Format - int32. Optional parameter to get
         number of days evaluation history.
        :type historic_stats_days: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_all_segments.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_historic_stats is not None:
            query_parameters['includeHistoricStats'] = self._serialize.query("include_historic_stats", include_historic_stats, 'bool')
        if historic_stats_days is not None:
            query_parameters['historicStatsDays'] = self._serialize.query("historic_stats_days", historic_stats_days, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[SegmentMetadata]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_segments.metadata = {'url': '/instances/{instanceId}/manage/segments'}

    def create_a_segment(
            self, instance_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Create new segment metadata with segmentMetadata on instanceId.

        Create new segment metadata with segmentMetadata on instanceId.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param body: New Segment metadata to be created
        :type body: ~dynamics.customerinsights.api.models.SegmentMetadata
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_a_segment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SegmentMetadata')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 201:
            deserialized = self._deserialize('SegmentMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    create_a_segment.metadata = {'url': '/instances/{instanceId}/manage/segments'}

    def activate_segment(
            self, instance_id, segment_name, custom_headers=None, raw=False, **operation_config):
        """Activate segment on instanceId with segmentName.

        Activate segment on instanceId with segmentName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param segment_name: Unique name of a segment
        :type segment_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.activate_segment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'segmentName': self._serialize.url("segment_name", segment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('bool', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    activate_segment.metadata = {'url': '/instances/{instanceId}/manage/segments/{segmentName}/activate'}

    def deactivate_segment(
            self, instance_id, segment_name, custom_headers=None, raw=False, **operation_config):
        """Deactivate segment on instanceId with segmentName.

        Deactivate segment on instanceId with segmentName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param segment_name: Unique name of a segment
        :type segment_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.deactivate_segment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'segmentName': self._serialize.url("segment_name", segment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('bool', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    deactivate_segment.metadata = {'url': '/instances/{instanceId}/manage/segments/{segmentName}/deactivate'}

    def update_a_segment(
            self, instance_id, segment_name, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates segment metadata for the provided instanceId and segmentName
        with segmentMetadata.

        Updates segment metadata for the provided instanceId and segmentName
        with segmentMetadata.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param segment_name: Unique name of a segment
        :type segment_name: str
        :param body: New Segment metadata to be updated
        :type body: ~dynamics.customerinsights.api.models.SegmentMetadata
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_a_segment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'segmentName': self._serialize.url("segment_name", segment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SegmentMetadata')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('SegmentMetadata', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    update_a_segment.metadata = {'url': '/instances/{instanceId}/manage/segments/{segmentName}'}

    def delete_segment(
            self, instance_id, segment_name, custom_headers=None, raw=False, **operation_config):
        """Deletes the segment metadata for the provided instanceId and
        segmentName.

        Deletes the segment metadata for the provided instanceId and
        segmentName.

        :param instance_id: Format - uuid. Customer Insights instance id
        :type instance_id: str
        :param segment_name: Unique name of a segment
        :type segment_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_segment.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'segmentName': self._serialize.url("segment_name", segment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('OkResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 400:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    delete_segment.metadata = {'url': '/instances/{instanceId}/manage/segments/{segmentName}'}

    def get_a_workflow_job_information(
            self, instance_id, workflow_name, job_id, include_tasks=False, custom_headers=None, raw=False, **operation_config):
        """Retrieve information about a workflow job.

        Retrieve information about a workflow job.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: The name of the workflow.
        :type workflow_name: str
        :param job_id: Format - uuid. The job id.
        :type job_id: str
        :param include_tasks: Flag to include tasks or not.
        :type include_tasks: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_a_workflow_job_information.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str'),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_tasks is not None:
            query_parameters['includeTasks'] = self._serialize.query("include_tasks", include_tasks, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('GraphJobInfo', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_a_workflow_job_information.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/jobs/{jobId}'}

    def cancel_a_workflow_job(
            self, instance_id, workflow_name, job_id, custom_headers=None, raw=False, **operation_config):
        """Cancel a job.

        Cancel a job.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: The name of the workflow.
        :type workflow_name: str
        :param job_id: Format - uuid. The job id.
        :type job_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.cancel_a_workflow_job.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str'),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('GraphJobInfo', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    cancel_a_workflow_job.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/jobs/{jobId}/cancel'}

    def get_list_of_recent_workflow_jobs(
            self, instance_id, workflow_name, top=10, include_tasks=False, custom_headers=None, raw=False, **operation_config):
        """Retrieves a list of recent job information.

        Retrieves a list of recent job information.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: The name of the workflow.
        :type workflow_name: str
        :param top: Format - int32. The number of job informations to
         retrieve.
        :type top: int
        :param include_tasks: Flag to include tasks or not.
        :type include_tasks: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_list_of_recent_workflow_jobs.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if top is not None:
            query_parameters['top'] = self._serialize.query("top", top, 'int')
        if include_tasks is not None:
            query_parameters['includeTasks'] = self._serialize.query("include_tasks", include_tasks, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[GraphJobInfo]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_list_of_recent_workflow_jobs.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/jobs'}

    def submit_a_workflow_job(
            self, instance_id, workflow_name, body=None, operation_type=None, identifiers=None, force_run_requested=False, custom_headers=None, raw=False, **operation_config):
        """Submits a workflow of OperationTypeoperationType for the instance
        specified in instanceId.
        Optionally takes a list of identifiers, only if operationType is not
        OperationType.All and a flag
        forceRunRequested indicating whether to force run.

        Submits a workflow of OperationTypeoperationType for the instance
        specified in instanceId.
        Optionally takes a list of identifiers, only if operationType is not
        OperationType.All and a flag
        forceRunRequested indicating whether to force run.

        :param instance_id: Format - uuid. The Customer Insights instance id.
        :type instance_id: str
        :param workflow_name: The workflow name.
        :type workflow_name: str
        :param body: Job Creation Request.
        :type body: ~dynamics.customerinsights.api.models.OnDemandJobRequest
        :param operation_type: The workflow operation type.
        :type operation_type: str
        :param identifiers: A list of workflow identifiers.
        :type identifiers: list[str]
        :param force_run_requested: Whether to request a force run.
        :type force_run_requested: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.submit_a_workflow_job.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if operation_type is not None:
            query_parameters['operationType'] = self._serialize.query("operation_type", operation_type, 'str')
        if identifiers is not None:
            query_parameters['identifiers'] = self._serialize.query("identifiers", identifiers, '[str]', div=',')
        if force_run_requested is not None:
            query_parameters['forceRunRequested'] = self._serialize.query("force_run_requested", force_run_requested, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'OnDemandJobRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('GraphJobInfo', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    submit_a_workflow_job.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/jobs'}

    def get_list_of_workflow_task_information_history(
            self, instance_id, workflow_name, top=10, custom_headers=None, raw=False, **operation_config):
        """Retrieves a list of historic task information for a workflow.

        Retrieves a list of historic task information for a workflow.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: The name of the workflow.
        :type workflow_name: str
        :param top: Format - int32. The number of task informations to
         retrieve.
        :type top: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_list_of_workflow_task_information_history.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if top is not None:
            query_parameters['top'] = self._serialize.query("top", top, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[GraphTaskInfo]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_list_of_workflow_task_information_history.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/history'}

    def get_workflow_status(
            self, instance_id, workflow_name, custom_headers=None, raw=False, **operation_config):
        """Gets the current status for a workflow.

        Gets the current status for a workflow.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: The workflow name.
        :type workflow_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_workflow_status.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[GraphNodeInfo]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_workflow_status.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/status'}

    def get_supported_timezones(
            self, workflow_name, instance_id, custom_headers=None, raw=False, **operation_config):
        """Gets a list of supported timezones for creating workflow schedules.

        Gets a list of supported timezones for creating workflow schedules.

        :param workflow_name: Any workflow name.
        :type workflow_name: str
        :param instance_id:
        :type instance_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_supported_timezones.metadata['url']
        path_format_arguments = {
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str'),
            'instanceId': self._serialize.url("instance_id", instance_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[TimezoneDetail]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_supported_timezones.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/schedules/supportedTimezones'}

    def get_workflow_schedules(
            self, instance_id, workflow_name, custom_headers=None, raw=False, **operation_config):
        """Gets all workflow refresh schedules.

        Gets all workflow refresh schedules.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: Any workflow name.
        :type workflow_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_workflow_schedules.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('[WorkflowRefreshSchedule]', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_workflow_schedules.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/schedules'}

    def create_workflow_refresh_schedule(
            self, instance_id, workflow_name, body=None, custom_headers=None, raw=False, **operation_config):
        """Create a workflow refresh schedule.

        Create a workflow refresh schedule.

        :param instance_id: Format - uuid. The instance id.
        :type instance_id: str
        :param workflow_name: Any workflow name.
        :type workflow_name: str
        :param body: A schedule object to create.
        :type body:
         ~dynamics.customerinsights.api.models.WorkflowRefreshSchedule
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_workflow_refresh_schedule.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'workflowName': self._serialize.url("workflow_name", workflow_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'WorkflowRefreshSchedule')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('WorkflowRefreshSchedule', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 500:
            deserialized = self._deserialize('ApiErrorResult', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    create_workflow_refresh_schedule.metadata = {'url': '/instances/{instanceId}/workflows/{workflowName}/schedules'}

    def get_an_entity_profile(
            self, instance_id, qualified_entity_name, custom_headers=None, raw=False, **operation_config):
        """Gets the entityProfile for the entity.

        Gets the entityProfile for the entity.

        :param instance_id: Format - uuid. Customer Insights instance id.
        :type instance_id: str
        :param qualified_entity_name: Qualified Entity Name.
        :type qualified_entity_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_an_entity_profile.metadata['url']
        path_format_arguments = {
            'instanceId': self._serialize.url("instance_id", instance_id, 'str'),
            'qualifiedEntityName': self._serialize.url("qualified_entity_name", qualified_entity_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404, 500, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('EntityDataProfile', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }
        if response.status_code == 404:
            deserialized = self._deserialize('ApiError', response)
            header_dict = {
                'WWW-Authenticate': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_an_entity_profile.metadata = {'url': '/instances/{instanceId}/dataprofile/{qualifiedEntityName}'}
