"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
class BaseDistribution extends core_1.Construct {
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        super(scope, id);
        const removalPolicy = (_d = props.removalPolicy) !== null && _d !== void 0 ? _d : core_1.RemovalPolicy.DESTROY;
        const origin = (_e = props.origin) !== null && _e !== void 0 ? _e : this.defaultOrigin(removalPolicy);
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            enabled: (_f = props.enabled) !== null && _f !== void 0 ? _f : true,
            enableIpv6: (_g = props.enableIpv6) !== null && _g !== void 0 ? _g : true,
            comment: props.comment,
            enableLogging: props.enableLogging,
            logBucket: props.logBucket,
            logIncludesCookies: props.logIncludesCookies,
            logFilePrefix: props.logFilePrefix,
            priceClass: (_h = props.priceClass) !== null && _h !== void 0 ? _h : aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
            geoRestriction: props.geoRestriction,
            httpVersion: (_j = props.httpVersion) !== null && _j !== void 0 ? _j : aws_cloudfront_1.HttpVersion.HTTP2,
            webAclId: props.webAclId,
            minimumProtocolVersion: props.minimumProtocolVersion,
            errorResponses: props.errorResponses,
            domainNames: props.domainNames,
            certificate: props.certificate,
            defaultBehavior: this.renderDefaultBehaviour(origin, props.authorization),
            additionalBehaviors: this.renderAdditionalBehaviors(origin, props.authorization),
            defaultRootObject: (_k = props.defaultRootObject) !== null && _k !== void 0 ? _k : 'index.html',
        });
        const callbackUrls = (_m = (_l = props.domainNames) === null || _l === void 0 ? void 0 : _l.map((name) => `https://${name}${props.authorization.redirectPaths.signIn}`)) !== null && _m !== void 0 ? _m : [];
        const logoutUrls = (_p = (_o = props.domainNames) === null || _o === void 0 ? void 0 : _o.map((name) => `https://${name}${props.authorization.redirectPaths.signOut}`)) !== null && _p !== void 0 ? _p : [];
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`, ...callbackUrls],
            logoutUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`, ...logoutUrls],
        });
        this.domainName = distribution.domainName;
        this.distributionDomainName = distribution.distributionDomainName;
        this.distributionId = distribution.distributionId;
        this.stack = core_1.Stack.of(this);
        this.env = {
            account: this.stack.account,
            region: this.stack.region,
        };
    }
    renderDefaultBehaviour(origin, authorization) {
        return authorization.createDefaultBehavior(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_DISABLED,
        });
    }
    renderAdditionalBehaviors(origin, authorization) {
        return authorization.createAdditionalBehaviors(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_DISABLED,
        });
    }
    defaultOrigin(removalPolicy) {
        const bucket = new aws_s3_1.Bucket(this, 'Bucket', {
            autoDeleteObjects: removalPolicy === core_1.RemovalPolicy.DESTROY,
            removalPolicy,
        });
        return new aws_cloudfront_origins_1.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
_a = JSII_RTTI_SYMBOL_1;
BaseDistribution[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.BaseDistribution", version: "1.29.0" };
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
_b = JSII_RTTI_SYMBOL_1;
StaticSiteDistribution[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteDistribution", version: "1.29.0" };
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        var _d;
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: (_d = props.ttl) !== null && _d !== void 0 ? _d : core_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
_c = JSII_RTTI_SYMBOL_1;
SpaDistribution[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaDistribution", version: "1.29.0" };
//# sourceMappingURL=data:application/json;base64,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