import { IUserPool, IUserPoolClient, OAuthScope } from '@aws-cdk/aws-cognito';
import { Construct } from '@aws-cdk/core';
import { EdgeFunction, LogLevel } from '@cloudcomponents/cdk-lambda-at-edge-pattern';
export interface RedirectPaths {
    readonly signIn: string;
    readonly authRefresh: string;
    readonly signOut: string;
}
export interface AuthFlowProps {
    readonly logLevel: LogLevel;
    readonly httpHeaders: Record<string, string>;
    readonly userPool: IUserPool;
    readonly userPoolClient: IUserPoolClient;
    readonly cognitoAuthDomain: string;
    readonly redirectPaths: RedirectPaths;
    readonly oauthScopes: OAuthScope[];
    readonly cookieSettings: Record<string, string>;
    readonly nonceSigningSecret: string;
    readonly clientSecret?: string;
}
export declare class AuthFlow extends Construct {
    readonly checkAuth: EdgeFunction;
    readonly parseAuth: EdgeFunction;
    readonly refreshAuth: EdgeFunction;
    readonly signOut: EdgeFunction;
    readonly httpHeaders: EdgeFunction;
    constructor(scope: Construct, id: string, props: AuthFlowProps);
}
