# auto generated by update_py.py

from tlclient.trader.client import Client
from tlclient.trader.constant import ExchangeID, OrderType, Side, OffsetFlag, MsgType, AssetType, FundTransType

import json
import time

class RiskTestClient(Client):

    def __init__(self, set_file: str, rc_file: str):
        settings = json.load(open(set_file))
        name = settings['name']
        env = settings['env']
        addr = settings['addr']
        Client.__init__(self, name, env, addr)
        self.tg = settings['tg']
        self.init_trade(settings['tr'])
        self.actions = settings['actions']

        rcs = json.load(open(rc_file))
        self.enable_self_trade_limit = rcs['enable_self_trade_limit']
        self.cancel_rate = rcs['cancel_rate']
        self.order_limit_per_second = rcs['order_limit_per_second']
        
        self.order_number = 0
        self.cancel_number = 0
        self.buy_orders = {}
        self.sell_orders = {}
        self.order_time = []

        self.ordergroups = {}

    def insert_orders(self, gid, mul, oinfo):
        oids = []
        for i in range(mul):
            oid = self.cur_insert_order(
                tg_name=self.tg,
                ticker = oinfo['ticker'],
                exchange = eval(oinfo['exchange']),
                price = oinfo['price'],
                volume = oinfo['volume'],
                order_type = eval(oinfo['order_type']),
                direction = eval(oinfo['direction'])
            )
            oids.append(oid)
        self.ordergroups[gid] = oids

    def cancel_orders(self, gid):
        oids = self.ordergroups.get(gid, [])
        for oid in oids:
            self.cancel_number += 1
            self.cancel_order(
                tg_name = self.tg,
                order_id = oid
            )

    def cur_insert_order(self, tg_name, ticker, exchange, price, volume, order_type, direction):
        if self.enable_self_trade_limit:
            if direction == Side.BUY:
                if self.sell_orders.get(ticker, 0) > 0:
                    self.stop()
                    raise Exception(f'[risk] !!! self trading potential on {ticker}')
                else:
                    self.buy_orders[ticker] = self.buy_orders.get(ticker, 0) + 1
            elif direction == Side.SELL:
                if self.buy_orders.get(ticker, 0) > 0:
                    self.stop()
                    raise Exception(f'[risk] !!! self trading potential on {ticker}')
                else:
                    self.sell_orders[ticker] = self.sell_orders.get(ticker, 0) + 1
        if self.cancel_rate > 0:
            if self.order_number > 10 and self.cancel_number > self.order_number * self.cancel_rate:
                self.stop()
                raise Exception(f'[risk] !!! cancel rate exceeds (cr){self.cancel_rate} (on){self.order_number} (cn){self.cancel_number}')

        tm = time.time()
        if self.order_limit_per_second > 0:
            if len(self.order_time) > self.order_limit_per_second:
                if tm - self.order_time[-self.order_limit_per_second] < 1:
                    self.stop()
                    raise Exception(f'[risk] !!! order speed exceed on {self.order_limit_per_second}')
                    
        
        self.order_number += 1
        self.order_time.append(tm)
        print(f'tg={tg_name} ticker={ticker} ex={exchange} p={price} v={volume} ot={order_type} d={direction}')
        return self.insert_order(tg_name=tg_name, ticker=ticker, exchange=exchange, price=price, volume=volume, order_type=order_type, direction=direction)

    def go(self):
        self.start()
        for ac in self.actions:
            tp = ac['type']
            if tp == 'sleep':
                sec = ac['seconds']
                time.sleep(sec)
                print(f'sleep {sec}')
            elif tp == 'order':
                mul = ac.get('mul', 1)
                gid = ac.get('id', 1)
                self.insert_orders(gid, mul, ac['info'])
            elif tp == 'cancel':
                gid = ac.get('id')
                self.cancel_orders(gid)
            
        self.stop()
        return 