# auto generated by update_py.py
import os

from tlclient.trader.constant import USER_RSA_KEY_DIR


class KeyHelper:

    @staticmethod
    def get_key_paths(key_name, path=USER_RSA_KEY_DIR):
        private_key_path = os.path.join(path, key_name)
        public_key_path = os.path.join(path, key_name + '.pub')
        return private_key_path, public_key_path

    @staticmethod
    def key_exists(key_name, path=USER_RSA_KEY_DIR):
        private_key_path, public_key_path = KeyHelper.get_key_paths(key_name, path)
        return os.path.exists(private_key_path) or os.path.exists(public_key_path)

    @staticmethod
    def write_key_to_file(key, path):
        with open(path, 'wb') as f:
            f.write(key)
        os.sync()

    @staticmethod
    def get_existed_key_names(path=USER_RSA_KEY_DIR):
        key_names = set()
        paths = os.listdir(path)
        for p in paths:
            if p.endswith('.pub'):
                key_names.add(p.split('.pub')[0])
        return key_names

    @staticmethod
    def get_private_key(key_name: str, path) -> str:
        if key_name:
            try:
                with open(os.path.join(path, key_name), 'r') as f:
                    return f.read()
            except OSError:
                pass
        return ''
