# auto generated by update_py.py

from sqlalchemy import CHAR, Column, Integer, Index, BOOLEAN, text, TEXT, VARCHAR, JSON, String, DateTime, Date
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.dialects.mysql import DOUBLE, DATE, DATETIME, SMALLINT, INTEGER


class Base:
    create_time = Column(DATETIME, nullable=False, server_default=text('CURRENT_TIMESTAMP'))  # 创建时间
    update_time = Column(DATETIME, nullable=False, server_default=text('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'))  # 更新时间
    is_deleted = Column(BOOLEAN, nullable=False, server_default=text('FALSE'))  # 是否删除 默认不删除


class SurfingBase:
    _update_time = Column(DATETIME, nullable=False, server_default=text('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'))  # 更新时间


# make this column at the end of every derived table
Base.create_time._creation_order = 9997
Base.update_time._creation_order = 9998
Base.is_deleted._creation_order = 9999
Base = declarative_base(cls=Base)

SurfingBase._update_time._creation_order = 9999
SurfingBase = declarative_base(cls=SurfingBase)

PureBase = declarative_base()


class AccountAfter(Base):
    '''accounts after trade'''

    __tablename__ = 'account_after'

    account_id = Column(VARCHAR(128), primary_key=True)  # 交易账户 tg_name
    date = Column(DATE, primary_key=True)  # 日期
    avail_amt = Column(DOUBLE(asdecimal=False), nullable=False)  # 可用资金
    balance = Column(DOUBLE(asdecimal=False), nullable=False)  # 账户余额
    equity = Column(DOUBLE(asdecimal=False), nullable=False)  # 动态权益
    frz_margin = Column(DOUBLE(asdecimal=False), nullable=False)  # 占用保证金
    commission = Column(DOUBLE(asdecimal=False), nullable=False)  # 手续费
    deposit = Column(DOUBLE(asdecimal=False))  # 入金金额
    withdraw = Column(DOUBLE(asdecimal=False))  # 出金金额
    pnl = Column(DOUBLE(asdecimal=False), nullable=False)  # 总盈亏
    realized_pnl = Column(DOUBLE(asdecimal=False), nullable=False)  # 平仓盈亏
    unrealized_pnl = Column(DOUBLE(asdecimal=False), nullable=False)  # 持仓盈亏


class TradeAfter(Base):
    '''trades after trade'''

    __tablename__ = 'trade_after'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account_id = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    date = Column(DATE, nullable=False)  # 日期
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    trade_ref = Column(VARCHAR(64), nullable=False)  # 成交ID
    order_id = Column(VARCHAR(64), nullable=False)  # order id
    order_ref = Column(VARCHAR(64), nullable=False)  # order ref
    exchange = Column(VARCHAR(32), nullable=False)  # 交易所
    offset_flag = Column(VARCHAR(16), nullable=False)  # 开平标志
    order_type = Column(VARCHAR(16))  # 委托类型
    side = Column(VARCHAR(16), nullable=False)  # 成交方向
    traded_vol = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交量
    traded_price = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交价格
    traded_amt = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交金额
    commission = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交金额
    trading_day = Column(DATE, nullable=False)  # 交易日
    trade_time = Column(Integer, nullable=False)  # 成交时间
    entrust_vol = Column(DOUBLE(asdecimal=False), nullable=False)  # 委托量
    entrust_price = Column(DOUBLE(asdecimal=False), nullable=False)  # 委托价格
    entrust_amt = Column(DOUBLE(asdecimal=False), nullable=False)  # 委托金额

    __table_args__ = (
        Index('idx_trade_after_account_id_date', 'account_id', 'date'),
    )


class TradeWithTag(Base):
    '''trades with tag'''

    __tablename__ = 'trade_with_tag'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account_id = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    date = Column(DATE, nullable=False)  # 日期
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    label = Column(TEXT, nullable=False)  # label
    trade_ref = Column(VARCHAR(64), nullable=False)  # 成交ID
    order_id = Column(VARCHAR(64), nullable=False)  # order id
    order_ref = Column(VARCHAR(64), nullable=False)  # order ref
    exchange = Column(VARCHAR(32), nullable=False)  # 交易所
    offset_flag = Column(VARCHAR(16), nullable=False)  # 开平标志
    order_type = Column(VARCHAR(16))  # 委托类型
    side = Column(VARCHAR(16), nullable=False)  # 成交方向
    traded_vol = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交量
    traded_price = Column(DOUBLE(asdecimal=False))  # 成交价格
    traded_amt = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交金额
    commission = Column(DOUBLE(asdecimal=False), nullable=False)  # 成交金额
    trading_day = Column(DATE, nullable=False)  # 交易日
    trade_time = Column(Integer)  # 成交时间
    entrust_vol = Column(DOUBLE(asdecimal=False), nullable=False)  # 委托量
    entrust_price = Column(DOUBLE(asdecimal=False), nullable=False)  # 委托价格
    entrust_amt = Column(DOUBLE(asdecimal=False), nullable=False)  # 委托金额
    is_internal = Column(BOOLEAN, nullable=False)  # 是否是内部 trade (即没有真正下单产生的虚拟成交)
    by_human = Column(BOOLEAN, nullable=False)  # 是否是人工添加

    __table_args__ = (
        Index('idx_trade_with_tag_account_id_date', 'account_id', 'date'),
    )


class PositionAfter(Base):
    '''positions after trade'''

    __tablename__ = 'position_after'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account_id = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    date = Column(DATE, nullable=False)  # 日期
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    exchange = Column(VARCHAR(32), nullable=False)  # 交易所
    direction = Column(VARCHAR(16), nullable=False)  # 持仓方向
    position = Column(DOUBLE(asdecimal=False))  # 总持仓
    yd_pos = Column(DOUBLE(asdecimal=False))  # 昨仓
    avail_pos = Column(DOUBLE(asdecimal=False))  # 可用持仓
    pos_cost = Column(DOUBLE(asdecimal=False))  # 持仓成本
    margin = Column(DOUBLE(asdecimal=False))  # 占用保证金
    pnl = Column(DOUBLE(asdecimal=False))  # 总盈亏
    realized_pnl = Column(DOUBLE(asdecimal=False))  # 平仓盈亏
    unrealized_pnl = Column(DOUBLE(asdecimal=False))  # 持仓盈亏
    frz_pos = Column(DOUBLE(asdecimal=False))  # 冻结持仓

    __table_args__ = (
        Index('idx_position_after_account_id_date', 'account_id', 'date'),
    )


class PositionBefore(Base):
    '''positions before trade'''

    __tablename__ = 'position_before'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account_id = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    date = Column(DATE, nullable=False)  # 日期
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    exchange = Column(VARCHAR(32), nullable=False)  # 交易所
    direction = Column(VARCHAR(16), nullable=False)  # 持仓方向
    position = Column(DOUBLE(asdecimal=False))  # 总持仓
    yd_pos = Column(DOUBLE(asdecimal=False))  # 昨仓
    avail_pos = Column(DOUBLE(asdecimal=False))  # 可用持仓
    pos_cost = Column(DOUBLE(asdecimal=False))  # 持仓成本
    margin = Column(DOUBLE(asdecimal=False))  # 占用保证金
    pnl = Column(DOUBLE(asdecimal=False))  # 总盈亏
    realized_pnl = Column(DOUBLE(asdecimal=False))  # 平仓盈亏
    unrealized_pnl = Column(DOUBLE(asdecimal=False))  # 持仓盈亏
    frz_pos = Column(DOUBLE(asdecimal=False))  # 冻结持仓

    __table_args__ = (
        Index('idx_position_before_account_id_date', 'account_id', 'date'),
    )


class PositionWithTag(Base):
    '''positions with tag'''

    __tablename__ = 'position_with_tag'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account_id = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    date = Column(DATE, nullable=False)  # 日期
    label = Column(TEXT, nullable=False)  # label
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    exchange = Column(VARCHAR(32), nullable=False)  # 交易所
    direction = Column(VARCHAR(16), nullable=False)  # 持仓方向
    position = Column(DOUBLE(asdecimal=False))  # 总持仓
    yd_pos = Column(DOUBLE(asdecimal=False))  # 昨仓
    avail_pos = Column(DOUBLE(asdecimal=False))  # 可用持仓
    pos_cost = Column(DOUBLE(asdecimal=False))  # 持仓成本
    margin = Column(DOUBLE(asdecimal=False))  # 占用保证金
    is_internal = Column(BOOLEAN, nullable=False)  # 是否是内部持仓 (即没有真正下单产生的虚拟持仓)

    __table_args__ = (
        Index('idx_position_with_tag_account_id_date', 'account_id', 'date'),
    )


class FinalOrders(Base):
    ''' final orders'''

    __tablename__ = 'final_orders'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    trading_day = Column(DATE, nullable=False)  # 日期
    label = Column(TEXT, nullable=False)  # label
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    exchange = Column(VARCHAR(32), nullable=False)  # 交易所
    asset_type = Column(Integer, nullable=False)
    target = Column(DOUBLE(asdecimal=False))  # target
    order = Column(DOUBLE(asdecimal=False))  # order
    method = Column(TEXT, nullable=False)  # algo method
    params = Column(TEXT, nullable=False)  # 所有参数
    is_internal = Column(BOOLEAN, nullable=False)  # 是否是内部 order (即不去真正下单)

    __table_args__ = (
        Index('idx_final_targets_account_trading_day', 'account', 'trading_day'),
    )


class Allocation(PureBase):
    __tablename__ = 'allocation'

    account = Column(String(32))
    strategy = Column(String(32))
    strategy_type = Column(String(32))
    amount = Column(INTEGER(11))
    method = Column(String(32))
    created_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"), comment='创建时间')
    updated_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"), comment='更新时间')
    deleted_at = Column(DateTime, comment='删除时间')
    created_by = Column(String(32))
    updated_by = Column(String(32))
    id = Column(INTEGER(11), primary_key=True)


class OrderEnsure(PureBase):
    __tablename__ = 'order_ensure'

    date = Column(Date)
    confirm = Column(String(8))
    created_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"), comment='创建时间')
    updated_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"), comment='更新时间')
    deleted_at = Column(DateTime, comment='删除时间')
    created_by = Column(String(32))
    updated_by = Column(String(32))
    id = Column(INTEGER(11), primary_key=True)


class SignalTarget(PureBase):
    __tablename__ = 'signal_target'

    trading_day = Column(Date)
    strategy = Column(String(32))
    exchange = Column(DOUBLE(asdecimal=False))
    product = Column(String(32))
    symbol = Column(String(32))
    signal = Column(DOUBLE(asdecimal=False))
    asset_type = Column(Integer, nullable=False)
    created_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"), comment='创建时间')
    updated_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"), comment='更新时间')
    deleted_at = Column(DateTime, comment='删除时间')
    created_by = Column(String(32))
    updated_by = Column(String(32))
    id = Column(INTEGER(11), primary_key=True)


class ManualTarget(PureBase):
    __tablename__ = 'manual_target'

    id = Column(Integer, primary_key=True, autoincrement=True)
    account = Column(VARCHAR(128), nullable=False)  # 交易账户 tg_name
    label = Column(TEXT, nullable=False)  # label
    symbol = Column(VARCHAR(32), nullable=False)  # 证券代码
    exchange = Column(Integer, nullable=False)  # 交易所
    asset_type = Column(Integer, nullable=False)
    target = Column(DOUBLE(asdecimal=False))  # target
    created_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"), comment='创建时间')
    updated_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"), comment='更新时间')
    deleted_at = Column(DateTime, comment='删除时间')
    created_by = Column(String(32))
    updated_by = Column(String(32))

    __table_args__ = (
        Index('idx_manual_target_account', 'account'),
    )


class FuturePriceDetail(SurfingBase):
    '''Choice期货行情'''

    __tablename__ = 'em_future_price_detail'

    CODES = Column('em_id', CHAR(20), primary_key=True)  # 东财代码
    DATES = Column('datetime', DATE, primary_key=True)  # 日期

    OPEN = Column('open', DOUBLE(asdecimal=False))  # 开盘价
    CLOSE = Column('close', DOUBLE(asdecimal=False))  # 收盘价
    HIGH = Column('high', DOUBLE(asdecimal=False))  # 最高价
    LOW = Column('low', DOUBLE(asdecimal=False))  # 最低价
    PRECLOSE = Column('pre_close', DOUBLE(asdecimal=False))  # 前收盘价
    AVERAGE = Column('average_price', DOUBLE(asdecimal=False))  # 均价
    VOLUME = Column('uni_volume', Integer)  # 成交量
    AMOUNT = Column('uni_amount', DOUBLE(asdecimal=False))  # 成交金额
    SPREAD = Column('spread', DOUBLE(asdecimal=False))  # 价差
    CLEAR = Column('clear', DOUBLE(asdecimal=False))  # 结算价
    PRECLEAR = Column('pre_clear', DOUBLE(asdecimal=False))  # 前结算价
    HQOI = Column('uni_oi', DOUBLE(asdecimal=False))  # 持仓量
    CHANGEOI = Column('uni_change_oi', DOUBLE(asdecimal=False))  # 持仓量变化


class FutureInfoDetail(SurfingBase):
    '''Choice期货信息'''

    __tablename__ = 'em_future_info_detail'

    EMCODE = Column('em_id', CHAR(20), primary_key=True)  # 东财代码
    NAME = Column('desc_name', CHAR(40))  # 期货简称
    TRADINGCODE = Column('trading_code', CHAR(20))  # 交易代码
    FTMKTSNAME = Column('mkt_name', CHAR(40))  # 交易所简称
    FTPRICELIMIT = Column('price_limit', DOUBLE(asdecimal=False))  # 涨跌幅限制
    FTTRANSMARGIN = Column('trans_margin', DOUBLE(asdecimal=False))  # 交易保证金
    FTDELIVMONTH = Column('deliv_month', Integer)  # 交割月份
    FTQUTOBPRICE = Column('quote_price', DOUBLE(asdecimal=False))  # 挂牌基准价
    FTCONTRAENGSNAME = Column('short_eng_name', CHAR(20))  # 合约英文简称
    FTCONTRAENGNAME = Column('eng_name', CHAR(40))  # 合约英文名称
    DELIVERYDATE = Column('deliver_date', DATE)  # 交割日期
    STARTTRADEDATE = Column('start_trade_date', DATE)  # 开始交易日
    LASTTRADEDATE = Column('last_trade_date', DATE)  # 最后交易日
    LONGMARGIN = Column('long_margin', Integer)  # 多头交易保证金
    SHORTMARGIN = Column('short_margin', Integer)  # 空头交易保证金
    PRICELIMITRANGE = Column('price_limit_range', DOUBLE(asdecimal=False))  # 涨跌停板幅度
    FTTRANSTYPE = Column('trans_type', CHAR(20))  # 交易品种
    FTTRANSUNIT = Column('trans_unit', CHAR(20))  # 交易单位
    CONTRACTMUL = Column('contract_mul', Integer)  # 合约乘数
    FTPRICEUNIT = Column('price_unit', CHAR(40))  # 报价单位
    FTMINPRICECHG = Column('min_price_change', CHAR(20))  # 最小变动价位
    LISTDATE = Column('list_standard_date', DATE)  # 标准合约上市日
    FTCONTRADATEINTRO = Column('contract_date_info', CHAR(40))  # 合约月份说明
    FTTRANSDATEINSTRO = Column('trans_date_info', CHAR(180))  # 交易时间说明
    FTLTRANSDATE = Column('last_trans_date', CHAR(40))  # 最后交易日说明
    FTDELIVDATEINTRO = Column('deliver_date_info', CHAR(80))  # 交割日期说明
    FTFIRSTTRANSMARGIN = Column('first_trans_margin', CHAR(40))  # 最低交易保证

    __table_args__ = (
        Index('idx_em_future_info_detail_trading_code', 'trading_code'),
    )


class FutureTypeClassification(SurfingBase):
    '''期货品种'''

    __tablename__ = 'future_type_classification'

    future_type_id = Column(CHAR(5), primary_key=True)  # 期货品种id
    desc_name = Column(CHAR(40))  # 期货品种名
    product_type = Column(CHAR(40))  # 期货品种
    upstream = Column(TEXT)  # 上游
    downstream = Column(TEXT)  # 下游
    night_mkt = Column(BOOLEAN)  # 是否有夜盘
    night_mkt_start = Column(DATETIME)  # 夜盘开始时间
    comments = Column(TEXT)  # 其他备注


class StockPrice(SurfingBase):
    '''Choice股票不复权数据表'''

    __tablename__ = 'em_stock_price'

    CODES = Column('stock_id', CHAR(10), primary_key=True) # EM股票ID
    DATES = Column('datetime', DATE, primary_key=True) # 日期
    OPEN = Column('open', DOUBLE(asdecimal=False), nullable=False) # 开盘价
    CLOSE = Column('close', DOUBLE(asdecimal=False), nullable=False) # 收盘价
    HIGH = Column('high', DOUBLE(asdecimal=False), nullable=False) # 最高价
    LOW = Column('low', DOUBLE(asdecimal=False), nullable=False) # 最低价
    PRECLOSE = Column('pre_close', DOUBLE(asdecimal=False), nullable=False) # 前收盘价
    AVERAGE = Column('average', DOUBLE(asdecimal=False), server_default=text("0")) # 均价
    AMOUNT = Column('amount', DOUBLE(asdecimal=False), server_default=text('0')) # 成交额
    VOLUME = Column('volume', DOUBLE(asdecimal=False), server_default=text('0')) # 成交量  不复权和后复权的交易量不同
    TURN = Column('turn', DOUBLE(asdecimal=False), server_default=text('0')) # 换手率
    TRADESTATUS = Column('trade_status', CHAR(20), nullable=False) # 交易状态
    TNUM = Column('t_num', DOUBLE(asdecimal=False), server_default=text('0')) # 成交笔数
    BUYVOL = Column('buy_vol', DOUBLE(asdecimal=False), server_default=text('0')) # 内盘成交量
    SELLVOL = Column('sell_vol', DOUBLE(asdecimal=False), server_default=text('0')) # 外盘成交量

    __table_args__ = (
        Index('idx_em_stock_price_datetime', 'datetime'),
    )


class TradingDayList(Base):
    '''交易日列表'''

    __tablename__ = 'trading_day_list'

    trade_date = Column(DATE, primary_key=True)
