# auto generated by update_py.py

import json
import platform

from .utils import singleton

DEFAULT_CONFIG_PATH = '/shared/etc/config.json'
CURRENT_PLATFORM = platform.system()


class DbSettings(object):

    def __init__(self, db_json):
        assert 'host' in db_json, 'could not find host in db settings'
        assert 'port' in db_json, 'could not find port in db settings'
        assert 'username' in db_json, 'could not find username in db settings'
        assert 'password' in db_json, 'could not find password in db settings'

        self.host = db_json['host']
        self.port = db_json['port']
        self.username = db_json['username']
        self.password = db_json['password']
        try:
            self.db = db_json['db']
        except KeyError:
            self.db = None

    def to_mysql_dict(self):
        return {
            'host': self.host,
            'port': self.port,
            'user': self.username,
            'password': self.password,
            'db': self.db,
        }

    def to_conn_str(self):
        return 'mysql+pymysql://{}:{}@{}:{}/{}'.format(
            self.username, self.password, self.host, self.port, self.db
        )

    def __str__(self):
        return '<Database: -h{} -P{} -u{} -p(hidden) {}>'.format(self.host, self.port, self.username, self.db)


class RedisSettings(object):

    def __init__(self, rd_json):
        assert 'host' in rd_json, 'could not find host in redis json'
        assert 'port' in rd_json, 'could not find port in redis json'
        assert 'db' in rd_json, 'could not find db in redis json'

        self.host = rd_json['host']
        self.port = rd_json['port']
        self.db = rd_json['db']


class EnvSettings(object):

    def __init__(self, config):
        assert 'env' in config, 'could not find env in config.json'
        assert 'master_rep' in config, 'could not find master_rep in config.json'

        self.env_name = config['env']
        self.master_addr = config['master_rep']


class FeiShuSettings:

    def __init__(self, config):
        for one in ['app_id', 'app_secret', 'webhook']:
            assert one in config, f'could not find {one} in config.json'
            setattr(self, one, config[one])
        for one in ['tables']:
            if one in config:
                setattr(self, one, config[one])


class MongoSettings:

    def __init__(self, config):
        for one in ['username', 'password', 'host']:
            assert one in config, f'could not find {one} in config.json'
            setattr(self, one, config[one])
        if 'db' in config:
            self.db = config['db']


class WechatSettings:

    def __init__(self, config):
        for one in ['webhook']:
            assert one in config, f'could not find {one} in config.json'
            setattr(self, one, config[one])
        for one in ['webhook_err_msg', 'webhook_detail']:
            if one in config:
                setattr(self, one, config[one])


class OMSSettings:

    def __init__(self, config):
        for one in []:
            assert one in config, f'could not find {one} in config.json'
            setattr(self, one, config[one])
        for one in [
            'env_name', 'report_time', 'switch_day_time', 'trade_start_time', 'oms_db', 'pm_db', 'raw_db', 'trade', 'secret_symbol', 'tg_ready_time', 'night_tg_mg_ready_time',
            'scout_uri',
        ]:
            if one in config:
                setattr(self, one, config[one])


class AnalyzerSettings:

    def __init__(self, config):
        for one in []:
            assert one in config, f'could not find {one} in config.json'
            setattr(self, one, config[one])
        for one in ['oms_db', 'future_info_db', 'future_class_db', 'initial_equity']:
            if one in config:
                setattr(self, one, config[one])


class CheckerSettings:

    def __init__(self, config):
        for one in []:
            assert one in config, f'could not find {one} in config.json'
            setattr(self, one, config[one])
        for one in ['fists_to_check', 'check_interval_in_seconds']:
            if one in config:
                setattr(self, one, config[one])


class Configurator(object):

    def __init__(self, config_path=None):
        self._config_path = config_path if config_path is not None else DEFAULT_CONFIG_PATH
        self._config = json.load(open(self._config_path))

    def get_db_settings(self, db_mode=None):
        assert 'database' in self._config, 'could not find database section in config'
        db_mode = db_mode or self._config['database'].get('mode', 'development')
        assert db_mode in self._config['database'], 'could not find "{}" in config section'.format(db_mode)
        db_section = self._config['database'][db_mode]
        settings = DbSettings(db_section)
        return settings

    def get_redis_settings(self):
        assert 'redis' in self._config, 'could not find redis section in config'
        settings = RedisSettings(self._config['redis'])

        return settings

    def get_env_settings(self):
        settings = EnvSettings(self._config)
        return settings

    def get_curve_server_key(self) -> str:
        return self._config.get('curve_server_key', '')

    def get_feishu_settings(self):
        assert 'feishu' in self._config, 'could not find feishu section in config'
        return FeiShuSettings(self._config['feishu'])

    def get_mongo_settings(self):
        assert 'mongodb' in self._config, 'could not find mongodb section in config'
        return MongoSettings(self._config['mongodb'])

    def get_wechat_settings(self):
        assert 'wechat' in self._config, 'could not find wechat section in config'
        return WechatSettings(self._config['wechat'])

    def get_oms_settings(self):
        assert 'oms' in self._config, 'could not find oms section in config'
        return OMSSettings(self._config['oms'])

    def get_analyzer_settings(self):
        assert 'analyzer' in self._config, 'could not find analyzer section in config'
        return AnalyzerSettings(self._config['analyzer'])

    def get_checker_settings(self):
        assert 'checker' in self._config, 'could not find checker section in config'
        return CheckerSettings(self._config['checker'])


def print_current_config():
    print(json.dumps(Configurator()._config, indent=2))


if __name__ == '__main__':
    print_current_config()
