# auto generated by update_py.py

import json
import threading
import time
import signal
from collections import defaultdict

from feishuconnector import FeishuConnector

from tlclient.linker.constant import FistType, HeartBeatStatus
from tlclient.linker.event import Event
from tlclient.linker.pb_msg import frame_pb
from tlclient.linker.timer import Timer
from tlclient.linker.structs import FistInfo
from tlclient.trader.client import Client
from tlclient.trader.config import Configurator
from tlclient.trader.utils import handle_exception
from tlclient.trader.pb_msg import message_pb


DEFAULT_CHECKER_NAME = 'checker'
DEFAULT_FISTS_TO_CHECK = {
    'MASTER': 'master',
    'TRADE_ROUTER': 'trade1',
    'MARKET_ROUTER': 'market1',
    'RECORDER': 'recorder',
}
DEFAULT_CHECK_INTERVAL_IN_SECONDS = 30


class Checker(Client):

    @handle_exception
    def _checker_t_func(self):
        seconds_to_wait = 7
        self.logger.info(f'[_checker_t_func] wait some seconds({seconds_to_wait}) to get the status from gateway')
        time.sleep(seconds_to_wait)
        self.logger.info(f'[_checker_t_func] started...')

        while not self.is_stopped():
            alarm_content = ''

            f = Event.new_pb_frame()
            f.set_msg_type(frame_pb.MsgType.MSG_TYPE_GET_FULL_STATUS)
            f.set_source(self.get_source_id())
            f.set_nano(Timer.nano())
            try:
                rsp_f = self.req_master(f)
            except TimeoutError as e:
                self.logger.warning(f'[_checker_t_func] req master failed (e){e}')
                alarm_content = '- 无法连接到 Master\r\n'
            else:
                full_infos = json.loads(rsp_f.get_string())
                fists, envs = full_infos['fists'], full_infos['envs']
                self.logger.info(f'[_checker_t_func] (fists){fists} (envs){envs}')
                fists_dict = defaultdict(dict)
                for one in fists:
                    fi_one = FistInfo(**one)
                    fists_dict[fi_one.fist_type][fi_one.fist_name] = fi_one

                self.logger.info(f'[_checker_t_func] begin to check {self._fists_to_check}')
                for ft, fists_in_ft in self._fists_to_check.items():
                    # 遍历所有需检查的 fists
                    if not fists_in_ft:
                        continue

                    self.logger.info(f'[_checker_t_func] process fist_type {FistType.read(ft)}')
                    if ft not in fists_dict:
                        alarm_content += f'- 没有正常运行的 {FistType.read(ft)}\r\n'
                        self.logger.warning(f'[_checker_t_func] FistType {FistType.read(ft)} check FAILED')
                    else:
                        fists_in_ft_dict = fists_dict[ft]
                        for one in fists_in_ft:
                            # 遍历某类型下所有的 fists
                            self.logger.info(f'[_checker_t_func] process fist {one}')
                            if one not in fists_in_ft_dict or not fists_in_ft_dict[one].is_running:
                                alarm_content += f'- {one} 运行状态异常\r\n'
                                self.logger.warning(f'[_checker_t_func] Fist {one} check FAILED')
                            else:
                                if ft in (FistType.MARKET_GATEWAY, FistType.TRADE_GATEWAY):
                                    with self._cb_lock:
                                        try:
                                            connected = self._gateway_status[ft][one]
                                            if not connected:
                                                raise RuntimeError(f'gateway {one} not connected (fist_type){ft}')
                                        except Exception as e:
                                            self.logger.warning(f'[_checker_t_func] (e){e}')
                                            alarm_content += f'- GATEWAY {one} 与前置连接异常\r\n'
                                self.logger.info(f'[_checker_t_func] fist {one} info {fists_in_ft_dict[one]}')
                            self.logger.info(f'[_checker_t_func] process fist {one} done')
                    self.logger.info(f'[_checker_t_func] process fist_type {FistType.read(ft)} done')
                self.logger.info('[_checker_t_func] check all done')

                try:
                    all_clients = fists_dict[FistType.CLIENT]
                    all_clients = set([k for k, v in all_clients.items() if v.is_running])
                except KeyError:
                    all_clients = set()
                try:
                    all_clients_to_check = set(self._fists_to_check[FistType.CLIENT])
                except KeyError:
                    all_clients_to_check = set()
                self.logger.info(f'[_checker_t_func] (all_clients){all_clients} (all_clients_to_check){all_clients_to_check}')
                auto_append = all_clients - all_clients_to_check
                if auto_append:
                    self.logger.info(f'[_checker_t_func] auto append some clients {auto_append}, they will be checked next loop')
                    self._fists_to_check[FistType.CLIENT].extend(list(auto_append))

            if alarm_content:
                self.logger.info(f'[_checker_t_func] to alarm the content (alarm_content){alarm_content}')
                self._fc.send_webhook_msg(target='checker', title='警告 状态检查异常', content=alarm_content, success=False)

            # every X seconds do a check
            time.sleep(self._check_interval_in_seconds)

        self.logger.info(f'[_checker_t_func] stopping...')

    def __init__(self, config_path=None):
        self._config = Configurator(config_path)
        super().__init__(DEFAULT_CHECKER_NAME, 'env_checker', self._config._config['master_rep'], fist_type=FistType.CHECKER)

        feishu_settings = self._config.get_feishu_settings()
        self._fc = FeishuConnector(feishu_settings.webhook)
        self._fc.init(feishu_settings.app_id, feishu_settings.app_secret)
        self.logger.info(f'[__init__] (feishu_settings){feishu_settings}')

        self._cb_lock = threading.Lock()
        self._gateway_status = defaultdict(dict)
        self._fists_to_check = defaultdict(list)
        check_settings = self._config.get_checker_settings()
        self._check_interval_in_seconds = getattr(check_settings, 'check_interval_in_seconds', DEFAULT_CHECK_INTERVAL_IN_SECONDS)
        fists_to_check = getattr(check_settings, 'fists_to_check', DEFAULT_FISTS_TO_CHECK)
        self.logger.info(f'[__init__] (raw fists_to_check){fists_to_check} (check_interval_in_seconds){self._check_interval_in_seconds}')
        for ft, fist_name in fists_to_check.items():
            ft = FistType.parse(ft)
            self._fists_to_check[ft].append(fist_name.lower())

        self.logger.info(f'[__init__] (final fists_to_check){self._fists_to_check}')
        self._checker_t = threading.Thread(target=self._checker_t_func, name='checker', daemon=False)

    def init(self):
        tr_name = None
        mr_name = None
        for one_m in self._config._config['modules']:
            if FistType.parse(one_m['fist_type']) == FistType.TRADE_ROUTER:
                if tr_name is None:
                    tr_name = one_m['fist_name']
            elif FistType.parse(one_m['fist_type']) == FistType.MARKET_ROUTER:
                if mr_name is None:
                    mr_name = one_m['fist_name']

        assert tr_name is not None and mr_name is not None, f'could not find tr_name or mr_name (tr_name){tr_name} (mr_name){mr_name}'

        try:
            self.init_trade(tr_name)
            self.init_market(mr_name)
        except Exception as e:
            self._fc.send_webhook_msg(target='checker', title='Checker', content=f'警告 连接 TR({tr_name}) or MR({mr_name}) 失败 无法完成初始化', success=False)
            raise e

    def start(self):
        super().start()

        # 启动 checker 线程
        self._checker_t.start()

        self._fc.send_webhook_msg(target='checker', title='Checker', content='正常启动, 工作中...', success=True)

    def stop(self, signum=signal.SIGTERM):
        if signum == -1:
            self._fc.send_webhook_msg(target='checker', title='Checker', content=f'警告 异常退出!!', success=False)
        else:
            self._fc.send_webhook_msg(target='checker', title='Checker', content='正常退出', success=True)

        super().stop(signum)

    def join(self):
        self._checker_t.join()
        super().join()

    # overrided
    def on_gateway_connection_change(self, obj, frame_nano):
        if not obj.connected or obj.err_id != message_pb.ErrType.ERR_TYPE_NO_ERR:
            self.logger.warning(f'[on_gateway_connection_change] got abnormal status (obj){obj}')

        with self._cb_lock:
            self._gateway_status[obj.fist_type][obj.fist_name] = obj.connected

    # overrided
    def on_gateway_heart_beat(self, obj, frame_nano):
        if obj.hb_status != HeartBeatStatus.HEALTHY:
            self.logger.warning(f'[on_gateway_heart_beat] got abnormal heartbeat (obj){obj}')

        with self._cb_lock:
            self._gateway_status[obj.fist_type][obj.fist_name] = (obj.hb_status == HeartBeatStatus.HEALTHY)


if __name__ == '__main__':
    c = Checker()
    c.init()
    c.start()
    c.join()
