# auto generated by update_py.py

from typing import Type, Optional, List
from collections import defaultdict
import os
import importlib
import datetime
import math

import numpy as np
import pandas as pd
pd.set_option('display.max_columns', None)

from feishuconnector import FeishuConnector

from tlclient.linker.logger import Logger
from tlclient.trader.config import Configurator
from tlclient.trader.constant import ExchangeID


DEFAULT_ANALYZER_NAME = 'analyzer'


class AnalyzerDataAPIBase:

    def __init__(self, logger):
        self.logger = logger

    def init(self):
        pass

    # to be overrided
    def get_trade_intra(self) -> pd.DataFrame:
        pass

    # to be overrided
    def get_order_intra(self) -> pd.DataFrame:
        pass

    # to be overrided
    def get_acc_after(self, the_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_trade_after(self) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_trades_after(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_trade_with_tags(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_internal_trade_with_tags(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_pos_before(self) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_positions_before(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_pos_after(self) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_position_with_tag(self) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_position_with_tags(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_info(self, tickers: List[str] = []) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_info_detail(self, em_id=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_price(self, tickers: List[str] = [], the_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_prices(self, tickers: List[str] = [], start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_quote(self, future_ids=None, start_date=None, end_date=None):
        pass

    # to be overrided
    def append_position_with_tag(self, df: pd.DataFrame):
        pass

    # to be overrided
    def append_trade_with_tag(self, df: pd.DataFrame):
        pass

    # to be overrided
    def append_account_stats(self, stats):
        pass

    # to be overrided
    def append_account_data(self, data):
        pass

    # to be overrided
    def append_account_pnls(self, pnls):
        pass

    # to be overrided
    def get_trading_day_list(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_last_trade_date(self) -> datetime.date:
        pass

    # to be overrided
    def get_today_date(self) -> datetime.date:
        pass

    # to be overrided
    def notify_simple_msg(self, msg: str, title: str):
        pass

    # to be overrided
    def init_db(self):
        pass


class Analyzer:

    def __init__(self, data_impl_pkg, account_name: str = None, fist_name=None):
        assert data_impl_pkg is not None, f"datas' class pkg must be a valid package name (data_impl_pkg){data_impl_pkg}"
        try:
            self._data_impl_mod = importlib.import_module(f'data_impls.{data_impl_pkg}')
        except ModuleNotFoundError as e:
            print(f"can not import the data's class file (file_path){data_impl_pkg} (e){e}")
            raise e

        # load config
        analyzer_configs = {}
        for one in ('ANALYZER_CONFIG_PATH', ):
            try:
                analyzer_configs[one] = os.environ[one]
            except KeyError:
                analyzer_configs[one] = None
        self._configure = Configurator(analyzer_configs['ANALYZER_CONFIG_PATH'])

        feishu_settings = self._configure.get_feishu_settings()
        self._fc = FeishuConnector(feishu_settings.webhook)
        self._fc.init(feishu_settings.app_id, feishu_settings.app_secret)

        self._analyzer_settings = self._configure.get_analyzer_settings()
        self._initial_equity = getattr(self._analyzer_settings, 'initial_equity', None)
        if self._initial_equity is None:
            self._initial_equity = 0

        self._account = account_name
        if fist_name is None:
            fist_name = DEFAULT_ANALYZER_NAME
        self.logger = Logger.get_logger(fist_name)
        self.logger.info(f'[__init__] (analyzer_configs){analyzer_configs} (feishu_settings){feishu_settings} (data_impl_pkg){data_impl_pkg} (account_name){account_name} (fist_name){fist_name} (initial_equity){self._initial_equity}')

        self._datas_api: Type[AnalyzerDataAPIBase] = getattr(self._data_impl_mod, 'AnalyzerDataAPI')(self._configure, {
                'datas_intra': 'datas_from_recorder',
                'market_values': 'market_values',
                'equity_and_navs': 'equity_and_navs',
            },
            self.logger)

    def init(self):
        self._datas_api.init()

    def calc_recorded_traded_with_tag(self) -> Optional[pd.DataFrame]:
        trade_intra = self._datas_api.get_trade_intra()
        if self._account is not None:
            trade_intra = trade_intra.loc[trade_intra.account_id == self._account, :]
        self.logger.info(f'[calc_recorded_traded_with_tag] (trade_intra):\r\n{trade_intra}')
        order_intra = self._datas_api.get_order_intra()
        if self._account is not None:
            order_intra = order_intra.loc[order_intra.account_id == self._account, :]
        self.logger.info(f'[calc_recorded_traded_with_tag] (order_intra):\r\n{order_intra}')

        if trade_intra.empty:
            return
        recorded_traded_with_tag = trade_intra.join(order_intra.set_index('order_id')[['sub_account']], on='order_id', how='left')
        return recorded_traded_with_tag

    def calc_trade_with_tag(self) -> Optional[pd.DataFrame]:
        trade_after = self._datas_api.get_trade_after()
        if self._account is not None:
            trade_after = trade_after.loc[trade_after.account_id == self._account, :]
        self.logger.info(f'[calc_trade_with_tag] (trade_after):\r\n{trade_after}')

        recorded_traded_with_tag = self.calc_recorded_traded_with_tag()
        if recorded_traded_with_tag is not None:
            recorded_traded_with_tag = recorded_traded_with_tag.rename(columns={
                'orderRef': 'order_ref',
                'tradeRef': 'trade_ref',
            })
            self.logger.info(f'[calc_trade_with_tag] (recorded_traded_with_tag):\r\n{recorded_traded_with_tag}')

            recorded_traded_with_tag = trade_after.join(recorded_traded_with_tag.set_index(['order_ref', 'trade_ref'])[['sub_account']], on=['order_ref', 'trade_ref'], how='left')
            recorded_traded_with_tag['is_internal'] = False

            # internal_trade_with_tag = self._datas_api.get_internal_trade_with_tags()
            # if not internal_trade_with_tag.empty:
            #     internal_trade_with_tag['is_internal'] = True
            #     recorded_traded_with_tag = pd.concat([recorded_traded_with_tag, internal_trade_with_tag])
            recorded_traded_with_tag['by_human'] = False
            return recorded_traded_with_tag
        else:
            assert trade_after.empty, f'got None recorded_traded_with_tag, but trade_after is not empty (trade_after):\r\n{trade_after}'

    def to_confirm_trade_with_tag(self) -> Optional[pd.DataFrame]:
        trade_with_tag = self.calc_trade_with_tag()
        # FIXME: to confirme it
        confirmed_trade_with_tag = trade_with_tag
        if confirmed_trade_with_tag is not None:
            confirmed_trade_with_tag = confirmed_trade_with_tag.rename(columns={'sub_account': 'label'})
            self._datas_api.append_trade_with_tag(confirmed_trade_with_tag)
        return confirmed_trade_with_tag

    @staticmethod
    def _groupby_func(x):
        return pd.Series({
            'date': x.date.array[-1],
            'position': x.position.sum(),
            'yd_pos': x.position.sum(),
            'avail_pos': x.avail_pos.sum(),
            # 'pos_cost': (x.position * x.pos_cost).sum() / x.position.sum(),
        })

    @staticmethod
    def _groupby_func2(x):
        if ExchangeID.parse(x.exchange.array[0]) == ExchangeID.SHFE:
            x_with_yd_pos = x.loc[x.yd_pos != 0, :]
            x_without_yd_pos = x.loc[x.yd_pos == 0, :]
        else:
            x_with_yd_pos = x
            x_without_yd_pos = None
        result = []
        for one in [x_with_yd_pos, x_without_yd_pos]:
            if one is None:
                continue
            if one.empty:
                continue
            result.append({
                'date': one.date.array[-1],
                'label': one.label.array[-1],
                'position': one.position.sum(),
                'yd_pos': one.yd_pos.sum(),
                'avail_pos': one.avail_pos.sum(),
                # 'pos_cost': (one.position * one.pos_cost).sum() / one.position.sum(),
                'margin': one.margin.sum(min_count=1)
            })
        return pd.DataFrame(result)

    def calc_position_with_tag(self, pos_after):
        pos_before = self._datas_api.get_pos_before()
        if self._account is not None:
            pos_before = pos_before.loc[pos_before.account_id == self._account, :]
        self.logger.info(f'[calc_position_with_tag] (pos_before):\r\n{pos_before}')

        position_with_tag = self._datas_api.get_position_with_tag().drop(columns='pos_cost')
        if self._account is not None:
            position_with_tag = position_with_tag.loc[position_with_tag.account_id == self._account, :]
        self.logger.info(f'[calc_position_with_tag] (position_with_tag):\r\n{position_with_tag}')
        position_with_tag = position_with_tag[position_with_tag.position.notna() & (position_with_tag.position != 0)]
        self.logger.info(f'[calc_position_with_tag] (position_with_tag filtered):\r\n{position_with_tag}')

        if not position_with_tag.empty:
            # check whether pos_before and position_with_tag match
            position_with_tag = position_with_tag.groupby(by=['account_id', 'exchange', 'symbol', 'direction', 'label']).apply(Analyzer._groupby_func).reset_index()
            to_be_checked_pos = position_with_tag.groupby(by=['account_id', 'exchange', 'symbol', 'direction']).apply(Analyzer._groupby_func).reset_index().drop(columns='date')
            self.logger.info(f'[calc_position_with_tag] (to_be_checked_pos):\r\n{to_be_checked_pos}')
            pd.testing.assert_frame_equal(pos_before[to_be_checked_pos.columns].sort_values(by=['account_id', 'exchange', 'symbol', 'direction']).reset_index(drop=True).replace({np.nan: 0}), to_be_checked_pos, check_dtype=False)

            position_with_tag.loc[:, 'yd_pos'] = position_with_tag.position
            position_with_tag.loc[:, 'update_flag'] = False
        else:
            assert pos_before.empty, f'invalid position_with_tag {position_with_tag} (pos_before){pos_before}'

        today_date = self._datas_api.get_today_date()
        internal_trade_with_tags = self._datas_api.get_trade_with_tags(today_date, today_date)
        if self._account is not None:
            internal_trade_with_tags = internal_trade_with_tags.loc[internal_trade_with_tags.account_id == self._account, :]
        internal_trade_with_tags = internal_trade_with_tags[internal_trade_with_tags.is_internal == True]

        confirmed_trade_with_tag = self.to_confirm_trade_with_tag()
        self.logger.info(f'[calc_position_with_tag] (confirmed_trade_with_tag):\r\n{confirmed_trade_with_tag}')

        confirmed_trade_with_tag = pd.concat([confirmed_trade_with_tag, internal_trade_with_tags])
        self.logger.info(f'[calc_position_with_tag] (confirmed_trade_with_tag with is_internal):\r\n{confirmed_trade_with_tag}')

        if not confirmed_trade_with_tag.empty:
            position_with_tag.loc[:, 'date'] = confirmed_trade_with_tag.date.array[-1]
            # position_with_tag.loc[:, 'margin']
            for one in confirmed_trade_with_tag.itertuples(index=False):
                if one.offset_flag == 'OPEN':
                    if one.side == 'BUY':
                        direction = 'LONG'
                    elif one.side == 'SELL':
                        direction = 'SHORT'
                    else:
                        assert False, f'[calc_position_with_tag] invalid side {one.side} (one){one}'

                    the_pos = pos_after.loc[(pos_after.account_id == one.account_id) & (pos_after.symbol == one.symbol) & (pos_after.exchange == one.exchange) & (pos_after.direction == direction), ['margin', 'position']]
                    the_filter = (position_with_tag.account_id == one.account_id) & (position_with_tag.symbol == one.symbol) & (position_with_tag.exchange == one.exchange) & (position_with_tag.direction == direction) & (position_with_tag.yd_pos == 0)
                    if the_filter.any():
                        position_with_tag.loc[the_filter, 'position'] = position_with_tag.loc[the_filter, 'position'] + one.traded_vol
                        position_with_tag.loc[the_filter, 'avail_pos'] = position_with_tag.loc[the_filter, 'avail_pos'] + one.traded_vol

                        position_with_tag.loc[the_filter, 'margin'] = (the_pos.margin / the_pos.position.replace({0: np.nan})).array[0] * position_with_tag.loc[the_filter, 'position']
                        position_with_tag.loc[the_filter, 'update_flag'] = True
                    else:
                        position_with_tag = position_with_tag.append(pd.Series({
                            'account_id': one.account_id,
                            'date': one.date,
                            'symbol': one.symbol,
                            'exchange': one.exchange,
                            'direction': direction,
                            'position': one.traded_vol,
                            'yd_pos': 0,
                            'avail_pos': one.traded_vol,
                            # 'pos_cost': one.traded_price,
                            'label': one.label,
                            'margin': (the_pos.margin / the_pos.position).array[0] * one.traded_vol,
                            'is_internal': False,
                            'update_flag': True,
                        }), ignore_index=True)
                elif one.offset_flag in ('CLOSE', 'CLOSE_TODAY', 'CLOSE_YESTERDAY'):
                    if one.side == 'BUY':
                        direction = 'SHORT'
                    elif one.side == 'SELL':
                        direction = 'LONG'
                    else:
                        assert False, f'[calc_position_with_tag] invalid side {one.side} (one){one}'

                    try:
                        the_pos = pos_after.loc[(pos_after.account_id == one.account_id) & (pos_after.symbol == one.symbol) & (pos_after.exchange == one.exchange) & (pos_after.direction == direction), ['margin', 'position']]
                        the_filter = (position_with_tag.account_id == one.account_id) & (position_with_tag.symbol == one.symbol) & (position_with_tag.exchange == one.exchange) & (position_with_tag.direction == direction) & (position_with_tag.label == one.label)
                        assert position_with_tag.loc[the_filter, 'position'].ge(one.traded_vol).all(), f'not enought pos to close (one){one} (pos)\r\n{position_with_tag.loc[the_filter, "position"]}'
                        position_with_tag.loc[the_filter, 'position'] = position_with_tag.loc[the_filter, 'position'] - one.traded_vol

                        assert position_with_tag.loc[the_filter, 'avail_pos'].ge(one.traded_vol).all(), f'not enought avail_pos to close (one){one} (pos)\r\n{position_with_tag.loc[the_filter, "avail_pos"]}'
                        position_with_tag.loc[the_filter, 'avail_pos'] = position_with_tag.loc[the_filter, 'avail_pos'] - one.traded_vol

                        if (one.offset_flag == 'CLOSE_YESTERDAY') or position_with_tag.loc[the_filter, 'yd_pos'].any():
                            assert position_with_tag.loc[the_filter, 'yd_pos'].ge(one.traded_vol).all(), f'not enought yd_pos to close (one){one} (pos)\r\n{position_with_tag.loc[the_filter, "yd_pos"]}'
                            if not one.is_internal:
                                # 如果是内部交易 这里不去减掉 yd_pos 制造一个假持仓 再在后边过滤掉
                                position_with_tag.loc[the_filter, 'yd_pos'] = position_with_tag.loc[the_filter, 'yd_pos'] - one.traded_vol

                        position_with_tag.loc[the_filter, 'margin'] = (the_pos.margin / the_pos.position.replace({0: np.nan})).array[0] * position_with_tag.loc[the_filter, 'position']
                        position_with_tag.loc[the_filter, 'update_flag'] = True
                    except KeyError:
                        assert False, f'no this pos to close (one){one} (position_with_tag)\r\n{position_with_tag}'
                else:
                    assert False, f'[calc_position_with_tag] unknown offset_flag {one.offset_flag} (one){one}'
        else:
            position_with_tag.loc[:, 'date'] = pos_after.date.array[-1]
        position_with_tag_without_flag = position_with_tag.loc[position_with_tag.update_flag == False, :].copy()
        for one in position_with_tag_without_flag.itertuples():
            the_pos = pos_after.loc[(pos_after.account_id == one.account_id) & (pos_after.symbol == one.symbol) & (pos_after.exchange == one.exchange) & (pos_after.direction == one.direction) & ((pos_after.yd_pos.notna()) & (pos_after.yd_pos != 0)), ['margin', 'position']]
            if not the_pos.empty:
                position_with_tag.loc[one.Index, 'margin'] = (the_pos.margin / the_pos.position.replace({0: np.nan})).array[0] * one.position
        return position_with_tag.drop(columns='update_flag')

    @staticmethod
    def _groupby_func_for_pos_tag_sum(x) -> pd.DataFrame:
        x_with_yd_pos = x.loc[x.yd_pos != 0, :]
        x_without_yd_pos = x.loc[x.yd_pos == 0, :]
        result = []
        for one in [x_with_yd_pos, x_without_yd_pos]:
            if one.empty:
                continue
            data = one.iloc[-1, :]
            for one_c in ['position', 'yd_pos', 'avail_pos', 'margin']:
                data[one_c] = one[one_c].sum()
            result.append(data.drop(['account_id', 'exchange', 'symbol', 'direction']))
        return pd.DataFrame(result)

    def to_confirm_position_with_tag(self):
        pos_after = self._datas_api.get_pos_after()
        if self._account is not None:
            pos_after = pos_after.loc[pos_after.account_id == self._account, :]
        self.logger.info(f'[to_confirm_position_with_tag] (pos_after):\r\n{pos_after}')

        position_with_tag = self.calc_position_with_tag(pos_after)
        self.logger.info(f'[to_confirm_position_with_tag] (position_with_tag):\r\n{position_with_tag}')

        groupby_key = ['account_id', 'exchange', 'symbol', 'direction']
        to_be_confirmed_pos = position_with_tag.groupby(by=groupby_key).apply(Analyzer._groupby_func2).droplevel(len(groupby_key)).reset_index()
        self.logger.info(f'[to_confirm_position_with_tag] (to_be_confirmed_pos):\r\n{to_be_confirmed_pos}')
        pd.testing.assert_frame_equal(pos_after[to_be_confirmed_pos.columns.intersection(pos_after.columns)].sort_values(by=['account_id', 'exchange', 'symbol', 'direction', 'yd_pos']).reset_index(drop=True).replace({np.nan: 0}), to_be_confirmed_pos.groupby(by=groupby_key, sort=False).apply(Analyzer._groupby_func_for_pos_tag_sum).droplevel(len(groupby_key)).reset_index()[to_be_confirmed_pos.columns.intersection(pos_after.columns)], check_dtype=False)
        # 这种持仓是为了对于 netoff 的合约 能通过上边的断言检查增加的假持仓 需要在这里处理
        spec_filter = (to_be_confirmed_pos.position < to_be_confirmed_pos.yd_pos)
        to_be_confirmed_pos.loc[spec_filter, 'yd_pos'] = to_be_confirmed_pos.loc[spec_filter, 'position']
        to_be_confirmed_pos['is_internal'] = False
        # FIXME: need a real confirmation
        confirmed_position_with_tag = to_be_confirmed_pos
        self._datas_api.append_position_with_tag(confirmed_position_with_tag)
        return confirmed_position_with_tag

    def calc_nav(self, is_history=False):
        last_accounts_equity = {}
        accounts_data = defaultdict(dict)
        start_date = datetime.date(2022, 3, 9)
        trading_dates = list(self._datas_api.get_trading_day_list(start_date, self._datas_api.get_today_date()).trade_date.array)
        future_prices = self._datas_api.get_future_prices(start_date=trading_dates[0], end_date=trading_dates[-1])
        position_with_tags = self._datas_api.get_position_with_tags(start_date=trading_dates[0], end_date=trading_dates[-1])
        trades_with_tag = self._datas_api.get_trade_with_tags(start_date=trading_dates[0], end_date=trading_dates[-1])
        positions_before = self._datas_api.get_positions_before(start_date=trading_dates[0], end_date=trading_dates[-1])

        trades_record = defaultdict(list)
        for one_date in trading_dates:
            future_price = future_prices.loc[future_prices.datetime == one_date, :]

            position_with_tag = position_with_tags.loc[position_with_tags.date == one_date, :]
            trade_with_tag = trades_with_tag.loc[trades_with_tag.date == one_date, :]
            pos_before = positions_before.loc[positions_before.date == one_date, :]

            acc_after = self._datas_api.get_acc_after(one_date)
            if self._account is not None:
                acc_after = acc_after.loc[acc_after.account_id == self._account, :]
            for one in acc_after.itertuples(index=False):
                self.logger.info(f'[calc_nav] to process account {one.account_id}')
                account_pos_with_tag = position_with_tag.loc[position_with_tag.account_id == one.account_id, :]
                self.logger.info(f'[calc_nav] (account_pos_with_tag):\r\n{account_pos_with_tag}')
                account_trade_with_tag = trade_with_tag.loc[trade_with_tag.account_id == one.account_id, :].sort_values(by='order_id')
                self.logger.info(f'[calc_nav] (account_trade_with_tag):\r\n{account_trade_with_tag}')
                account_pos_before = pos_before.loc[pos_before.account_id == one.account_id]
                self.logger.info(f'[calc_nav] (account_pos_before):\r\n{account_pos_before}')

                future_info = self._datas_api.get_future_info(set(account_pos_with_tag.symbol.array))
                self.logger.info(f'[calc_nav] (future_info):\r\n{future_info}')
                full_data = account_pos_with_tag.join(future_info.set_index('trading_code')[['em_id', 'contract_mul']], on='symbol')

                self.logger.info(f'[calc_nav] (future_price):\r\n{future_price}')
                full_data = full_data.join(future_price.set_index('em_id')[['clear', 'pre_clear']], on='em_id')
                self.logger.info(f'[calc_nav] (full_data):\r\n{full_data}')

                realized_pnl = 0
                realized_pnl_with_tag = defaultdict(float)
                for _, one_trade in account_trade_with_tag.iterrows():
                    if one_trade.side == 'BUY':
                        direction = 'SHORT'
                        r_side = 'SELL'
                        mul = -1
                    elif one_trade.side == 'SELL':
                        direction = 'LONG'
                        r_side = 'BUY'
                        mul = 1
                    else:
                        assert False, f'invalid trade record {one_trade}'

                    if one_trade.offset_flag in ['CLOSE', 'CLOSE_YESTERDAY']:
                        the_pos = account_pos_before.loc[(account_pos_before.exchange == one_trade.exchange) & (account_pos_before.symbol == one_trade.symbol) & (account_pos_before.direction == direction)]
                        assert the_pos.shape[0] == 1, f'invalid pos before (one_date){one_date} (account_pos_before):\r\n{account_pos_before}'
                        # realized_pnl += (one_trade.traded_price * one_trade.traded_vol * future_info.loc[future_info.trading_code == one_trade.symbol, 'contract_mul'].array[0] - (the_pos.pos_cost.array[0] / the_pos.position.array[0]) * one_trade.traded_vol) * mul
                        for index, one_tr in enumerate(trades_record[one.account_id]):
                            if (one_tr.exchange == one_trade.exchange) and (one_tr.symbol == one_trade.symbol) and (one_tr.side == r_side) and (one_tr.traded_vol > 0):
                                val = (one_trade.traded_price - one_tr.traded_price) * one_trade.traded_vol * future_info.loc[future_info.trading_code == one_trade.symbol, 'contract_mul'].array[0] * mul
                                realized_pnl += val
                                realized_pnl_with_tag[one_trade.label] += val
                                break
                        else:
                            assert False, f'invalid trade record {one_trade} (trades_record){trades_record}'
                        trades_record[one.account_id][index].traded_vol -= 1
                        if math.isclose(trades_record[one.account_id][index].traded_vol, 0):
                            del trades_record[one.account_id][index]

                    elif one_trade.offset_flag == 'OPEN':
                        full_data.loc[(full_data.exchange == one_trade.exchange) & (full_data.symbol == one_trade.symbol) & (full_data.direction == direction), 'pre_clear'] = one_trade.traded_price

                        trades_record[one.account_id].append(one_trade)
                full_data['multi'] = full_data.direction.map(lambda x: -1 if x == 'SHORT' else 1)
                unrealized_pnl = (full_data.position * full_data.contract_mul * (full_data.clear - full_data.pre_clear) * full_data.multi).sum()
                unrealized_pnl_with_tag_df = full_data.groupby(by='label', sort=False).apply(lambda x: (x.position * x.contract_mul * (x.clear - x.pre_clear) * x.multi).sum()).to_frame('unrealized_pnl')
                self.logger.info(f'[calc_nav] (unrealized_pnl_with_tag_df){unrealized_pnl_with_tag_df}')
                pnl_with_tag_df = unrealized_pnl_with_tag_df.join(pd.Series(realized_pnl_with_tag).to_frame('realized_pnl'), how='outer').rename_axis(index='label').reset_index()
                self.logger.info(f'[calc_nav] (pnl_with_tag_df){pnl_with_tag_df}')
                pnls = [{'account_id': one.account_id, 'date': one_date.isoformat(), 'label': '-', 'pnl': one.pnl, 'realized_pnl': one.realized_pnl, 'unrealized_pnl': one.unrealized_pnl}]
                if not pnl_with_tag_df.empty:
                    pnl_with_tag_df['date'] = one_date.isoformat()
                    pnl_with_tag_df['account_id'] = one.account_id
                    pnl_with_tag_df['pnl'] = pnl_with_tag_df.realized_pnl.add(pnl_with_tag_df.unrealized_pnl, fill_value=0)
                    pnls.extend(pnl_with_tag_df.to_dict(orient='records'))
                # method 1
                # TODO: add withdraw_all and interest
                equity = (last_accounts_equity[one.account_id] if one.account_id in last_accounts_equity else self._initial_equity) + realized_pnl + unrealized_pnl  # - one.commission
                # equity = one.avail_amt + one.frz_margin
                last_accounts_equity[one.account_id] = equity
                whole_data = {'account_id': one.account_id, 'date': one_date.isoformat(), 'equity': equity, 'avail_amt': one.avail_amt, 'margin': one.frz_margin, 'commission': one.commission}
                if is_history or (one_date == trading_dates[-1]):
                    accounts_data[one_date][one.account_id] = {'account': whole_data, 'pnls': pnls}
        self.logger.info(f'[calc_nav] (accounts_data){accounts_data}')
        return accounts_data

    def append_nav_to_db(self, accounts_data):
        for _, accounts in accounts_data.items():
            for _, datas in accounts.items():
                self._datas_api.append_account_data([datas['account']])
                try:
                    self._datas_api.append_account_pnls(datas['pnls'])
                except KeyError:
                    pass

    @staticmethod
    def cal_period_perf_indicator(adjnav):
        """
        计算区间业绩指标 年化收益 年化波动率 夏普 最大回撤 卡玛 平均回撤恢复时长（天） by hkj & lhy
        """
        if type(adjnav) == pd.DataFrame:
            res = pd.DataFrame(index=adjnav.columns, columns=['AnnRet', 'AnnVol', 'SR', 'MaxDD', 'Calmar', 'AvgDDD'])
            for col in adjnav:
                res.loc[col] = Analyzer.cal_period_perf_indicator(adjnav[col])
            return res

        adjnav = adjnav.set_axis(pd.to_datetime(adjnav.index, infer_datetime_format=True).date)
        date_ordinal = pd.Series([datetime.date.toordinal(e) for e in adjnav.index])
        time_diff = date_ordinal - date_ordinal.shift(1)  # 相对上一次净值的日期间隔

        p = adjnav  # 单个资产价格或净值序列, pd.Series
        r = p.pct_change()  # 涨幅
        p_ = p.dropna()
        annret = (p_[-1] / p_[0]) ** (365/(p_.index[-1]-p_.index[0]).days) - 1  # 复利年化收益
        # r1 = r.values / time_diff  # 日均收益
        # annret1 = np.nanmean(r1) * 365  # 单利年化收益
        r2 = r.values / np.sqrt(time_diff)  # 波动率调整后涨幅
        annvol = np.nanstd(r2) * np.sqrt(365)  # 年化波动率
        sr = (annret) / annvol  # 夏普比率
        dd = p/p.cummax() - 1  # 回撤Series
        mdd = np.min(dd)  # 最大回撤
        peak = p_.cummax()
        peak_date = peak[peak != peak.shift().fillna(1)].index
        avg_dd_duration = np.mean([(peak_date[i] - peak_date[i-1]).days for i in range(1, len(peak_date))])
        calmar = annret / -mdd
        return {
            'start_date': adjnav.index.array[0],
            'end_date': adjnav.index.array[-1],
            'annret': annret,
            'annvol': annvol,
            'sr': sr,
            'mdd': mdd,
            'calmar': calmar,
            'avg_dd_duration': avg_dd_duration
        }

    def calc_stat(self, result):
        account_datas_dict = defaultdict(list)
        for _, account_datas in result.items():
            for account_id, datas in account_datas.items():
                account_datas_dict[account_id].append({'date': datas['account']['date'], 'equity': datas['account']['equity']})

        results = []
        for account_id, nav in account_datas_dict.items():
            nav = pd.DataFrame(nav).set_index('date')['equity']
            result = Analyzer.cal_period_perf_indicator(nav)
            mongo_result = {}
            for k, v in result.items():
                if isinstance(v, datetime.date):
                    mongo_result[k] = v.isoformat()
                else:
                    mongo_result[k] = v
            mongo_result.update({'account_id': account_id})
            self.logger.info(f'(account_id){account_id} (mongo_result){mongo_result}')
            results.append(mongo_result)
        self._datas_api.append_account_stats(results)

    def future_daily_report(self):
        trades = self._datas_api.get_trade_with_tags()
        if self._account is not None:
            trades = trades.loc[trades.account_id == self._account, :]
        self.logger.info(f'[future_daily_report] (trades):\r\n{trades}')
        position = self._datas_api.get_position_with_tags()
        if self._account is not None:
            position = position.loc[position.account_id == self._account, :]
        self.logger.info(f'[future_daily_report] (position):\r\n{position}')

        fdr = getattr(self._data_impl_mod, 'fut_daily_report')(
            self._datas_api,
            trades=trades,
            positions=position,
        )
        self.logger.info('[future_daily_report] begin to calc')
        fdr.calc()

        report_date = self._datas_api.get_today_date()
        self.logger.info(f'[future_daily_report] calc done (report_date){report_date}')
        # 交易 & 持仓
        trades_result, pos_result = fdr.vis_tnp(report_date)
        self.logger.info(f'[_push_targets_to_feishu] to feishu (trades_result):\r\n{trades_result}')

        # scout_uri = getattr(self._analyzer_settings, 'scout_uri', '')
        # to Feishu
        # self._fc.send_webhook_msg(
        #     target='trade', title=f'future report(trades) {report_date}', content=trades_result.to_markdown(index=False, tablefmt="grid"), success=True,
        #     # buttons=[
        #     #     ('详情', scout_uri),
        #     # ]
        # )
        self.logger.info(f'[_push_targets_to_feishu] to feishu (pos_result):\r\n{pos_result}')
        # to Feishu
        # self._fc.send_webhook_msg(
        #     target='trade', title=f'future report(position) {report_date}', content=pos_result.to_markdown(index=False, tablefmt="grid"), success=True,
        #     # buttons=[
        #     #     ('详情', scout_uri),
        #     # ]
        # )
        self._fc.send_dataframe(trades_result, '交易', target='trade')
        self._fc.send_dataframe(pos_result, '持仓', target='trade')

        # PNL 曲线
        vis_pnl = fdr.vis_pnl()
        self._fc.send_image(vis_pnl, title='PNL', target='trade')

    def _groupby_func_for_restore_trade_time(self, x, trades_real):
        results = []
        trades_real_one_date = trades_real[pd.to_datetime(x.date.array[0])]['positions']
        if not trades_real_one_date:
            return
        df = pd.DataFrame(trades_real_one_date).set_index('trade_ref')
        for row in x.itertuples(index=False):
            results.append({'trade_ref': row.trade_ref, 'seconds': df.at[row.trade_ref, 'trade_time']['seconds']})
        return pd.DataFrame(results)

    # util func
    def _restore_trade_time(self):
        trades_real = self._datas_api._mongo_connector.get_items('trades_real')
        trade_with_tags = self._datas_api.get_trades_after()
        the_trade_time_data = trade_with_tags.groupby(by='date', sort=False).apply(self._groupby_func_for_restore_trade_time, trades_real=trades_real)
        the_trade_time_data = the_trade_time_data.set_axis(the_trade_time_data.index.droplevel(1))
        print(the_trade_time_data)

        from trader.database.oms_models import TradeWithTag, TradeAfter
        with self._datas_api._db_connector.get_session() as db_session:
            for row in db_session.query(TradeAfter).all():
                try:
                    row.trade_time = the_trade_time_data.loc[row.date, :].set_index('trade_ref').at[row.trade_ref, 'seconds']
                except KeyError:
                    print('!!!!')
            db_session.commit()

    # util func
    def _replace_mongo_datas_name(self):
        datas_from_recorder = self._datas_api._mongo_connector.get_by_filter('datas_from_recorder', {})
        for v in datas_from_recorder:
            if v['frame_msg_type'] == 200:
                continue
                for one in [
                    ('accountId', 'account_id'),
                    ('orderId', 'order_id'),
                    ('parentId', 'parent_id'),
                    ('offsetFlag', 'offset_flag'),
                    ('orderType', 'order_type'),
                    ('entrustVol', 'entrust_vol'),
                    ('entrustPrice', 'entrust_price'),
                    ('subAccount', 'sub_account'),
                ]:
                    if one[0] in v:
                        v[one[1]] = v[one[0]]
                        del v[one[0]]
            elif v['frame_msg_type'] == 210:
                continue
                for one in [
                    ('accountId', 'account_id'),
                    ('reqId', 'req_id'),
                    ('orderId', 'order_id'),
                ]:
                    if one[0] in v:
                        v[one[1]] = v[one[0]]
                        del v[one[0]]
            elif v['frame_msg_type'] == 400:
                continue
                for one in [
                    ('accountId', 'account_id'),
                    ('orderId', 'order_id'),
                    ('orderRef', 'order_ref'),
                    ('frontId', 'front_id'),
                    ('sessionId', 'session_id'),
                    ('offsetFlag', 'offset_flag'),
                    ('orderStatus', 'order_status'),
                    ('orderType', 'order_type'),
                    ('securityType', 'security_type'),
                    ('tradedVol', 'traded_vol'),
                    ('createTime', 'create_time'),
                    ('entrustVol', 'entrust_vol'),
                    ('entrustPrice', 'entrust_price'),
                ]:
                    if one[0] in v:
                        v[one[1]] = v[one[0]]
                        del v[one[0]]
            elif v['frame_msg_type'] == 410:
                continue
                for one in [
                    ('accountId', 'account_id'),
                    ('tradeRef', 'trade_ref'),
                    ('orderId', 'order_id'),
                    ('orderRef', 'order_ref'),
                    ('offsetFlag', 'offset_flag'),
                    ('orderType', 'order_type'),
                    ('securityType', 'security_type'),
                    ('tradedVol', 'traded_vol'),
                    ('tradedPrice', 'traded_price'),
                    ('tradingDay', 'trading_day'),
                    ('tradeTime', 'trade_time'),
                    ('entrustVol', 'entrust_vol'),
                    ('entrustPrice', 'entrust_price'),
                ]:
                    if one[0] in v:
                        v[one[1]] = v[one[0]]
                        del v[one[0]]
            elif v['frame_msg_type'] == 330:
                continue
                for one in [
                    ('posId', 'pos_id'),
                    ('accountId', 'account_id'),
                ]:
                    if one[0] in v:
                        v[one[1]] = v[one[0]]
                        del v[one[0]]
                if 'positions' in v:
                    positions = v['positions']
                    for one in positions:
                        for one_tag in [
                            ('securityType', 'security_type'),
                            ('ydPos', 'yd_pos'),
                            ('availPos', 'avail_pos'),
                            ('posCost', 'pos_cost'),
                            ('realizedPnl', 'realized_pnl'),
                            ('unrealizedPnl', 'unrealized_pnl'),
                        ]:
                            if one_tag[0] in one:
                                one[one_tag[1]] = one[one_tag[0]]
                                del one[one_tag[0]]
                    v['positions'] = positions
            elif v['frame_msg_type'] == 340:
                for one in [
                    ('reqId', 'req_id'),
                    ('accountId', 'account_id'),
                    ('availAmt', 'avail_amt'),
                    ('realizedPnl', 'realized_pnl'),
                    ('unrealizedPnl', 'unrealized_pnl'),
                    ('frzMargin', 'frz_margin'),
                ]:
                    if one[0] in v:
                        v[one[1]] = v[one[0]]
                        del v[one[0]]
            else:
                continue
            _id = v['_id']
            del v['_id']
            for one in v.keys():
                if not one.islower():
                    assert False, f'(one){one} (v){v}'
            if 'positions' in v:
                for one in v['positions']:
                    for one_tag in one.keys():
                        if not one_tag.islower():
                            assert False, f'(one_tag){one_tag} (one){one} (v){v}'
            print(v)
            self._datas_api._mongo_connector.put('datas_from_recorder_new', _id, v)


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser(description='Analyzer')
    parser.add_argument('data_impl_pkg',
                        help='data manipulation pkg of analyzer')
    parser.add_argument('-a', '--account', help='specify an account to analyze')
    args = parser.parse_args()

    ana = Analyzer(args.data_impl_pkg, args.account)
    ana.init()

    result = ana.to_confirm_position_with_tag()
    print(result)
    result = ana.calc_nav()
    print(result)
    ana.append_nav_to_db(result)
    ana.calc_stat(ana.calc_nav(is_history=True))
    ana.future_daily_report()

    import time
    time.sleep(2)

    # ana._datas_api.init_db()
    # ana._datas_api.sync_data()
    # ana._restore_trade_time()
    # ana._replace_mongo_datas_name()
