import * as cdk from '@aws-cdk/core';
import { CfnVirtualGateway } from './appmesh.generated';
import { HealthCheck } from './shared-interfaces';
import { TlsCertificate } from './tls-certificate';
/**
 * (experimental) Represents the properties needed to define HTTP Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface HttpGatewayListenerOptions {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) Represents the configuration for enabling TLS on a listener.
     *
     * @default - none
     * @experimental
     */
    readonly tlsCertificate?: TlsCertificate;
}
/**
 * (experimental) Represents the properties needed to define GRPC Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface GrpcGatewayListenerOptions {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) Represents the listener certificate.
     *
     * @default - none
     * @experimental
     */
    readonly tlsCertificate?: TlsCertificate;
}
/**
 * (experimental) Properties for a VirtualGateway listener.
 *
 * @experimental
 */
export interface VirtualGatewayListenerConfig {
    /**
     * (experimental) Single listener config for a VirtualGateway.
     *
     * @experimental
     */
    readonly listener: CfnVirtualGateway.VirtualGatewayListenerProperty;
}
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
export declare abstract class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http(options?: HttpGatewayListenerOptions): VirtualGatewayListener;
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2(options?: HttpGatewayListenerOptions): VirtualGatewayListener;
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpc(options?: GrpcGatewayListenerOptions): VirtualGatewayListener;
    /**
     * (experimental) Called when the GatewayListener type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity
     *
     * @experimental
     */
    abstract bind(scope: cdk.Construct): VirtualGatewayListenerConfig;
}
